/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarqube.ws.Organizations;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteOrganization;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.client.api.connected.WsHelper;
import org.sonarsource.sonarlint.core.client.api.exceptions.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.client.api.exceptions.UnsupportedServerException;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.validate.AuthenticationChecker;
import org.sonarsource.sonarlint.core.container.connected.validate.DefaultValidationResult;
import org.sonarsource.sonarlint.core.container.connected.validate.ServerVersionAndStatusChecker;
import org.sonarsource.sonarlint.core.container.model.DefaultRemoteOrganization;
import org.sonarsource.sonarlint.core.plugin.Version;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class WsHelperImpl
implements WsHelper {
    private static final String MIN_VERSION_FOR_ORGANIZATIONS = "6.3";

    public ValidationResult validateConnection(ServerConfiguration serverConfig) {
        return WsHelperImpl.validateConnection(WsHelperImpl.createClient(serverConfig), serverConfig.getOrganizationKey());
    }

    static ValidationResult validateConnection(SonarLintWsClient client, @Nullable String organizationKey) {
        ServerVersionAndStatusChecker serverChecker = new ServerVersionAndStatusChecker(client);
        AuthenticationChecker authChecker = new AuthenticationChecker(client);
        try {
            Sonarlint.ServerInfos serverStatus = serverChecker.checkVersionAndStatus();
            ValidationResult validateCredentials = authChecker.validateCredentials();
            if (validateCredentials.success() && organizationKey != null) {
                Version serverVersion = Version.create(serverStatus.getVersion());
                if (serverVersion.compareToIgnoreQualifier(Version.create(MIN_VERSION_FOR_ORGANIZATIONS)) < 0) {
                    return new DefaultValidationResult(false, "No organization support for this server version: " + serverStatus.getVersion());
                }
                if (WsHelperImpl.fetchOrganizations(client, organizationKey, new ProgressWrapper(null)).isEmpty()) {
                    return new DefaultValidationResult(false, "No organizations found for key: " + organizationKey);
                }
            }
            return validateCredentials;
        }
        catch (UnsupportedServerException e) {
            return new DefaultValidationResult(false, e.getMessage());
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
    }

    private static SonarLintWsClient createClient(ServerConfiguration serverConfig) {
        Preconditions.checkNotNull(serverConfig);
        return new SonarLintWsClient(serverConfig);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String generateAuthenticationToken(ServerVersionAndStatusChecker serverChecker, SonarLintWsClient client, String name, boolean force) {
        try {
            serverChecker.checkVersionAndStatus("5.4");
            if (force) {
                client.post("api/user_tokens/revoke?name=" + name);
            }
            try (WsResponse response = client.post("api/user_tokens/generate?name=" + name);){
                Map javaRootMapObject = new Gson().fromJson(response.content(), Map.class);
                String string = (String)javaRootMapObject.get("token");
                return string;
            }
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
    }

    public String generateAuthenticationToken(ServerConfiguration serverConfig, String name, boolean force) {
        SonarLintWsClient client = WsHelperImpl.createClient(serverConfig);
        return WsHelperImpl.generateAuthenticationToken(new ServerVersionAndStatusChecker(client), client, name, force);
    }

    public List<RemoteOrganization> listOrganizations(ServerConfiguration serverConfig, @Nullable ProgressMonitor monitor) {
        SonarLintWsClient client = WsHelperImpl.createClient(serverConfig);
        ServerVersionAndStatusChecker serverChecker = new ServerVersionAndStatusChecker(client);
        return WsHelperImpl.listOrganizations(client, serverChecker, new ProgressWrapper(monitor));
    }

    static List<RemoteOrganization> listOrganizations(SonarLintWsClient client, ServerVersionAndStatusChecker serverChecker, ProgressWrapper progress) {
        try {
            progress.setProgressAndCheckCancel("Check server version", 0.1f);
            serverChecker.checkVersionAndStatus(MIN_VERSION_FOR_ORGANIZATIONS);
            progress.setProgressAndCheckCancel("Fetch organizations", 0.2f);
            return WsHelperImpl.fetchOrganizations(client, null, progress.subProgress(0.2f, 1.0f, "Fetch organizations"));
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
    }

    private static List<RemoteOrganization> fetchOrganizations(SonarLintWsClient client, @Nullable String organizationKey, ProgressWrapper progress) {
        ArrayList<RemoteOrganization> result = new ArrayList<RemoteOrganization>();
        String url = "api/organizations/search.protobuf";
        if (organizationKey != null) {
            url = url + "?organizations=" + StringUtils.urlEncode(organizationKey);
        }
        SonarLintWsClient.getPaginated(client, url, Organizations.SearchWsResponse::parseFrom, Organizations.SearchWsResponse::getPaging, Organizations.SearchWsResponse::getOrganizationsList, org -> result.add(new DefaultRemoteOrganization((Organizations.Organization)org)), progress);
        return result;
    }
}

