/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.LoadedAnalyzer;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerIssue;
import org.sonarsource.sonarlint.core.client.api.connected.StateListener;
import org.sonarsource.sonarlint.core.client.api.connected.StorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.client.api.connected.UpdateResult;
import org.sonarsource.sonarlint.core.client.api.exceptions.GlobalUpdateRequiredException;
import org.sonarsource.sonarlint.core.client.api.exceptions.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.client.api.exceptions.StorageException;
import org.sonarsource.sonarlint.core.container.connected.ConnectedContainer;
import org.sonarsource.sonarlint.core.container.storage.StorageContainer;
import org.sonarsource.sonarlint.core.container.storage.StorageContainerHandler;
import org.sonarsource.sonarlint.core.log.SonarLintLogging;
import org.sonarsource.sonarlint.core.util.LoggedErrorHandler;
import org.sonarsource.sonarlint.core.util.ProgressWrapper;

public final class ConnectedSonarLintEngineImpl
implements ConnectedSonarLintEngine {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectedSonarLintEngineImpl.class);
    private final ConnectedGlobalConfiguration globalConfig;
    private StorageContainer storageContainer;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    private volatile ConnectedSonarLintEngine.State state = ConnectedSonarLintEngine.State.UNKNOW;
    private LogOutput logOutput = null;

    public ConnectedSonarLintEngineImpl(ConnectedGlobalConfiguration globalConfig) {
        this.globalConfig = globalConfig;
        this.logOutput = globalConfig.getLogOutput();
        this.start();
    }

    public ConnectedSonarLintEngine.State getState() {
        return this.state;
    }

    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    private void changeState(ConnectedSonarLintEngine.State state) {
        this.state = state;
        for (StateListener listener : this.stateListeners) {
            listener.stateChanged(state);
        }
    }

    private StorageContainerHandler getHandler() {
        if (this.storageContainer == null) {
            throw new IllegalStateException("SonarLint Engine for server '" + this.globalConfig.getServerId() + "' is stopped.");
        }
        return this.storageContainer.getHandler();
    }

    public StorageContainer getGlobalContainer() {
        return this.storageContainer;
    }

    public void start() {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        this.storageContainer = StorageContainer.create(this.globalConfig);
        try {
            this.storageContainer.startComponents();
            if (this.getHandler().getGlobalStorageStatus() == null) {
                this.changeState(ConnectedSonarLintEngine.State.NEVER_UPDATED);
            } else if (this.getHandler().getGlobalStorageStatus().isStale()) {
                this.changeState(ConnectedSonarLintEngine.State.NEED_UPDATE);
            } else {
                this.changeState(ConnectedSonarLintEngine.State.UPDATED);
            }
        }
        catch (StorageException e) {
            LOG.debug(e.getMessage(), e);
            this.changeState(ConnectedSonarLintEngine.State.NEED_UPDATE);
        }
        catch (RuntimeException e) {
            this.changeState(ConnectedSonarLintEngine.State.UNKNOW);
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void setLogging(@Nullable LogOutput logOutput) {
        if (logOutput != null) {
            SonarLintLogging.set(logOutput);
        } else {
            SonarLintLogging.set(this.logOutput);
        }
    }

    public AnalysisResults analyze(ConnectedAnalysisConfiguration configuration, IssueListener issueListener, @Nullable LogOutput logOutput, @Nullable ProgressMonitor monitor) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(issueListener);
        this.setLogging(logOutput);
        LoggedErrorHandler errorHandler = new LoggedErrorHandler(configuration.inputFiles());
        SonarLintLogging.setErrorHandler(errorHandler);
        return this.withReadLock(() -> {
            try {
                AnalysisResults results = this.getHandler().analyze(this.storageContainer, configuration, issueListener, new ProgressWrapper(monitor));
                errorHandler.getErrorFiles().forEach(results.failedAnalysisFiles()::add);
                return results;
            }
            catch (RuntimeException e) {
                throw SonarLintWrappedException.wrap((Throwable)e);
            }
        });
    }

    public GlobalStorageStatus getGlobalStorageStatus() {
        return this.withRwLock(this.getHandler()::getGlobalStorageStatus);
    }

    public UpdateResult update(ServerConfiguration serverConfig, @Nullable ProgressMonitor monitor) {
        Preconditions.checkNotNull(serverConfig);
        this.setLogging(null);
        return this.withRwLock(() -> {
            List analyzers;
            this.stop(false);
            this.changeState(ConnectedSonarLintEngine.State.UPDATING);
            try {
                analyzers = this.runInConnectedContainer(serverConfig, container -> container.update(new ProgressWrapper(monitor)));
            }
            finally {
                this.start();
            }
            return new UpdateResult(this.getHandler().getGlobalStorageStatus(), (Collection)analyzers);
        });
    }

    public RuleDetails getRuleDetails(String ruleKey) {
        return this.withReadLock(() -> this.getHandler().getRuleDetails(ruleKey));
    }

    public Collection<LoadedAnalyzer> getLoadedAnalyzers() {
        return this.withReadLock(() -> this.getHandler().getAnalyzers());
    }

    public StorageUpdateCheckResult checkIfGlobalStorageNeedUpdate(ServerConfiguration serverConfig, @Nullable ProgressMonitor monitor) {
        Preconditions.checkNotNull(serverConfig);
        return this.withReadLock(() -> this.runInConnectedContainer(serverConfig, container -> container.checkForUpdate(new ProgressWrapper(monitor))));
    }

    public StorageUpdateCheckResult checkIfModuleStorageNeedUpdate(ServerConfiguration serverConfig, String moduleKey, @Nullable ProgressMonitor monitor) {
        Preconditions.checkNotNull(serverConfig);
        Preconditions.checkNotNull(moduleKey);
        return this.withReadLock(() -> this.runInConnectedContainer(serverConfig, container -> container.checkForUpdate(moduleKey, new ProgressWrapper(monitor))));
    }

    public Map<String, RemoteModule> allModulesByKey() {
        return this.withReadLock(() -> this.getHandler().allModulesByKey());
    }

    public Map<String, RemoteModule> downloadAllModules(ServerConfiguration serverConfig, @Nullable ProgressMonitor monitor) {
        return this.withRwLock(() -> {
            this.checkUpdateStatus();
            return this.getHandler().downloadModuleList(serverConfig, new ProgressWrapper(monitor));
        });
    }

    private void checkUpdateStatus() {
        if (this.state != ConnectedSonarLintEngine.State.UPDATED) {
            throw new GlobalUpdateRequiredException("Please update server '" + this.globalConfig.getServerId() + "'");
        }
    }

    public List<ServerIssue> getServerIssues(String moduleKey, String filePath) {
        return this.withReadLock(() -> this.getHandler().getServerIssues(moduleKey, filePath));
    }

    public List<ServerIssue> downloadServerIssues(ServerConfiguration serverConfig, String moduleKey, String filePath) {
        return this.withRwLock(() -> {
            this.checkUpdateStatus();
            return this.getHandler().downloadServerIssues(serverConfig, moduleKey, filePath);
        });
    }

    public void downloadServerIssues(ServerConfiguration serverConfig, String moduleKey) {
        this.withRwLock(() -> {
            this.getHandler().downloadServerIssues(serverConfig, moduleKey);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateModule(ServerConfiguration serverConfig, String moduleKey, @Nullable ProgressMonitor monitor) {
        Preconditions.checkNotNull(serverConfig);
        Preconditions.checkNotNull(moduleKey);
        this.setLogging(null);
        this.rwl.writeLock().lock();
        this.checkUpdateStatus();
        ConnectedContainer connectedContainer = new ConnectedContainer(this.globalConfig, serverConfig);
        try {
            this.changeState(ConnectedSonarLintEngine.State.UPDATING);
            connectedContainer.startComponents();
            connectedContainer.updateModule(moduleKey, new ProgressWrapper(monitor));
        }
        catch (RuntimeException e) {
            try {
                throw SonarLintWrappedException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    connectedContainer.stopComponents(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.changeState(this.getHandler().getGlobalStorageStatus() != null ? ConnectedSonarLintEngine.State.UPDATED : ConnectedSonarLintEngine.State.NEVER_UPDATED);
                this.rwl.writeLock().unlock();
                throw throwable;
            }
        }
        try {
            connectedContainer.stopComponents(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changeState(this.getHandler().getGlobalStorageStatus() != null ? ConnectedSonarLintEngine.State.UPDATED : ConnectedSonarLintEngine.State.NEVER_UPDATED);
        this.rwl.writeLock().unlock();
    }

    public ModuleStorageStatus getModuleStorageStatus(String moduleKey) {
        Preconditions.checkNotNull(moduleKey);
        return this.withReadLock(() -> this.getHandler().getModuleStorageStatus(moduleKey), false);
    }

    public void stop(boolean deleteStorage) {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        try {
            if (this.storageContainer == null) {
                return;
            }
            if (deleteStorage) {
                this.getHandler().deleteStorage();
            }
            this.storageContainer.stopComponents(false);
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.storageContainer = null;
            this.changeState(ConnectedSonarLintEngine.State.UNKNOW);
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> U runInConnectedContainer(ServerConfiguration serverConfig, Function<ConnectedContainer, U> func) {
        ConnectedContainer connectedContainer = new ConnectedContainer(this.globalConfig, serverConfig);
        connectedContainer.startComponents();
        U u = func.apply(connectedContainer);
        return u;
        finally {
            try {
                connectedContainer.stopComponents(false);
            }
            catch (Exception exception) {}
        }
    }

    private <T> T withRwLock(Supplier<T> callable) {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        try {
            T t = callable.get();
            return t;
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private <T> T withReadLock(Supplier<T> callable) {
        return this.withReadLock(callable, true);
    }

    private <T> T withReadLock(Supplier<T> callable, boolean checkUpdateStatus) {
        this.setLogging(null);
        this.rwl.readLock().lock();
        try {
            if (checkUpdateStatus) {
                this.checkUpdateStatus();
            }
            T t = callable.get();
            return t;
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }
}

