/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.statement;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.duplications.CodeFragment;
import org.sonar.duplications.token.Token;

public class Statement
implements CodeFragment {
    private final int startLine;
    private final int endLine;
    private final String value;
    private int hash;

    public Statement(int startLine, int endLine, String value) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.value = value;
    }

    public Statement(@Nullable List<Token> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            throw new IllegalArgumentException("A statement can't be initialized with an empty list of tokens");
        }
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            sb.append(token.getValue());
        }
        this.value = sb.toString();
        this.startLine = tokens.get(0).getLine();
        this.endLine = tokens.get(tokens.size() - 1).getLine();
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.value.hashCode();
            h = 31 * h + this.startLine;
            this.hash = h = 31 * h + this.endLine;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        return this.startLine == other.startLine && this.endLine == other.endLine && this.value.equals(other.value);
    }

    public String toString() {
        return "[" + this.getStartLine() + "-" + this.getEndLine() + "] [" + this.getValue() + "]";
    }
}

