/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.original;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.utils.FastStringComparator;

final class BlocksGroup {
    protected final List<Block> blocks = new ArrayList<Block>();
    private static final Comparator<String> RESOURCE_ID_COMPARATOR = FastStringComparator.INSTANCE;

    public static BlocksGroup empty() {
        return new BlocksGroup();
    }

    private BlocksGroup() {
    }

    public int size() {
        return this.blocks.size();
    }

    public boolean subsumedBy(BlocksGroup other, int indexCorrection) {
        return BlocksGroup.subsumedBy(this, other, indexCorrection);
    }

    public BlocksGroup intersect(BlocksGroup other) {
        return BlocksGroup.intersect(this, other);
    }

    public List<Block[]> pairs(BlocksGroup other, int len) {
        return BlocksGroup.pairs(this, other, len);
    }

    @CheckForNull
    public Block first(String resourceId) {
        for (Block block : this.blocks) {
            if (!resourceId.equals(block.getResourceId())) continue;
            return block;
        }
        return null;
    }

    public String toString() {
        return this.blocks.toString();
    }

    private static BlocksGroup intersect(BlocksGroup group1, BlocksGroup group2) {
        BlocksGroup intersection = new BlocksGroup();
        List<Block> list1 = group1.blocks;
        List<Block> list2 = group2.blocks;
        int i = 0;
        int j = 0;
        while (i < list1.size() && j < list2.size()) {
            Block block1 = list1.get(i);
            Block block2 = list2.get(j);
            int c = RESOURCE_ID_COMPARATOR.compare(block1.getResourceId(), block2.getResourceId());
            if (c > 0) {
                ++j;
                continue;
            }
            if (c < 0) {
                ++i;
                continue;
            }
            if (c == 0) {
                c = block1.getIndexInFile() + 1 - block2.getIndexInFile();
            }
            if (c == 0) {
                ++i;
                ++j;
                intersection.blocks.add(block2);
            }
            if (c > 0) {
                ++j;
            }
            if (c >= 0) continue;
            ++i;
        }
        return intersection;
    }

    private static boolean subsumedBy(BlocksGroup group1, BlocksGroup group2, int indexCorrection) {
        List<Block> list1 = group1.blocks;
        List<Block> list2 = group2.blocks;
        int i = 0;
        int j = 0;
        while (i < list1.size() && j < list2.size()) {
            Block block1 = list1.get(i);
            Block block2 = list2.get(j);
            int c = RESOURCE_ID_COMPARATOR.compare(block1.getResourceId(), block2.getResourceId());
            if (c != 0) {
                ++j;
                continue;
            }
            c = block1.getIndexInFile() - indexCorrection - block2.getIndexInFile();
            if (c < 0) break;
            if (c != 0) {
                ++j;
            }
            if (c != 0) continue;
            ++i;
            ++j;
        }
        return i == list1.size();
    }

    private static List<Block[]> pairs(BlocksGroup beginGroup, BlocksGroup endGroup, int len) {
        ArrayList<Block[]> result = new ArrayList<Block[]>();
        List<Block> beginBlocks = beginGroup.blocks;
        List<Block> endBlocks = endGroup.blocks;
        int i = 0;
        int j = 0;
        while (i < beginBlocks.size() && j < endBlocks.size()) {
            Block beginBlock = beginBlocks.get(i);
            Block endBlock = endBlocks.get(j);
            int c = RESOURCE_ID_COMPARATOR.compare(beginBlock.getResourceId(), endBlock.getResourceId());
            if (c == 0) {
                c = beginBlock.getIndexInFile() + len - 1 - endBlock.getIndexInFile();
            }
            if (c == 0) {
                result.add(new Block[]{beginBlock, endBlock});
                ++i;
                ++j;
            }
            if (c > 0) {
                ++j;
            }
            if (c >= 0) continue;
            ++i;
        }
        return result;
    }

    public static class BlockComparator
    implements Comparator<Block> {
        public static final BlockComparator INSTANCE = new BlockComparator();

        @Override
        public int compare(Block b1, Block b2) {
            int c = RESOURCE_ID_COMPARATOR.compare(b1.getResourceId(), b2.getResourceId());
            if (c == 0) {
                return b1.getIndexInFile() - b2.getIndexInFile();
            }
            return c;
        }
    }
}

