/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFilePredicates;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.FileExtensionPredicate;
import org.sonar.api.batch.fs.internal.OptimizedFilePredicateAdapter;
import org.sonar.api.internal.google.common.collect.LinkedHashMultimap;
import org.sonar.api.internal.google.common.collect.SetMultimap;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.PathUtils;

public class DefaultFileSystem
implements FileSystem {
    private final Cache cache;
    private final Path baseDir;
    private Path workDir;
    private Charset encoding;
    protected final FilePredicates predicates;
    private Function<FilePredicate, Predicate<InputFile>> defaultPredicateFactory;

    public DefaultFileSystem(Path baseDir) {
        this(baseDir, new MapCache());
    }

    public DefaultFileSystem(File baseDir) {
        this(baseDir.toPath(), new MapCache());
    }

    protected DefaultFileSystem(Path baseDir, Cache cache) {
        this.baseDir = baseDir;
        this.cache = cache;
        this.predicates = new DefaultFilePredicates(this.baseDir);
    }

    public Path baseDirPath() {
        return this.baseDir;
    }

    @Override
    public File baseDir() {
        return this.baseDir.toFile();
    }

    public DefaultFileSystem setEncoding(Charset e) {
        this.encoding = e;
        return this;
    }

    @Override
    public Charset encoding() {
        return this.encoding;
    }

    public DefaultFileSystem setWorkDir(Path d) {
        this.workDir = d;
        return this;
    }

    public DefaultFileSystem setDefaultPredicate(@Nullable Function<FilePredicate, Predicate<InputFile>> defaultPredicateFactory) {
        this.defaultPredicateFactory = defaultPredicateFactory;
        return this;
    }

    @Override
    public File workDir() {
        return this.workDir.toFile();
    }

    @Override
    public InputFile inputFile(FilePredicate predicate) {
        Iterable<InputFile> files = this.inputFiles(predicate);
        Iterator<InputFile> iterator = files.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        InputFile first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    public Iterable<InputFile> inputFiles() {
        return OptimizedFilePredicateAdapter.create(this.predicates.all()).get(this.cache);
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate predicate) {
        Iterable<InputFile> iterable = OptimizedFilePredicateAdapter.create(predicate).get(this.cache);
        if (this.defaultPredicateFactory != null) {
            return StreamSupport.stream(iterable.spliterator(), false).filter(this.defaultPredicateFactory.apply(predicate)).collect(Collectors.toList());
        }
        return iterable;
    }

    @Override
    public boolean hasFiles(FilePredicate predicate) {
        return this.inputFiles(predicate).iterator().hasNext();
    }

    @Override
    public Iterable<File> files(FilePredicate predicate) {
        return () -> StreamSupport.stream(this.inputFiles(predicate).spliterator(), false).map(InputFile::file).iterator();
    }

    @Override
    public InputDir inputDir(File dir) {
        String relativePath = PathUtils.sanitize(new PathResolver().relativePath(this.baseDir.toFile(), dir));
        if (relativePath == null) {
            return null;
        }
        return this.cache.inputDir(relativePath);
    }

    public DefaultFileSystem add(InputFile inputFile) {
        this.cache.add(inputFile);
        return this;
    }

    public DefaultFileSystem add(DefaultInputDir inputDir) {
        this.cache.add(inputDir);
        return this;
    }

    @Override
    public SortedSet<String> languages() {
        return this.cache.languages();
    }

    @Override
    public FilePredicates predicates() {
        return this.predicates;
    }

    @Override
    public File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(this.baseDir(), path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to resolve path '" + path + "'", e);
            }
        }
        return file;
    }

    private static class MapCache
    extends Cache {
        private final Map<String, InputFile> fileMap = new HashMap<String, InputFile>();
        private final Map<String, InputDir> dirMap = new HashMap<String, InputDir>();
        private final SetMultimap<String, InputFile> filesByNameCache = LinkedHashMultimap.create();
        private final SetMultimap<String, InputFile> filesByExtensionCache = LinkedHashMultimap.create();
        private SortedSet<String> languages = new TreeSet<String>();

        private MapCache() {
        }

        @Override
        public Iterable<InputFile> inputFiles() {
            return new ArrayList<InputFile>(this.fileMap.values());
        }

        @Override
        public InputFile inputFile(String relativePath) {
            return this.fileMap.get(relativePath);
        }

        @Override
        public InputDir inputDir(String relativePath) {
            return this.dirMap.get(relativePath);
        }

        @Override
        public Iterable<InputFile> getFilesByName(String filename) {
            return this.filesByNameCache.get(filename);
        }

        @Override
        public Iterable<InputFile> getFilesByExtension(String extension) {
            return this.filesByExtensionCache.get(extension);
        }

        @Override
        protected void doAdd(InputFile inputFile) {
            if (inputFile.language() != null) {
                this.languages.add(inputFile.language());
            }
            this.fileMap.put(inputFile.relativePath(), inputFile);
            this.filesByNameCache.put(inputFile.filename(), inputFile);
            this.filesByExtensionCache.put(FileExtensionPredicate.getExtension(inputFile), inputFile);
        }

        @Override
        protected void doAdd(InputDir inputDir) {
            this.dirMap.put(inputDir.relativePath(), inputDir);
        }

        @Override
        protected SortedSet<String> languages() {
            return this.languages;
        }
    }

    public static abstract class Cache
    implements FileSystem.Index {
        protected abstract void doAdd(InputFile var1);

        protected abstract void doAdd(InputDir var1);

        final void add(InputFile inputFile) {
            this.doAdd(inputFile);
        }

        public void add(InputDir inputDir) {
            this.doAdd(inputDir);
        }

        protected abstract SortedSet<String> languages();
    }
}

