/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties;

import java.util.List;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.jobs.BuildProjectJob;
import net.sf.eclipsecs.core.jobs.ConfigureDeconfigureNatureJob;
import net.sf.eclipsecs.core.jobs.TransformCheckstyleRulesJob;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationWorkingCopy;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginPrefs;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationWorkingSetEditor;
import net.sf.eclipsecs.ui.properties.ComplexFileSetsEditor;
import net.sf.eclipsecs.ui.properties.IFileSetsEditor;
import net.sf.eclipsecs.ui.properties.SimpleFileSetsEditor;
import net.sf.eclipsecs.ui.properties.filter.IFilterEditor;
import net.sf.eclipsecs.ui.properties.filter.PluginFilterEditors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class CheckstylePropertyPage
extends PropertyPage {
    private TabFolder mMainTab = null;
    private Button mChkEnable;
    private Button mChkSimpleConfig;
    private Button mChkSyncFormatter;
    private Composite mFileSetsContainer;
    private IFileSetsEditor mFileSetsEditor;
    private CheckboxTableViewer mFilterList;
    private Button mBtnEditFilter;
    private Text mTxtFilterDescription;
    private PageController mPageController;
    private ProjectConfigurationWorkingCopy mProjectConfig;
    private CheckConfigurationWorkingSetEditor mWorkingSetEditor;
    private boolean mCheckstyleInitiallyActivated;

    public ProjectConfigurationWorkingCopy getProjectConfigurationWorkingCopy() {
        return this.mProjectConfig;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        IProject project = null;
        try {
            IResource resource = (IResource)element;
            if (resource.getType() == 4) {
                project = (IProject)resource;
            }
            IProjectConfiguration projectConfig = ProjectConfigurationFactory.getConfiguration(project);
            this.mProjectConfig = new ProjectConfigurationWorkingCopy(projectConfig);
            this.mCheckstyleInitiallyActivated = project.hasNature("net.sf.eclipsecs.core.CheckstyleNature");
        }
        catch (CoreException e) {
            this.handleConfigFileError((Exception)((Object)e), project);
        }
        catch (CheckstylePluginException e) {
            this.handleConfigFileError((Exception)((Object)e), project);
        }
    }

    private void handleConfigFileError(Exception e, IProject project) {
        CheckstyleLog.log((Throwable)e, (String)Messages.errorOpeningPropertiesPage);
        CheckstyleUIPlugin.warningDialog(null, Messages.errorOpeningPropertiesPage, e);
        IProjectConfiguration projectConfig = ProjectConfigurationFactory.createDefaultProjectConfiguration((IProject)project);
        this.mProjectConfig = new ProjectConfigurationWorkingCopy(projectConfig);
        try {
            this.mCheckstyleInitiallyActivated = project.hasNature("net.sf.eclipsecs.core.CheckstyleNature");
        }
        catch (CoreException e1) {
            CheckstyleUIPlugin.errorDialog(null, e1.getMessage(), e1, true);
        }
    }

    public Control createContents(Composite parent) {
        Composite container = null;
        try {
            this.mPageController = new PageController();
            this.noDefaultAndApplyButton();
            this.mMainTab = new TabFolder(parent, 128);
            this.mMainTab.setLayoutData((Object)new GridData(1808));
            this.mMainTab.addSelectionListener((SelectionListener)this.mPageController);
            container = new Composite((Composite)this.mMainTab, 0);
            container.setLayout((Layout)new FormLayout());
            container.setLayoutData((Object)new GridData(1808));
            this.mChkSimpleConfig = new Button(container, 32);
            this.mChkSimpleConfig.setText(Messages.CheckstylePropertyPage_btnUseSimpleConfig);
            this.mChkSimpleConfig.addSelectionListener((SelectionListener)this.mPageController);
            this.mChkSimpleConfig.setSelection(this.mProjectConfig.isUseSimpleConfig());
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 3);
            fd.right = new FormAttachment(100, -3);
            this.mChkSimpleConfig.setLayoutData((Object)fd);
            this.mChkEnable = new Button(container, 32);
            this.mChkEnable.setText(Messages.CheckstylePropertyPage_btnActivateCheckstyle);
            this.mChkEnable.addSelectionListener((SelectionListener)this.mPageController);
            this.mChkEnable.setSelection(this.mCheckstyleInitiallyActivated);
            fd = new FormData();
            fd.left = new FormAttachment(0, 3);
            fd.top = new FormAttachment(0, 3);
            fd.right = new FormAttachment((Control)this.mChkSimpleConfig, 3, 16384);
            this.mChkEnable.setLayoutData((Object)fd);
            this.mChkSyncFormatter = new Button(container, 32);
            this.mChkSyncFormatter.setText(Messages.CheckstylePropertyPage_btnSyncFormatter);
            this.mChkSyncFormatter.addSelectionListener((SelectionListener)this.mPageController);
            this.mChkSyncFormatter.setSelection(this.mProjectConfig.isSyncFormatter());
            fd = new FormData();
            fd.left = new FormAttachment(0, 3);
            fd.top = new FormAttachment((Control)this.mChkEnable, 3, 1024);
            this.mChkSyncFormatter.setLayoutData((Object)fd);
            this.mFileSetsContainer = new Composite(container, 0);
            Control configArea = this.createFileSetsArea(this.mFileSetsContainer);
            fd = new FormData();
            fd.left = new FormAttachment(0, 3);
            fd.top = new FormAttachment((Control)this.mChkSyncFormatter, 6, 1024);
            fd.right = new FormAttachment(100, -3);
            fd.bottom = new FormAttachment(45);
            configArea.setLayoutData((Object)fd);
            Control filterArea = this.createFilterArea(container);
            fd = new FormData();
            fd.left = new FormAttachment(0, 3);
            fd.top = new FormAttachment(configArea, 3, 1024);
            fd.right = new FormAttachment(100, -3);
            fd.bottom = new FormAttachment(100, -3);
            fd.width = 500;
            filterArea.setLayoutData((Object)fd);
            Control localConfigArea = this.createLocalConfigArea((Composite)this.mMainTab);
            TabItem mainItem = new TabItem(this.mMainTab, 0);
            mainItem.setControl((Control)container);
            mainItem.setText(Messages.CheckstylePropertyPage_tabMain);
            TabItem localItem = new TabItem(this.mMainTab, 0);
            localItem.setControl(localConfigArea);
            localItem.setText(Messages.CheckstylePropertyPage_tabCheckConfigs);
        }
        catch (CheckstylePluginException e) {
            CheckstyleUIPlugin.errorDialog(this.getShell(), Messages.errorOpeningPropertiesPage, e, true);
        }
        return container;
    }

    private Control createFileSetsArea(Composite fileSetsContainer) throws CheckstylePluginException {
        Control[] controls = fileSetsContainer.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.mFileSetsEditor = this.mProjectConfig.isUseSimpleConfig() ? new SimpleFileSetsEditor(this) : new ComplexFileSetsEditor(this);
        this.mFileSetsEditor.setFileSets(this.mProjectConfig.getFileSets());
        Control editor = this.mFileSetsEditor.createContents(this.mFileSetsContainer);
        fileSetsContainer.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0);
        fd.top = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        editor.setLayoutData((Object)fd);
        return fileSetsContainer;
    }

    private Control createFilterArea(Composite container) {
        IFilter filter;
        Group filterArea = new Group(container, 0);
        filterArea.setText(Messages.CheckstylePropertyPage_titleFilterGroup);
        filterArea.setLayout((Layout)new FormLayout());
        this.mFilterList = CheckboxTableViewer.newCheckList((Composite)filterArea, (int)2048);
        this.mBtnEditFilter = new Button((Composite)filterArea, 8);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 3);
        fd.top = new FormAttachment(0, 3);
        fd.right = new FormAttachment((Control)this.mBtnEditFilter, -3, 16384);
        fd.bottom = new FormAttachment(60, -3);
        this.mFilterList.getTable().setLayoutData((Object)fd);
        this.mFilterList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                StringBuffer buf = new StringBuffer();
                if (element instanceof IFilter) {
                    IFilter filter = (IFilter)element;
                    buf.append(filter.getName());
                    if (filter.getPresentableFilterData() != null) {
                        buf.append(": ").append(filter.getPresentableFilterData());
                    }
                } else {
                    buf.append(super.getText(element));
                }
                return buf.toString();
            }
        });
        this.mFilterList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mFilterList.addSelectionChangedListener((ISelectionChangedListener)this.mPageController);
        this.mFilterList.addDoubleClickListener((IDoubleClickListener)this.mPageController);
        this.mFilterList.addCheckStateListener((ICheckStateListener)this.mPageController);
        this.mBtnEditFilter.setText(Messages.CheckstylePropertyPage_btnChangeFilter);
        this.mBtnEditFilter.addSelectionListener((SelectionListener)this.mPageController);
        fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        this.mBtnEditFilter.setLayoutData((Object)fd);
        Label lblDesc = new Label((Composite)filterArea, 16384);
        lblDesc.setText(Messages.CheckstylePropertyPage_lblDescription);
        fd = new FormData();
        fd.left = new FormAttachment(0, 3);
        fd.top = new FormAttachment((Control)this.mFilterList.getTable(), 3, 1024);
        fd.right = new FormAttachment(100, -3);
        lblDesc.setLayoutData((Object)fd);
        this.mTxtFilterDescription = new Text((Composite)filterArea, 19018);
        fd = new FormData();
        fd.left = new FormAttachment(0, 3);
        fd.top = new FormAttachment((Control)lblDesc, 3, 1024);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment(100, -3);
        this.mTxtFilterDescription.setLayoutData((Object)fd);
        List filterDefs = this.mProjectConfig.getFilters();
        this.mFilterList.setInput((Object)filterDefs);
        int i = 0;
        while (i < filterDefs.size()) {
            filter = (IFilter)filterDefs.get(i);
            this.mFilterList.setChecked((Object)filter, filter.isEnabled());
            ++i;
        }
        i = 0;
        while (i < filterDefs.size()) {
            filter = (IFilter)filterDefs.get(i);
            this.mFilterList.setGrayed((Object)filter, filter.isReadonly());
            ++i;
        }
        this.mBtnEditFilter.setEnabled(false);
        return filterArea;
    }

    private Control createLocalConfigArea(Composite parent) {
        Composite noteAndEditor = new Composite(parent, 0);
        noteAndEditor.setLayout((Layout)new GridLayout(1, false));
        noteAndEditor.setLayoutData((Object)new GridData(1808));
        Label lblHint = new Label(noteAndEditor, 64);
        lblHint.setText(Messages.CheckstylePropertyPage_msgLocalConfigs);
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        lblHint.setLayoutData((Object)gd);
        this.mWorkingSetEditor = new CheckConfigurationWorkingSetEditor(this.mProjectConfig.getLocalCheckConfigWorkingSet(), false);
        Control editorControl = this.mWorkingSetEditor.createContents(noteAndEditor);
        editorControl.setLayoutData((Object)new GridData(1808));
        return noteAndEditor;
    }

    public boolean isValid() {
        if (this.mProjectConfig != null) {
            List fileSets = this.mProjectConfig.getFileSets();
            for (FileSet fileset : fileSets) {
                ICheckConfiguration checkConfig = fileset.getCheckConfig();
                if (checkConfig == null) continue;
                try {
                    checkConfig.getCheckstyleConfiguration();
                }
                catch (CheckstylePluginException checkstylePluginException) {
                    this.setErrorMessage(NLS.bind((String)Messages.errorCannotResolveCheckLocation, (Object)checkConfig.getLocation(), (Object)checkConfig.getName()));
                    return false;
                }
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean performOk() {
        try {
            IProject project = this.mProjectConfig.getProject();
            if (this.mProjectConfig.isDirty()) {
                this.mProjectConfig.store();
            }
            boolean checkstyleEnabled = this.mChkEnable.getSelection();
            boolean needRebuild = this.mProjectConfig.isRebuildNeeded();
            if (checkstyleEnabled != this.mCheckstyleInitiallyActivated) {
                ConfigureDeconfigureNatureJob configOperation = new ConfigureDeconfigureNatureJob(project, "net.sf.eclipsecs.core.CheckstyleNature");
                configOperation.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                configOperation.schedule();
                boolean bl = needRebuild = needRebuild || !this.mCheckstyleInitiallyActivated;
            }
            if (checkstyleEnabled && this.mProjectConfig.isSyncFormatter()) {
                TransformCheckstyleRulesJob transFormJob = new TransformCheckstyleRulesJob(project);
                transFormJob.schedule();
            }
            if (checkstyleEnabled && needRebuild) {
                boolean doRebuild;
                String promptRebuildPref = CheckstyleUIPluginPrefs.getString("ask.before.rebuild");
                boolean bl = doRebuild = "always".equals(promptRebuildPref) && needRebuild;
                if ("prompt".equals(promptRebuildPref) && needRebuild) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)Messages.CheckstylePropertyPage_titleRebuild, (String)Messages.CheckstylePropertyPage_msgRebuild, (String)Messages.CheckstylePropertyPage_nagRebuild, (boolean)false, (IPreferenceStore)CheckstyleUIPlugin.getDefault().getPreferenceStore(), (String)"ask.before.rebuild");
                    boolean bl2 = doRebuild = dialog.getReturnCode() == 2;
                }
                if (checkstyleEnabled && doRebuild) {
                    BuildProjectJob rebuildOperation = new BuildProjectJob(project, 6);
                    rebuildOperation.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    rebuildOperation.schedule();
                }
            }
        }
        catch (CheckstylePluginException e) {
            CheckstyleUIPlugin.errorDialog(this.getShell(), e, true);
        }
        return true;
    }

    private class PageController
    extends SelectionAdapter
    implements ISelectionChangedListener,
    ICheckStateListener,
    IDoubleClickListener {
        private PageController() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == CheckstylePropertyPage.this.mBtnEditFilter) {
                ISelection selection = CheckstylePropertyPage.this.mFilterList.getSelection();
                this.openFilterEditor(selection);
                CheckstylePropertyPage.this.getContainer().updateButtons();
            }
            if (source == CheckstylePropertyPage.this.mMainTab) {
                CheckstylePropertyPage.this.mFileSetsEditor.refresh();
                CheckstylePropertyPage.this.getContainer().updateButtons();
            } else if (source == CheckstylePropertyPage.this.mChkSyncFormatter) {
                CheckstylePropertyPage.this.mProjectConfig.setSyncFormatter(CheckstylePropertyPage.this.mChkSyncFormatter.getSelection());
            } else if (source == CheckstylePropertyPage.this.mChkSimpleConfig) {
                try {
                    CheckstylePropertyPage.this.mProjectConfig.setUseSimpleConfig(CheckstylePropertyPage.this.mChkSimpleConfig.getSelection());
                    boolean showWarning = CheckstyleUIPluginPrefs.getBoolean("warn.before.losing.filesets");
                    if (CheckstylePropertyPage.this.mProjectConfig.isUseSimpleConfig() && showWarning) {
                        MessageDialogWithToggle dialog = new MessageDialogWithToggle(CheckstylePropertyPage.this.getShell(), Messages.CheckstylePropertyPage_titleWarnFilesets, null, Messages.CheckstylePropertyPage_msgWarnFilesets, 4, new String[]{IDialogConstants.OK_LABEL}, 0, Messages.CheckstylePropertyPage_mgsWarnFileSetNagOption, showWarning){

                            protected void buttonPressed(int buttonId) {
                                this.getPrefStore().setValue(this.getPrefKey(), this.getToggleState());
                                this.setReturnCode(buttonId);
                                this.close();
                            }
                        };
                        dialog.setPrefStore(CheckstyleUIPlugin.getDefault().getPreferenceStore());
                        dialog.setPrefKey("warn.before.losing.filesets");
                        dialog.open();
                    }
                    CheckstylePropertyPage.this.createFileSetsArea(CheckstylePropertyPage.this.mFileSetsContainer);
                    CheckstylePropertyPage.this.mFileSetsContainer.redraw();
                    CheckstylePropertyPage.this.mFileSetsContainer.update();
                    CheckstylePropertyPage.this.mFileSetsContainer.layout();
                }
                catch (CheckstylePluginException ex) {
                    CheckstyleUIPlugin.errorDialog(CheckstylePropertyPage.this.getShell(), Messages.errorChangingFilesetEditor, ex, true);
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedElement;
            ISelection selection;
            Object source = event.getSource();
            if (source == CheckstylePropertyPage.this.mFilterList && (selection = event.getSelection()) instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IFilter) {
                IFilter filterDef = (IFilter)selectedElement;
                CheckstylePropertyPage.this.mTxtFilterDescription.setText(filterDef.getDescription());
                CheckstylePropertyPage.this.mBtnEditFilter.setEnabled(PluginFilterEditors.hasEditor(filterDef));
            }
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof IFilter) {
                IFilter filter = (IFilter)element;
                if (!filter.isReadonly()) {
                    filter.setEnabled(event.getChecked());
                } else {
                    event.getCheckable().setChecked(event.getElement(), true);
                }
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            this.openFilterEditor(event.getSelection());
        }

        private void openFilterEditor(ISelection selection) {
            Object selectedElement;
            if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IFilter) {
                try {
                    IFilter aFilterDef = (IFilter)selectedElement;
                    if (!PluginFilterEditors.hasEditor(aFilterDef)) {
                        return;
                    }
                    IFilterEditor editableFilter = PluginFilterEditors.getNewEditor(aFilterDef);
                    editableFilter.setInputProject(CheckstylePropertyPage.this.mProjectConfig.getProject());
                    editableFilter.setFilterData(aFilterDef.getFilterData());
                    if (editableFilter.openEditor(CheckstylePropertyPage.this.getShell()) == 0) {
                        aFilterDef.setFilterData(editableFilter.getFilterData());
                        CheckstylePropertyPage.this.mFilterList.refresh();
                    }
                }
                catch (CheckstylePluginException ex) {
                    CheckstyleUIPlugin.errorDialog(CheckstylePropertyPage.this.getShell(), ex, true);
                }
            }
        }
    }
}

