/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.CheckstyleUIPluginPrefs;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetFactory;
import net.sf.eclipsecs.ui.config.widgets.IConfigPropertyWidget;
import net.sf.eclipsecs.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class RuleConfigurationEditDialog
extends TitleAreaDialog {
    private final Module mRule;
    private TabFolder mMainTab;
    private Text mCommentText;
    private Text mIdText;
    private ComboViewer mSeverityCombo;
    private IConfigPropertyWidget[] mConfigPropertyWidgets;
    private Button mBtnTranslate;
    private Button mBtnSort;
    private Map<String, Text> mCustomMessages;
    private boolean mReadonly = false;
    private final String mTitle;

    RuleConfigurationEditDialog(Shell parent, Module rule, boolean readonly, String title) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mRule = rule;
        this.mReadonly = readonly;
        this.mTitle = title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.mMainTab = new TabFolder(composite, 0);
        this.mMainTab.setLayoutData((Object)new GridData(1808));
        Composite generalSettings = this.createGeneralSection();
        Composite advancedSettings = this.createAdvancedSection();
        TabItem mainItem = new TabItem(this.mMainTab, 0);
        mainItem.setControl((Control)generalSettings);
        mainItem.setText(Messages.RuleConfigurationEditDialog_tabGeneral);
        TabItem advancedItem = new TabItem(this.mMainTab, 0);
        advancedItem.setControl((Control)advancedSettings);
        advancedItem.setText(Messages.RuleConfigurationEditDialog_tabAdvanced);
        this.initialize();
        return composite;
    }

    private Composite createGeneralSection() {
        Composite generalSettings = new Composite((Composite)this.mMainTab, 0);
        generalSettings.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        generalSettings.setLayout((Layout)layout);
        Label lblSeverity = new Label(generalSettings, 0);
        lblSeverity.setText(Messages.RuleConfigurationEditDialog_lblSeverity);
        lblSeverity.setLayoutData((Object)new GridData());
        this.mSeverityCombo = new ComboViewer(generalSettings);
        this.mSeverityCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mSeverityCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Severity)element).name();
            }
        });
        this.mSeverityCombo.getControl().setLayoutData((Object)new GridData());
        Group properties = new Group(generalSettings, 0);
        properties.setLayout((Layout)new GridLayout(3, false));
        properties.setText(Messages.RuleConfigurationEditDialog_lblProperties);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        properties.setLayoutData((Object)gd);
        this.createConfigPropertyEntries((Composite)properties);
        if (this.mConfigPropertyWidgets == null || this.mConfigPropertyWidgets.length == 0) {
            properties.dispose();
        }
        return generalSettings;
    }

    private Composite createAdvancedSection() {
        Composite advancedSettings = new Composite((Composite)this.mMainTab, 0);
        advancedSettings.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        advancedSettings.setLayout((Layout)layout);
        Label commentLabel = new Label(advancedSettings, 0);
        commentLabel.setText(Messages.RuleConfigurationEditDialog_lblComment);
        commentLabel.setLayoutData((Object)new GridData());
        this.mCommentText = new Text(advancedSettings, 2052);
        this.mCommentText.setLayoutData((Object)new GridData(768));
        Label idLabel = new Label(advancedSettings, 0);
        idLabel.setText(Messages.RuleConfigurationEditDialog_lblId);
        idLabel.setLayoutData((Object)new GridData());
        this.mIdText = new Text(advancedSettings, 2052);
        this.mIdText.setLayoutData((Object)new GridData(768));
        Group messagesGroup = new Group(advancedSettings, 0);
        messagesGroup.setText(Messages.RuleConfigurationEditDialog_titleCustMsg);
        messagesGroup.setLayout((Layout)new GridLayout(2, false));
        GridData d = new GridData(768);
        d.horizontalSpan = 2;
        messagesGroup.setLayoutData((Object)d);
        this.mCustomMessages = new HashMap<String, Text>();
        TreeSet msgKeys = new TreeSet();
        msgKeys.addAll(this.mRule.getMetaData().getMessageKeys());
        msgKeys.addAll(this.mRule.getCustomMessages().keySet());
        for (String msgKey : msgKeys) {
            Label msgLabel = new Label((Composite)messagesGroup, 0);
            msgLabel.setText(msgKey);
            msgLabel.setLayoutData((Object)new GridData());
            final Text msgText = new Text((Composite)messagesGroup, 2052);
            msgText.setLayoutData((Object)new GridData(768));
            final String standardMessage = MetadataFactory.getStandardMessage((String)msgKey, (String)this.mRule.getMetaData().getInternalName());
            if (standardMessage != null) {
                msgText.setText(standardMessage);
            }
            msgText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (msgText.getText().equals(standardMessage)) {
                                msgText.selectAll();
                            }
                        }
                    });
                }

                public void focusLost(FocusEvent e) {
                }
            });
            String message = (String)this.mRule.getCustomMessages().get(msgKey);
            if (Strings.emptyToNull((String)message) != null) {
                msgText.setText(message);
            }
            msgText.setEnabled(!this.mReadonly);
            this.mCustomMessages.put(msgKey, msgText);
        }
        return advancedSettings;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.mBtnTranslate = new Button(composite, 32);
        this.mBtnTranslate.setText(Messages.RuleConfigurationEditDialog_btnTranslateTokens);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 5;
        this.mBtnTranslate.setLayoutData((Object)gd);
        this.mBtnTranslate.setSelection(CheckstyleUIPluginPrefs.getBoolean("translate.checkstyle.tokens"));
        this.mBtnTranslate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CheckstyleUIPluginPrefs.setBoolean("translate.checkstyle.tokens", ((Button)e.widget).getSelection());
                }
                catch (BackingStoreException e1) {
                    CheckstyleLog.log((Throwable)e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mBtnSort = new Button(composite, 32);
        this.mBtnSort.setText(Messages.RuleConfigurationEditDialog_btnSortTokens);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 5;
        this.mBtnSort.setLayoutData((Object)gd);
        this.mBtnSort.setSelection(CheckstyleUIPluginPrefs.getBoolean("translate.sort.tokens"));
        this.mBtnSort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CheckstyleUIPluginPrefs.setBoolean("translate.sort.tokens", ((Button)e.widget).getSelection());
                }
                catch (BackingStoreException e1) {
                    CheckstyleLog.log((Throwable)e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Control buttonBar = super.createButtonBar(composite);
        gd = new GridData(768);
        gd.horizontalAlignment = 3;
        buttonBar.setLayoutData((Object)gd);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button defautlt = this.createButton(parent, 14, Messages.RuleConfigurationEditDialog_btnDefaul, false);
        defautlt.setEnabled(!this.mReadonly);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void initialize() {
        String id;
        this.setTitle(NLS.bind((String)Messages.RuleConfigurationEditDialog_titleRuleConfigEditor, (Object)this.mRule.getName()));
        if (!this.mReadonly) {
            this.setMessage(Messages.RuleConfigurationEditDialog_msgEditRuleConfig);
        } else {
            this.setMessage(Messages.RuleConfigurationEditDialog_msgReadonlyModule);
        }
        String comment = this.mRule.getComment();
        if (comment != null) {
            this.mCommentText.setText(comment);
        }
        if ((id = this.mRule.getId()) != null) {
            this.mIdText.setText(id);
        }
        this.mIdText.setEnabled(!this.mReadonly);
        this.mCommentText.setEnabled(!this.mReadonly);
        this.mSeverityCombo.setInput((Object)Severity.values());
        this.mSeverityCombo.getCombo().setEnabled(!this.mReadonly);
        if (this.mRule.getMetaData().hasSeverity()) {
            this.mSeverityCombo.setSelection((ISelection)new StructuredSelection((Object)this.mRule.getSeverity()));
        } else {
            this.mSeverityCombo.getCombo().setEnabled(false);
        }
        this.setTitleImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.PLUGIN_LOGO));
    }

    protected void buttonPressed(int buttonId) {
        if (14 == buttonId) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.RuleConfigurationEditDialog_titleRestoreDefault, (String)Messages.RuleConfigurationEditDialog_msgRestoreDefault)) {
                if (this.mRule.getMetaData().hasSeverity()) {
                    this.mSeverityCombo.setSelection((ISelection)new StructuredSelection((Object)this.mRule.getMetaData().getDefaultSeverityLevel()));
                    this.mCommentText.setText(new String());
                }
                int size = this.mConfigPropertyWidgets != null ? this.mConfigPropertyWidgets.length : 0;
                int i = 0;
                while (i < size) {
                    this.mConfigPropertyWidgets[i].restorePropertyDefault();
                    ++i;
                }
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        Severity severity = this.mRule.getSeverity();
        try {
            severity = (Severity)((IStructuredSelection)this.mSeverityCombo.getSelection()).getFirstElement();
        }
        catch (IllegalArgumentException e) {
            CheckstyleLog.log((Throwable)e);
        }
        String comment = Strings.emptyToNull((String)this.mCommentText.getText());
        String id = Strings.emptyToNull((String)this.mIdText.getText());
        for (Map.Entry<String, Text> entry : this.mCustomMessages.entrySet()) {
            String message;
            String msgKey = entry.getKey();
            String standardMessage = MetadataFactory.getStandardMessage((String)msgKey, (String)this.mRule.getMetaData().getInternalName());
            if (standardMessage == null) {
                standardMessage = "";
            }
            if ((message = Strings.emptyToNull((String)entry.getValue().getText())) != null && !message.equals(standardMessage)) {
                this.mRule.getCustomMessages().put(msgKey, message);
                continue;
            }
            this.mRule.getCustomMessages().remove(msgKey);
        }
        if (this.mConfigPropertyWidgets != null) {
            int i = 0;
            while (i < this.mConfigPropertyWidgets.length) {
                IConfigPropertyWidget widget = this.mConfigPropertyWidgets[i];
                ConfigProperty property = widget.getConfigProperty();
                try {
                    widget.validate();
                }
                catch (CheckstylePluginException checkstylePluginException) {
                    String message = NLS.bind((String)Messages.RuleConfigurationEditDialog_msgInvalidPropertyValue, (Object)property.getMetaData().getName());
                    this.setErrorMessage(message);
                    return;
                }
                property.setValue(widget.getValue());
                ++i;
            }
        }
        this.mRule.setSeverity(severity);
        this.mRule.setComment(comment);
        this.mRule.setId(id);
        super.okPressed();
    }

    private void createConfigPropertyEntries(Composite parent) {
        List configItemMetadata = this.mRule.getProperties();
        if (configItemMetadata.size() <= 0) {
            return;
        }
        this.mConfigPropertyWidgets = new IConfigPropertyWidget[configItemMetadata.size()];
        Iterator iter = configItemMetadata.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ConfigProperty prop = (ConfigProperty)iter.next();
            this.mConfigPropertyWidgets[i] = ConfigPropertyWidgetFactory.createWidget(parent, prop, this.getShell());
            this.mConfigPropertyWidgets[i].setEnabled(!this.mReadonly);
            ++i;
        }
    }

    public void create() {
        super.create();
        SWTUtil.addResizeSupport((Dialog)this, CheckstyleUIPlugin.getDefault().getDialogSettings(), String.valueOf(RuleConfigurationEditDialog.class.getName()) + "#" + this.mRule.getMetaData().getInternalName());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.mTitle);
    }
}

