/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.matcher.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;

public class WrappingBeansAndJavaModelLabelProvider
extends LabelProvider {
    private JavaElementLabelProvider javaLabelProvider = new JavaElementLabelProvider(307);
    private BeansModelLabelProvider beansLabelProvider = new BeansModelLabelProvider();
    private List<ILabelDecorator> labelDecorators;
    protected ListenerList listeners = new ListenerList();

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.labelDecorators == null) {
            this.labelDecorators = new ArrayList<ILabelDecorator>(2);
        }
        this.labelDecorators.add(decorator);
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.labelDecorators != null) {
            for (ILabelDecorator decorator : this.labelDecorators) {
                decorator.addListener(listener);
            }
        }
        this.listeners.add((Object)listener);
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.labelDecorators != null && image != null) {
            for (ILabelDecorator decorator : this.labelDecorators) {
                image = decorator.decorateImage(image, element);
            }
        }
        return image;
    }

    protected String decorateText(String text, Object element) {
        if (this.labelDecorators != null && text.length() > 0) {
            for (ILabelDecorator decorator : this.labelDecorators) {
                String decorated = decorator.decorateText(text, element);
                if (decorated == null) continue;
                text = decorated;
            }
        }
        return text;
    }

    public void dispose() {
        this.javaLabelProvider.dispose();
        this.beansLabelProvider.dispose();
        if (this.labelDecorators != null) {
            int i = 0;
            while (i < this.labelDecorators.size()) {
                ILabelDecorator decorator = this.labelDecorators.get(i);
                decorator.dispose();
                ++i;
            }
            this.labelDecorators = null;
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof IAopReference) {
            image = this.javaLabelProvider.getImage((Object)((IAopReference)element).getTarget());
        } else if (element instanceof IBeansModelElement) {
            image = this.beansLabelProvider.getImage(element);
        } else if (element instanceof IResource) {
            image = this.beansLabelProvider.getImage(element);
        }
        if (image != null) {
            return this.decorateImage(image, element);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof IAopReference) {
            text = this.javaLabelProvider.getText((Object)((IAopReference)element).getTarget());
        } else if (element instanceof IMethod) {
            text = this.javaLabelProvider.getText(element);
        } else if (element instanceof IBeansModelElement) {
            text = this.beansLabelProvider.getText(element);
        } else if (element instanceof IResource) {
            text = ((IResource)element).getProjectRelativePath().toString();
        }
        if (text != null) {
            return this.decorateText(text, element);
        }
        return super.getText(element);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.labelDecorators != null) {
            for (ILabelDecorator decorator : this.labelDecorators) {
                decorator.removeListener(listener);
            }
        }
        this.listeners.remove((Object)listener);
    }
}

