/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.m2e.wro4j.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.osgi.util.NLS;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class Wro4jBuildParticipant
extends MojoExecutionBuildParticipant {
    private static final String M2E_WRO4J_WTP_INTEGRATION_KEY = "m2e.wro4j.wtp.integration";
    private static final String CONTEXT_FOLDER = "contextFolder";
    private static final String TOKEN_SEPARATOR = ",\\s*";
    private static final Pattern WRO4J_FILES_PATTERN = Pattern.compile("^(\\/?.*\\/)?wro\\.(xml|groovy|properties)$");
    private static final Pattern WEB_RESOURCES_PATTERN = Pattern.compile("([^\\s]+(\\.(?i)(js|css|scss|sass|less|coffee|json|template))$)");
    private static final String DESTINATION_FOLDER = "destinationFolder";
    private static final String CSS_DESTINATION_FOLDER = "cssDestinationFolder";
    private static final String JS_DESTINATION_FOLDER = "jsDestinationFolder";
    private static final String GROUP_NAME_MAPPING_FILE = "groupNameMappingFile";
    private BuildContext currentBuildContext;

    public Wro4jBuildParticipant(MojoExecution execution) {
        super(execution, true);
    }

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        BuildContext originalBuildContext;
        MojoExecution mojoExecution = this.getMojoExecution();
        if (mojoExecution == null) {
            return null;
        }
        this.currentBuildContext = originalBuildContext = super.getBuildContext();
        Collection<File> sources = this.getContextRoots(this.getMavenProjectFacade(), mojoExecution);
        if (this.notCleanFullBuild(kind)) {
            ArrayList<String> includedFiles = new ArrayList<String>();
            for (File source : sources) {
                Scanner ds = this.currentBuildContext.newScanner(source);
                ds.scan();
                includedFiles.addAll(Arrays.asList(ds.getIncludedFiles()));
            }
            if (this.isPomModified() || this.interestingFileChangeDetected(includedFiles, WRO4J_FILES_PATTERN)) {
                this.getMavenProjectFacade().getProject();
                this.currentBuildContext = new CleanBuildContext(originalBuildContext);
            } else if (!this.interestingFileChangeDetected(includedFiles, WEB_RESOURCES_PATTERN)) {
                return null;
            }
        }
        Xpp3Dom originalConfiguration = mojoExecution.getConfiguration();
        Set result = null;
        try {
            File destinationFolder = this.getLocation(mojoExecution, DESTINATION_FOLDER);
            File jsDestinationFolder = this.getLocation(mojoExecution, JS_DESTINATION_FOLDER);
            File cssDestinationFolder = this.getLocation(mojoExecution, CSS_DESTINATION_FOLDER);
            File groupNameMappingFile = this.getLocation(mojoExecution, GROUP_NAME_MAPPING_FILE);
            Xpp3Dom customConfiguration = this.customize(originalConfiguration, sources, destinationFolder, jsDestinationFolder, cssDestinationFolder, groupNameMappingFile);
            mojoExecution.setConfiguration(customConfiguration);
            if (monitor != null) {
                String taskName = NLS.bind((String)"Invoking {0} on {1}", (Object)this.getMojoExecution().getMojoDescriptor().getFullGoalName(), (Object)this.getMavenProjectFacade().getProject().getName());
                monitor.setTaskName(taskName);
            }
            ThreadBuildContext.setThreadBuildContext((BuildContext)this.currentBuildContext);
            result = super.build(kind, monitor);
            this.refreshWorkspace(mojoExecution, originalBuildContext);
        }
        finally {
            mojoExecution.setConfiguration(originalConfiguration);
            ThreadBuildContext.setThreadBuildContext((BuildContext)originalBuildContext);
        }
        return result;
    }

    private Collection<File> getContextRoots(IMavenProjectFacade facade, MojoExecution mojoExecution) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        String contextRoots = (String)maven.getMojoParameterValue(this.getSession(), mojoExecution, CONTEXT_FOLDER, String.class);
        ArrayList<File> locations = new ArrayList<File>();
        if (contextRoots != null) {
            String[] crs = contextRoots.split(TOKEN_SEPARATOR);
            IPath root = facade.getProject().getLocation();
            String[] stringArray = crs;
            int n = crs.length;
            int n2 = 0;
            while (n2 < n) {
                String cr = stringArray[n2];
                String location = cr.trim();
                if (!location.isEmpty()) {
                    File l = new File(location);
                    if (l.isAbsolute()) {
                        locations.add(l);
                    } else {
                        locations.add(root.append(location).toFile());
                    }
                }
                ++n2;
            }
        }
        if (locations.isEmpty()) {
            locations.add(new File("src/main/webapp"));
        }
        return locations;
    }

    private File getLocation(MojoExecution mojoExecution, String parameterName) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        File location = (File)maven.getMojoParameterValue(this.getSession(), mojoExecution, parameterName, File.class);
        return location;
    }

    private boolean interestingFileChangeDetected(Collection<String> includedFiles, Pattern pattern) throws CoreException {
        if (includedFiles == null || includedFiles.isEmpty()) {
            return false;
        }
        for (String file : includedFiles) {
            String portableFile = file.replace('\\', '/');
            Matcher m = pattern.matcher(portableFile);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isPomModified() {
        IMavenProjectFacade facade = this.getMavenProjectFacade();
        IResourceDelta delta = this.getDelta(facade.getProject());
        if (delta == null) {
            return false;
        }
        return delta.findMember(facade.getPom().getProjectRelativePath()) != null;
    }

    private void refreshWorkspace(MojoExecution mojoExecution, BuildContext buildContext) throws CoreException {
        this.refreshResource(mojoExecution, buildContext, DESTINATION_FOLDER);
        this.refreshResource(mojoExecution, buildContext, CSS_DESTINATION_FOLDER);
        this.refreshResource(mojoExecution, buildContext, JS_DESTINATION_FOLDER);
        this.refreshResource(mojoExecution, buildContext, GROUP_NAME_MAPPING_FILE);
    }

    private void refreshResource(MojoExecution mojoExecution, BuildContext buildContext, String parameterName) throws CoreException {
        File location = this.getLocation(mojoExecution, parameterName);
        if (location != null && location.exists()) {
            buildContext.refresh(location);
        }
    }

    private Xpp3Dom customize(Xpp3Dom originalConfiguration, Collection<File> contextFolders, File originalDestinationFolder, File originalJsDestinationFolder, File originalCssDestinationFolder, File originalGroupNameMappingFile) throws IOException, CoreException {
        IMavenProjectFacade facade = this.getMavenProjectFacade();
        if (!"war".equals(facade.getPackaging())) {
            return originalConfiguration;
        }
        Xpp3Dom customConfiguration = new Xpp3Dom("configuration");
        Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)customConfiguration, (Xpp3Dom)originalConfiguration);
        IProject project = facade.getProject();
        String target = facade.getMavenProject().getBuild().getDirectory();
        IPath relativeTargetPath = MavenProjectUtils.getProjectRelativePath((IProject)project, (String)target);
        if (relativeTargetPath == null) {
            return customConfiguration;
        }
        IFolder m2eWtpFolder = project.getFolder(relativeTargetPath.append("m2e-wtp"));
        if (!m2eWtpFolder.exists() || this.isWtpIntegrationDisabled(facade.getMavenProject((IProgressMonitor)new NullProgressMonitor()))) {
            return customConfiguration;
        }
        IFolder webResourcesFolder = m2eWtpFolder.getFolder("web-resources");
        Path fullTargetPath = new Path(target);
        IPath defaultOutputPathPrefix = fullTargetPath.append(facade.getMavenProject().getBuild().getFinalName());
        this.fixContextFolders(customConfiguration, contextFolders);
        this.customizeLocation(originalDestinationFolder, webResourcesFolder, defaultOutputPathPrefix, customConfiguration, DESTINATION_FOLDER);
        this.customizeLocation(originalJsDestinationFolder, webResourcesFolder, defaultOutputPathPrefix, customConfiguration, JS_DESTINATION_FOLDER);
        this.customizeLocation(originalCssDestinationFolder, webResourcesFolder, defaultOutputPathPrefix, customConfiguration, CSS_DESTINATION_FOLDER);
        this.customizeLocation(originalGroupNameMappingFile, webResourcesFolder, defaultOutputPathPrefix, customConfiguration, GROUP_NAME_MAPPING_FILE);
        return customConfiguration;
    }

    private boolean isWtpIntegrationDisabled(MavenProject mavenProject) {
        Properties properties = mavenProject.getProperties();
        String isWtpIntegrationProperty = properties.getProperty(M2E_WRO4J_WTP_INTEGRATION_KEY, Boolean.TRUE.toString());
        return !Boolean.parseBoolean(isWtpIntegrationProperty);
    }

    private void customizeLocation(File originalDestinationFolder, IFolder webResourcesFolder, IPath defaultOutputPathPrefix, Xpp3Dom configuration, String parameterName) throws IOException {
        IPath customPath;
        if (originalDestinationFolder != null && (customPath = this.getReplacementPath(originalDestinationFolder, webResourcesFolder, defaultOutputPathPrefix)) != null) {
            Xpp3Dom dom = configuration.getChild(parameterName);
            if (dom == null) {
                dom = new Xpp3Dom(parameterName);
                configuration.addChild(dom);
            }
            dom.setValue(customPath.toOSString());
        }
    }

    private void fixContextFolders(Xpp3Dom configuration, Collection<File> contextFolders) throws IOException {
        if (contextFolders == null || contextFolders.isEmpty()) {
            return;
        }
        StringBuilder customContextFolders = new StringBuilder();
        boolean addComma = false;
        for (File folder : contextFolders) {
            if (addComma) {
                customContextFolders.append(", ");
            }
            customContextFolders.append(folder.getAbsolutePath().replace('\\', '/'));
            addComma = true;
        }
        Xpp3Dom dom = configuration.getChild(CONTEXT_FOLDER);
        if (dom == null) {
            dom = new Xpp3Dom(CONTEXT_FOLDER);
            configuration.addChild(dom);
        }
        dom.setValue(customContextFolders.toString());
    }

    private IPath getReplacementPath(File originalFolder, IFolder webResourcesFolder, IPath defaultOutputPathPrefix) throws IOException {
        IPath originalDestinationFolderPath = Path.fromOSString((String)originalFolder.getCanonicalPath());
        if (!defaultOutputPathPrefix.isPrefixOf(originalDestinationFolderPath)) {
            return null;
        }
        IPath relativePath = originalDestinationFolderPath.makeRelativeTo(defaultOutputPathPrefix);
        IPath customPath = webResourcesFolder.getLocation().append(relativePath);
        return customPath;
    }

    private boolean notCleanFullBuild(int kind) {
        return 6 != kind && 15 != kind;
    }

    private static class CleanBuildContext
    implements BuildContext {
        private BuildContext originalContext;

        CleanBuildContext(BuildContext originalContext) {
            this.originalContext = originalContext;
        }

        public boolean hasDelta(String relpath) {
            return true;
        }

        public boolean hasDelta(File file) {
            return true;
        }

        public boolean hasDelta(List relpaths) {
            return true;
        }

        public void refresh(File file) {
            this.originalContext.refresh(file);
        }

        public OutputStream newFileOutputStream(File file) throws IOException {
            return this.originalContext.newFileOutputStream(file);
        }

        public Scanner newScanner(File basedir) {
            return this.originalContext.newScanner(basedir);
        }

        public Scanner newDeleteScanner(File basedir) {
            return this.originalContext.newDeleteScanner(basedir);
        }

        public Scanner newScanner(File basedir, boolean ignoreDelta) {
            return this.originalContext.newScanner(basedir, ignoreDelta);
        }

        public boolean isIncremental() {
            return false;
        }

        public void setValue(String key, Object value) {
            this.originalContext.setValue(key, value);
        }

        public Object getValue(String key) {
            return this.originalContext.getValue(key);
        }

        public void addWarning(File file, int line, int column, String message, Throwable cause) {
            this.originalContext.addWarning(file, line, column, message, cause);
        }

        public void addError(File file, int line, int column, String message, Throwable cause) {
            this.originalContext.addError(file, line, column, message, cause);
        }

        public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
            this.originalContext.addMessage(file, line, column, message, severity, cause);
        }

        public void removeMessages(File file) {
            this.originalContext.removeMessages(file);
        }

        public boolean isUptodate(File target, File source) {
            return false;
        }
    }
}

