/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.IWebflowProjectDescriptionConstants;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.WebflowProjectDescription;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WebflowProjectDescriptionHandler
extends DefaultHandler
implements IWebflowProjectDescriptionConstants {
    protected static final int S_INITIAL = 0;
    protected static final int S_PROJECT_DESC = 1;
    protected static final int S_CONFIGS = 2;
    protected static final int S_CONFIG = 3;
    protected static final int S_BEAN_CONFIG = 4;
    protected static final int S_FILE = 5;
    protected static final int S_NAME = 6;
    protected IWebflowProject project;
    protected IWebflowConfig webflowConfig;
    protected MultiStatus problems;
    protected WebflowProjectDescription description;
    protected int state;
    protected final StringBuffer charBuffer = new StringBuffer();
    protected Locator locator;

    public WebflowProjectDescriptionHandler(IWebflowProject project) {
        this.project = project;
        this.problems = new MultiStatus("org.springframework.ide.eclipse.webflow.core", 567, "Error reading Spring project description", null);
        this.description = new WebflowProjectDescription(project);
        this.state = 0;
    }

    public IStatus getStatus() {
        return this.problems;
    }

    public WebflowProjectDescription getDescription() {
        return this.description;
    }

    @Override
    public void startElement(String uri, String elementName, String qname, Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        switch (this.state) {
            case 0: {
                if (!elementName.equals("webflow-project-description")) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!elementName.equals("configs")) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (!elementName.equals("config")) break;
                this.state = 3;
                break;
            }
            case 3: {
                this.state = elementName.equals("file") ? 5 : (elementName.equals("beans-config") ? 4 : (elementName.equals("name") ? 6 : 3));
            }
        }
    }

    @Override
    public void endElement(String uri, String elementName, String qname) throws SAXException {
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                if (!elementName.equals("configs")) break;
                this.state = 1;
                break;
            }
            case 6: {
                if (!elementName.equals("name")) break;
                String config = this.charBuffer.toString().trim();
                if (this.webflowConfig != null) {
                    this.webflowConfig.setName(config);
                    this.state = 4;
                    break;
                }
                this.state = 4;
                break;
            }
            case 5: {
                if (elementName.equals("file")) {
                    String config = this.charBuffer.toString().trim();
                    IFile file = this.project.getProject().getFile(config);
                    if (file.exists()) {
                        this.webflowConfig = this.description.addConfig(file);
                        this.state = 6;
                        break;
                    }
                    this.state = 3;
                    break;
                }
                this.state = 3;
                break;
            }
            case 3: {
                if (elementName.equals("config")) {
                    this.state = 3;
                    break;
                }
                this.state = 1;
                break;
            }
            case 4: {
                if (elementName.equals("beans-config")) {
                    String config = this.charBuffer.toString().trim();
                    if (this.webflowConfig == null) break;
                    this.webflowConfig.addBeansConfigElementId(config);
                    break;
                }
                this.state = 3;
            }
        }
        this.charBuffer.setLength(0);
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.charBuffer.append(chars, offset, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void fatalError(SAXParseException error) throws SAXException {
        this.log(4, error);
        throw error;
    }

    @Override
    public void error(SAXParseException error) throws SAXException {
        this.log(2, error);
    }

    @Override
    public void warning(SAXParseException error) throws SAXException {
        this.log(2, error);
    }

    public void log(int code, Throwable error) {
        this.log(code, error.getMessage(), error);
    }

    public void log(int code, String errorMessage, Throwable error) {
        this.problems.add((IStatus)new Status(code, "org.springframework.ide.eclipse.webflow.core", 567, errorMessage, error));
    }
}

