/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.dialogs;

import com.collabnet.subversion.merge.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExcludedRevisionsDialog
extends TrayDialog {
    private String fromUrl;
    private Map<String, Set<String>> excludedRevisions;
    private ExcludedRevision[] excludedRevisionArray;
    private Table table;
    private TableViewer viewer;
    private String[] columnHeaders = new String[]{Messages.ExcludedRevisionsDialog_revision, Messages.ExcludedRevisionsDialog_url};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(75, 75, true), new ColumnWeightData(450, 450, true)};

    public ExcludedRevisionsDialog(Shell shell, String fromUrl, Map<String, Set<String>> excludedRevisions) {
        super(shell);
        this.fromUrl = fromUrl;
        this.excludedRevisions = excludedRevisions;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.getExcludedRevisions();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ExcludedRevisionsDialog_title);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        label.setText(Messages.ExcludedRevisionsDialog_text);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Label fromLabel = new Label(composite, 0);
        fromLabel.setText(Messages.ExcludedRevisionsDialog_mergeFrom);
        Text fromText = new Text(composite, 2048);
        fromText.setEditable(false);
        fromText.setText(this.fromUrl);
        data = new GridData(768);
        fromText.setLayoutData((Object)data);
        this.table = new Table(composite, 66304);
        data = new GridData(768);
        data.heightHint = 200;
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ExcludedRevisionsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExcludedRevisionsLabelProvider());
        int i = 0;
        while (i < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        this.viewer.setInput((Object)this);
        return composite;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    private void getExcludedRevisions() {
        ArrayList<ExcludedRevision> excludedRevisionList = new ArrayList<ExcludedRevision>();
        Set<String> keySet = this.excludedRevisions.keySet();
        for (String key : keySet) {
            Set<String> revisionSet = this.excludedRevisions.get(key);
            for (String rev : revisionSet) {
                ExcludedRevision excludedRevision = new ExcludedRevision(rev, key);
                if (excludedRevisionList.contains(excludedRevision)) continue;
                excludedRevisionList.add(excludedRevision);
            }
        }
        this.excludedRevisionArray = new ExcludedRevision[excludedRevisionList.size()];
        excludedRevisionList.toArray(this.excludedRevisionArray);
        Arrays.sort(this.excludedRevisionArray);
    }

    class ExcludedRevision
    implements Comparable {
        private String revision;
        private String url;

        public ExcludedRevision(String revision, String url) {
            this.revision = revision;
            this.url = url;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object compareTo) {
            if (compareTo instanceof ExcludedRevision) {
                ExcludedRevision compareToRevision = (ExcludedRevision)compareTo;
                return compareToRevision.getRevision().equals(this.revision) && compareToRevision.getUrl().equals(this.url);
            }
            return super.equals(compareTo);
        }

        public int compareTo(Object compareTo) {
            int rev;
            ExcludedRevision compareToRevision = (ExcludedRevision)compareTo;
            int compareRev = Integer.parseInt(compareToRevision.getRevision());
            if (compareRev < (rev = Integer.parseInt(this.revision))) {
                return -1;
            }
            if (compareRev > rev) {
                return 1;
            }
            return this.url.compareTo(compareToRevision.getUrl());
        }
    }

    class ExcludedRevisionsContentProvider
    implements IStructuredContentProvider {
        ExcludedRevisionsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return ExcludedRevisionsDialog.this.excludedRevisionArray;
        }
    }

    static class ExcludedRevisionsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ExcludedRevisionsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ExcludedRevision excludedRevision = (ExcludedRevision)element;
            switch (columnIndex) {
                case 0: {
                    return excludedRevision.getRevision();
                }
                case 1: {
                    return excludedRevision.getUrl();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

