/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.SVNConflictResolver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MergeResult
implements IPropertySource,
Comparable {
    private String action;
    private String propertyAction;
    private String treeConflictAction;
    private String path;
    private boolean error;
    private String conflictResolution = " ";
    private String propertyResolution = " ";
    private String treeConflictResolution = " ";
    private IResource resource;
    private int type = 1;
    private MergeOutput mergeOutput;
    public static final String ACTION_CONFLICT = "C";
    public static final String ACTION_CHANGE = "U";
    public static final String ACTION_ADD = "A";
    public static final String ACTION_MERGE = "G";
    public static final String ACTION_DELETE = "D";
    public static final String ACTION_SKIP = "S";
    public static final String ACTION_EXISTING = "E";
    public static final int FILE = 1;
    public static final int FOLDER = 2;
    public static String P_ID_RESOURCE = "resource";
    public static String P_RESOURCE = Messages.MergeResult_resource;
    public static String P_ID_TEXT_STATUS = "textSts";
    public static String P_TEXT_STATUS = Messages.MergeResult_textStatus;
    public static String P_ID_PROPERTY_STATUS = "propSts";
    public static String P_PROPERTY_STATUS = Messages.MergeResult_propsStatus;
    public static String P_ID_TREE_CONFLICT = "treeConflict";
    public static String P_TREE_CONFLICT = Messages.MergeResult_treeConflict;
    public static List descriptors = new ArrayList();
    public static List descriptorsNoTreeConflict;

    static {
        descriptors.add(new PropertyDescriptor((Object)P_ID_RESOURCE, P_RESOURCE));
        descriptors.add(new PropertyDescriptor((Object)P_ID_TEXT_STATUS, P_TEXT_STATUS));
        descriptors.add(new PropertyDescriptor((Object)P_ID_PROPERTY_STATUS, P_PROPERTY_STATUS));
        descriptors.add(new PropertyDescriptor((Object)P_ID_TREE_CONFLICT, P_TREE_CONFLICT));
        descriptorsNoTreeConflict = new ArrayList();
        descriptorsNoTreeConflict.add(new PropertyDescriptor((Object)P_ID_RESOURCE, P_RESOURCE));
        descriptorsNoTreeConflict.add(new PropertyDescriptor((Object)P_ID_TEXT_STATUS, P_TEXT_STATUS));
        descriptorsNoTreeConflict.add(new PropertyDescriptor((Object)P_ID_PROPERTY_STATUS, P_PROPERTY_STATUS));
    }

    public MergeResult(String action, String propertyAction, String treeConflictAction, String path, boolean error) {
        this.action = action;
        this.propertyAction = propertyAction;
        this.treeConflictAction = treeConflictAction;
        this.path = path;
        this.error = error;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isSkip() {
        return this.action != null && this.action.equals(ACTION_SKIP);
    }

    public String toString() {
        String tag = null;
        tag = this.error ? "Error:   " : "Message: ";
        return String.valueOf(tag) + this.type + " " + this.action + " " + this.propertyAction + " " + this.conflictResolution + " " + this.propertyResolution + " " + this.treeConflictAction + " " + this.treeConflictResolution + " " + this.path;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getPropertyAction() {
        return this.propertyAction;
    }

    public void setPropertyAction(String propertyAction) {
        this.propertyAction = propertyAction;
    }

    public String getTreeConflictAction() {
        return this.treeConflictAction;
    }

    public void setTreeConflictAction(String treeConflictAction) {
        this.treeConflictAction = treeConflictAction;
    }

    public boolean isConflicted() {
        return this.action.equals(ACTION_CONFLICT);
    }

    public boolean isPropertyConflicted() {
        return this.propertyAction.equals(ACTION_CONFLICT);
    }

    public boolean hasTreeConflict() {
        return this.treeConflictAction != null && this.treeConflictAction.equals(ACTION_CONFLICT);
    }

    public boolean isDelete() {
        return this.action.equals(ACTION_DELETE);
    }

    public boolean isPropertyDelete() {
        return this.propertyAction.equals(ACTION_DELETE);
    }

    public String getConflictResolution() {
        return this.conflictResolution;
    }

    public void setConflictResolution(String conflictResolution) {
        this.conflictResolution = conflictResolution;
    }

    public boolean isResolved() {
        return !this.isConflicted() || this.conflictResolution != null && this.conflictResolution.trim().length() > 0;
    }

    public String getPropertyResolution() {
        return this.propertyResolution;
    }

    public void setPropertyResolution(String propertyResolution) {
        this.propertyResolution = propertyResolution;
    }

    public boolean isPropertyResolved() {
        return !this.isPropertyConflicted() || this.propertyResolution != null && this.propertyResolution.trim().length() > 0;
    }

    public String getTreeConflictResolution() {
        return this.treeConflictResolution;
    }

    public void setTreeConflictResolution(String treeConflictResolution) {
        this.treeConflictResolution = treeConflictResolution;
    }

    public boolean isTreeConflictResolved() {
        return !this.hasTreeConflict() || this.treeConflictResolution != null && this.treeConflictResolution.trim().length() > 0;
    }

    public int compareTo(Object compare) {
        if (!(compare instanceof MergeResult)) {
            return 0;
        }
        MergeResult compareResult = (MergeResult)compare;
        return this.path.compareTo(compareResult.getPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof MergeResult) {
            MergeResult compareToResult = (MergeResult)obj;
            return compareToResult.getPath().equals(this.path);
        }
        return super.equals(obj);
    }

    public MergeOutput getMergeOutput() {
        return this.mergeOutput;
    }

    public void setMergeOutput(MergeOutput mergeOutput) {
        this.mergeOutput = mergeOutput;
    }

    public Object getEditableValue() {
        return this.resource.getFullPath().toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return MergeResult.getDescriptors(this.hasTreeConflict()).toArray(new IPropertyDescriptor[MergeResult.getDescriptors(this.hasTreeConflict()).size()]);
    }

    private static List getDescriptors(boolean treeConflict) {
        if (treeConflict) {
            return descriptors;
        }
        return descriptorsNoTreeConflict;
    }

    public Object getPropertyValue(Object id) {
        if (P_ID_RESOURCE.equals(id)) {
            return this.resource.getFullPath().toString();
        }
        if (P_ID_TEXT_STATUS.equals(id)) {
            if (this.action.equals(ACTION_ADD)) {
                return Messages.MergeResult_added;
            }
            if (this.action.equals(ACTION_CHANGE) || this.action.equals(ACTION_MERGE)) {
                return Messages.MergeResult_modified;
            }
            if (this.action.equals(ACTION_DELETE)) {
                return Messages.MergeResult_deleted;
            }
            if (this.action.equals(ACTION_EXISTING)) {
                return Messages.MergeResult_existing;
            }
            if (this.action.equals(ACTION_SKIP)) {
                return Messages.MergeResult_skipped;
            }
            if (this.action.equals(ACTION_CONFLICT)) {
                if (this.isResolved()) {
                    return String.valueOf(Messages.MergeResult_resolvedConflict) + SVNConflictResolver.getResolutionDescription(this.conflictResolution) + Messages.MergeResult_33;
                }
                return Messages.MergeResult_conflicted;
            }
        }
        if (P_ID_PROPERTY_STATUS.equals(id)) {
            if (this.propertyAction.equals(ACTION_ADD)) {
                return Messages.MergeResult_added;
            }
            if (this.propertyAction.equals(ACTION_CHANGE) || this.propertyAction.equals(ACTION_MERGE)) {
                return Messages.MergeResult_modified;
            }
            if (this.propertyAction.equals(ACTION_DELETE)) {
                return Messages.MergeResult_deleted;
            }
            if (this.propertyAction.equals(ACTION_SKIP)) {
                return Messages.MergeResult_skipped;
            }
            if (this.propertyAction.equals(ACTION_CONFLICT)) {
                if (this.isPropertyResolved()) {
                    return String.valueOf(Messages.MergeResult_resolvedConflict) + SVNConflictResolver.getResolutionDescription(this.propertyResolution) + ")";
                }
                return Messages.MergeResult_conflicted;
            }
        }
        if (P_ID_TREE_CONFLICT.equals(id)) {
            if (this.treeConflictAction != null && this.treeConflictAction.equals(ACTION_CONFLICT)) {
                if (this.isTreeConflictResolved()) {
                    return Messages.MergeResult_resolved;
                }
                return Messages.MergeResult_unresolved;
            }
            return "";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

