/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.wizard.Messages;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.core.WizardContentAssistConverter;
import org.springframework.ide.eclipse.wizard.ui.AbstractBeanWizardPage;
import org.springframework.ide.eclipse.wizard.ui.BeanChildDialog;
import org.springframework.ide.eclipse.wizard.ui.BeanWizard;
import org.springframework.ide.eclipse.wizard.ui.ConstructorArgDialog;
import org.springframework.ide.eclipse.wizard.ui.PropertyDialog;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanPropertiesWizardPage
extends AbstractBeanWizardPage {
    private Table propertiesTable;
    private Table constructorArgsTable;
    private Image[] errorImages;
    private Image[] warningImages;
    private int propertyProblemCounter;
    private int constArgProblemCounter;
    private static final int PROPERTY = 0;
    private static final int CONSTRUCTOR_ARG = 1;
    private final Set<String> definedProperties;
    private ComboViewer constructorCombo;
    private IStructuredContentProvider comboContentProvider;
    private static final String DEFAULT_MESSAGE = Messages.getString("BeanPropertiesWizardPage.TITLE_DESCRIPTION");
    private Button ignoreErrorButton;
    private static final String ICON_PATH_PREFIX = "icons/full/etool16/";
    private static final String ERROR_ICON = "error.gif";
    private static final String WARNING_ICON = "warning.gif";
    private static final String ERROR_ICON2 = "error2.gif";
    private static final String WARNING_ICON2 = "warning2.gif";

    protected BeanPropertiesWizardPage(String pageName, BeanWizard wizard) {
        super(pageName, wizard);
        this.setTitle(Messages.getString("BeanPropertiesWizardPage.TITLE"));
        this.setDescription(Messages.getString("BeanPropertiesWizardPage.TITLE_DESCRIPTION"));
        this.definedProperties = new HashSet<String>();
        this.propertyProblemCounter = 0;
        this.constArgProblemCounter = 0;
    }

    protected boolean checkCanProceed(int kind) {
        if (kind == 0) {
            return true;
        }
        if (!this.constructorCombo.getSelection().isEmpty()) {
            boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("BeanPropertiesWizardPage.CONFIRM_CONSTRUCTOR_CHANGE_DIALOG_TITLE"), (String)Messages.getString("BeanPropertiesWizardPage.CONFIRM_CONSTRUCTOR_CHANGE_DIALOG_MESSAGE"));
            if (confirmed) {
                this.constructorCombo.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            return confirmed;
        }
        return true;
    }

    private void createButtons(final int kind, Composite parent, final String nodeName, final Table table) {
        Composite rightContainer = new Composite(parent, 0);
        rightContainer.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout rightLayout = new GridLayout();
        rightLayout.marginHeight = 0;
        rightLayout.marginWidth = 0;
        rightContainer.setLayout((Layout)rightLayout);
        GridData buttonData = new GridData();
        Button addButton = new Button(rightContainer, 0);
        addButton.setText(Messages.getString("BeanPropertiesWizardPage.ADD_BUTTON_LABEL"));
        addButton.setLayoutData((Object)buttonData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BeanPropertiesWizardPage.this.checkCanProceed(kind)) {
                    IDOMElement newElement = BeanPropertiesWizardPage.this.createNewChild(kind, nodeName);
                    String title = null;
                    if (kind == 0) {
                        title = Messages.getString("BeanPropertiesWizardPage.NEW_PROPERTY_DIALOG_TITLE");
                    } else if (kind == 1) {
                        title = Messages.getString("BeanPropertiesWizardPage.NEW_CONSTRUCTOR_ARG_DIALOG_TITLE");
                    }
                    BeanChildDialog dialog = BeanPropertiesWizardPage.this.createDialog(kind, newElement, title, true);
                    int status = dialog.open();
                    if (status == 0) {
                        BeanPropertiesWizardPage.this.createElementItem(kind, newElement);
                    } else {
                        BeanPropertiesWizardPage.this.wizard.getNewBean().removeChild((Node)newElement);
                    }
                }
            }
        });
        Button editButton = new Button(rightContainer, 0);
        editButton.setText(Messages.getString("BeanPropertiesWizardPage.EDIT_LABEL"));
        editButton.setLayoutData((Object)buttonData);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeanPropertiesWizardPage.this.editSelectedElementItem(kind, table);
            }
        });
        Button removeButton = new Button(rightContainer, 0);
        removeButton.setText(Messages.getString("BeanPropertiesWizardPage.REMOVE_LABEL"));
        removeButton.setLayoutData((Object)buttonData);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BeanPropertiesWizardPage.this.checkCanProceed(kind)) {
                    BeanPropertiesWizardPage.this.removeSelected(kind, table);
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BeanPropertiesWizardPage.this.editSelectedElementItem(kind, table);
            }
        });
    }

    private void createCombo(Composite sectionComposite) {
        this.constructorCombo = new ComboViewer(sectionComposite);
        this.comboContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IFile beanFile = BeanPropertiesWizardPage.this.wizard.getBeanFile();
                if (beanFile == null) {
                    return new Object[0];
                }
                String className = BeansEditorUtils.getClassNameForBean((IFile)beanFile, (Document)BeanPropertiesWizardPage.this.wizard.getOriginalDocument(), (Node)BeanPropertiesWizardPage.this.wizard.getNewBean());
                IType type = JdtUtils.getJavaType((IProject)beanFile.getProject(), (String)className);
                Set constructors = null;
                try {
                    constructors = Introspector.findAllConstructors((IType)type);
                }
                catch (JavaModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to populate constructor combo.", (Throwable)e));
                }
                if (constructors == null) {
                    return new Object[0];
                }
                return constructors.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.constructorCombo.setContentProvider((IContentProvider)this.comboContentProvider);
        this.constructorCombo.setInput((Object)this);
        this.constructorCombo.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        this.constructorCombo.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    try {
                        return method.getParameterNames().length > 0;
                    }
                    catch (JavaModelException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to populate constructor combo.", (Throwable)e));
                    }
                }
                return false;
            }
        });
        GridData comboData = new GridData(4, 4, true, false);
        comboData.horizontalSpan = 2;
        comboData.widthHint = 400;
        this.constructorCombo.getControl().setLayoutData((Object)comboData);
        this.constructorCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection structuredSelection;
                Object[] items;
                ISelection selection = BeanPropertiesWizardPage.this.constructorCombo.getSelection();
                if (selection instanceof StructuredSelection && (items = (structuredSelection = (StructuredSelection)selection).toArray()).length == 1) {
                    IMethod constructor = (IMethod)items[0];
                    int numParam = constructor.getNumberOfParameters();
                    int itemCount = BeanPropertiesWizardPage.this.constructorArgsTable.getItemCount();
                    if (itemCount != numParam) {
                        if (itemCount > 0) {
                            boolean confirmed = MessageDialog.openConfirm((Shell)BeanPropertiesWizardPage.this.getShell(), (String)Messages.getString("BeanPropertiesWizardPage.CHANG_CONSTRUCTOR_ARGS_CONFIRM_DIALOG_TITLE"), (String)Messages.getString("BeanPropertiesWizardPage.CHANG_CONSTRUCTOR_ARGS_CONFIRM_DIALOG_MESSAGE"));
                            if (!confirmed) {
                                return;
                            }
                            BeanPropertiesWizardPage.this.constructorArgsTable.removeAll();
                        }
                        int i = 0;
                        while (i < numParam) {
                            IDOMElement child = BeanPropertiesWizardPage.this.createNewChild(1, BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG);
                            BeanPropertiesWizardPage.this.createElementItem(1, child);
                            ++i;
                        }
                        BeanPropertiesWizardPage.this.constructorArgsTable.redraw();
                    }
                }
            }
        });
    }

    private void createConstructorArgsSection(Composite container) {
        Composite sectionComposite = this.createSection(container, Messages.getString("BeanPropertiesWizardPage.CONSTRUCTOR_ARGS_SECTION_TITLE"), false);
        this.createCombo(sectionComposite);
        this.constructorArgsTable = this.createTable(sectionComposite);
        TableColumn valueColumn = new TableColumn(this.constructorArgsTable, 0);
        valueColumn.setText(Messages.getString("BeanPropertiesWizardPage.VALUE/REF_COLUMN_TITLE"));
        valueColumn.setWidth(250);
        this.createButtons(1, sectionComposite, BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG, this.constructorArgsTable);
    }

    public void createControl(Composite parent) {
        try {
            String prefix = WizardPlugin.getDefault().getBundle().getEntry("/") + ICON_PATH_PREFIX;
            Display display = this.getShell().getDisplay();
            this.errorImages = new Image[]{new Image((Device)display, ImageDescriptor.createFromURL((URL)new URL(String.valueOf(prefix) + ERROR_ICON)).getImageData()), new Image((Device)display, ImageDescriptor.createFromURL((URL)new URL(String.valueOf(prefix) + ERROR_ICON2)).getImageData())};
            this.warningImages = new Image[]{new Image((Device)display, ImageDescriptor.createFromURL((URL)new URL(String.valueOf(prefix) + WARNING_ICON)).getImageData()), new Image((Device)display, ImageDescriptor.createFromURL((URL)new URL(String.valueOf(prefix) + WARNING_ICON2)).getImageData())};
        }
        catch (MalformedURLException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create bean properties wizard page.", (Throwable)e));
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Composite topContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginRight = 0;
        topContainer.setLayout((Layout)layout);
        topContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite bottomContainer = new Composite(container, 0);
        GridLayout layout2 = new GridLayout();
        layout2.marginWidth = 0;
        bottomContainer.setLayout((Layout)layout2);
        bottomContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPropertySection(topContainer);
        this.createConstructorArgsSection(bottomContainer);
        this.ignoreErrorButton = this.wizard.createIgnoreErrorButton(container, this);
        this.ignoreErrorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeanPropertiesWizardPage.this.validateElements();
                BeanPropertiesWizardPage.this.updateMessage();
            }
        });
        this.populateValues();
        this.setControl((Control)container);
    }

    private BeanChildDialog createDialog(int kind, IDOMElement element, String title, boolean isNew) {
        if (kind == 0) {
            return new PropertyDialog(this.getShell(), this.wizard, element, title, this.definedProperties, isNew);
        }
        if (kind == 1) {
            return new ConstructorArgDialog(this.getShell(), this.wizard, element, title, isNew);
        }
        return null;
    }

    private void createElementItem(int kind, IDOMElement newElement) {
        Table table = null;
        if (kind == 0) {
            table = this.propertiesTable;
            this.definedProperties.add(newElement.getAttribute(BeansSchemaConstants.ATTR_NAME));
        } else if (kind == 1) {
            table = this.constructorArgsTable;
        }
        TableItem item = new TableItem(table, 0);
        item.setData((Object)newElement);
        item.setText(this.getElementItemText(kind, newElement));
        if (kind == 0) {
            this.propertyProblemCounter += this.validateElement(kind, newElement, item);
        } else {
            this.constArgProblemCounter += this.validateElement(kind, newElement, item);
        }
        this.updateMessage();
    }

    private IDOMElement createNewChild(int kind, String nodeName) {
        IDOMElement newBean = this.wizard.getNewBean();
        IDOMElement newChild = (IDOMElement)newBean.getOwnerDocument().createElementNS("http://www.springframework.org/schema/beans", nodeName);
        if (kind == 0) {
            newBean.appendChild((Node)newChild);
        } else {
            NodeList childNodes = newBean.getChildNodes();
            Node firstPropertyNode = null;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                String childNodeName = childNode.getNodeName();
                if (childNodeName.equals(BeansSchemaConstants.ELEM_PROPERTY)) {
                    firstPropertyNode = childNode;
                    break;
                }
                ++i;
            }
            if (firstPropertyNode != null) {
                newBean.insertBefore((Node)newChild, firstPropertyNode);
            } else {
                newBean.appendChild((Node)newChild);
            }
        }
        return newChild;
    }

    private void createPropertySection(Composite container) {
        Composite sectionComposite = this.createSection(container, Messages.getString("BeanPropertiesWizardPage.PROPERTIES_SECTION_TITLE"), true);
        this.propertiesTable = this.createTable(sectionComposite);
        TableColumn nameColumn = new TableColumn(this.propertiesTable, 0);
        nameColumn.setText(Messages.getString("BeanPropertiesWizardPage.NAME_COLUMN_TITLE"));
        nameColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(this.propertiesTable, 0);
        valueColumn.setText(Messages.getString("BeanPropertiesWizardPage.VALUE/REF_COLUMN_TITLE"));
        valueColumn.setWidth(250);
        this.createButtons(0, sectionComposite, BeansSchemaConstants.ELEM_PROPERTY, this.propertiesTable);
    }

    private Composite createSection(Composite container, String title, boolean expanded) {
        ExpandableComposite section = new FormToolkit(this.getShell().getDisplay()).createExpandableComposite(container, 290);
        section.setText(title);
        GridData sectionData = new GridData(4, 128, true, false);
        section.clientVerticalSpacing = 0;
        section.setLayoutData((Object)sectionData);
        section.setBackground(container.getBackground());
        Composite sectionComposite = new Composite((Composite)section, 0);
        section.setClient((Control)sectionComposite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        sectionComposite.setLayout((Layout)layout);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BeanPropertiesWizardPage.this.getShell().pack();
            }
        });
        section.setExpanded(expanded);
        return sectionComposite;
    }

    private Table createTable(Composite container) {
        GridData tableData = new GridData(4, 4, true, true);
        tableData.heightHint = 100;
        Table table = new Table(container, 67586);
        table.setLayoutData((Object)tableData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        return table;
    }

    public void dispose() {
        if (this.errorImages != null) {
            this.errorImages[0].dispose();
            this.errorImages[1].dispose();
            this.warningImages[0].dispose();
            this.warningImages[1].dispose();
        }
    }

    private void editSelectedElementItem(int kind, Table table) {
        TableItem[] selectedItems = table.getSelection();
        if (selectedItems.length == 1) {
            TableItem item = selectedItems[0];
            IDOMElement element = (IDOMElement)item.getData();
            int numProblemPreEdit = this.validateElement(kind, element, item);
            String title = null;
            if (kind == 0) {
                title = Messages.getString("BeanPropertiesWizardPage.EDIT_PROPERTY_DIALOG_TITLE");
                this.definedProperties.remove(element.getAttribute(BeansSchemaConstants.ATTR_NAME));
            } else if (kind == 1) {
                title = Messages.getString("BeanPropertiesWizardPage.EDIT_CONSTRUCTOR_ARG_DIALOG_TITLE");
            }
            BeanChildDialog dialog = this.createDialog(kind, element, title, false);
            int status = dialog.open();
            if (status == 0) {
                item.setText(this.getElementItemText(kind, element));
                int numProblemPostEdit = this.validateElement(kind, element, item);
                if (kind == 0) {
                    this.definedProperties.add(element.getAttribute(BeansSchemaConstants.ATTR_NAME));
                    this.propertyProblemCounter += numProblemPostEdit - numProblemPreEdit;
                } else {
                    this.constArgProblemCounter += numProblemPostEdit - numProblemPreEdit;
                }
            }
        }
        this.updateMessage();
    }

    private void fillConstructorDropdownBox() {
        this.constructorCombo.refresh(true);
    }

    private String getElementAttributeText(IDOMElement element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return Messages.getString("BeanPropertiesWizardPage.EMPTY_CELL_LABEL");
    }

    private String[] getElementItemText(int kind, IDOMElement element) {
        String name = this.getElementAttributeText(element, BeansSchemaConstants.ATTR_NAME);
        String valueRef = this.getElementAttributeText(element, BeansSchemaConstants.ATTR_REF);
        if (valueRef.equals(Messages.getString("BeanPropertiesWizardPage.EMPTY_CELL_LABEL"))) {
            valueRef = this.getElementAttributeText(element, BeansSchemaConstants.ATTR_VALUE);
        }
        if (kind == 0) {
            return new String[]{name, valueRef};
        }
        if (kind == 1) {
            return new String[]{valueRef};
        }
        return null;
    }

    public boolean isPageComplete() {
        if (this.propertyProblemCounter < 0 || this.constArgProblemCounter < 0) {
            this.validateElements();
        }
        return BeanWizard.getIgnoreError() || this.propertyProblemCounter == 0 && this.constArgProblemCounter == 0;
    }

    private void populateValues() {
        IDOMElement newBean = this.wizard.getNewBean();
        if (newBean == null) {
            return;
        }
        NodeList childNodes = newBean.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            IDOMElement domNode;
            String nodeName;
            Node childNode = childNodes.item(i);
            if (childNode instanceof IDOMElement && (nodeName = (domNode = (IDOMElement)childNode).getNodeName()) != null) {
                if (nodeName.equals(BeansSchemaConstants.ELEM_PROPERTY)) {
                    this.createElementItem(0, domNode);
                } else if (nodeName.equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG)) {
                    this.createElementItem(1, domNode);
                }
            }
            ++i;
        }
        Object[] elements = this.comboContentProvider.getElements((Object)this);
        int itemCount = this.constructorArgsTable.getItemCount();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IMethod) {
                IMethod constructor = (IMethod)element;
                try {
                    String[] parameterNames = constructor.getParameterNames();
                    if (parameterNames != null && parameterNames.length == itemCount) {
                        this.constructorCombo.setSelection((ISelection)new StructuredSelection((Object)constructor));
                    }
                }
                catch (JavaModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to populate constructor combo.", (Throwable)e));
                }
            }
            ++n2;
        }
    }

    private void removeSelected(int kind, Table table) {
        TableItem[] items = table.getItems();
        int[] indices = table.getSelectionIndices();
        IDOMElement newBean = this.wizard.getNewBean();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem item = items[index];
            Object data = item.getData();
            if (data != null && data instanceof IDOMElement) {
                IDOMElement element = (IDOMElement)data;
                if (kind == 0) {
                    this.propertyProblemCounter -= this.validateElement(kind, element, item);
                } else {
                    this.constArgProblemCounter -= this.validateElement(kind, element, item);
                }
                newBean.removeChild((Node)element);
                if (kind == 0) {
                    this.definedProperties.remove(element.getAttribute(BeansSchemaConstants.ATTR_NAME));
                }
            }
            ++n2;
        }
        table.remove(indices);
        this.updateMessage();
    }

    public void resetProblemCounter() {
        this.propertyProblemCounter = -1;
        this.constArgProblemCounter = -1;
    }

    @Override
    public void updateMessage() {
        String text = "error";
        if (BeanWizard.getIgnoreError()) {
            text = "warning";
        }
        if (this.propertyProblemCounter > 0) {
            if (this.propertyProblemCounter == 1) {
                this.setDialogMessage("There is 1 " + text + " in the Properties section.");
            } else {
                this.setDialogMessage("There are " + this.propertyProblemCounter + " " + text + "s in the Properties section.");
            }
        } else if (this.constArgProblemCounter > 0) {
            if (this.constArgProblemCounter == 1) {
                this.setDialogMessage("There is 1 " + text + " in the Constructor Args section.");
            } else {
                this.setDialogMessage("There are " + this.constArgProblemCounter + " " + text + "s in the Constructor Args section.");
            }
        } else {
            this.setMessage(DEFAULT_MESSAGE);
        }
        if (this.isCurrentPage()) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    private boolean validateAttribute(String attributeValue, String attributeName, IDOMElement property, TableItem item, int kind) {
        boolean errorFound = false;
        Image[] images = BeanWizard.getIgnoreError() ? this.warningImages : this.errorImages;
        int index = 0;
        if (attributeValue != null) {
            WizardContentAssistConverter contentAssistConverter = new WizardContentAssistConverter((IDOMNode)property, property.getAttributeNode(attributeName), this.wizard.getBeanFile(), this.wizard.getOriginalDocument());
            if (attributeName.equals(BeansSchemaConstants.ATTR_NAME)) {
                errorFound = contentAssistConverter.getPropertyProposals(attributeValue, true).isEmpty();
                if (errorFound) {
                    item.setImage(index, images[index]);
                } else {
                    item.setImage(index, BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.property_obj.gif"));
                }
            } else if (attributeName.equals(BeansSchemaConstants.ATTR_REF)) {
                if (kind == 0) {
                    index = 1;
                }
                if (attributeValue.length() == 0) {
                    item.setImage(index, null);
                } else {
                    errorFound = contentAssistConverter.getReferenceableBeanDescriptions(attributeValue, true).isEmpty();
                    if (errorFound) {
                        item.setImage(index, images[index]);
                    } else {
                        item.setImage(index, null);
                    }
                }
            }
        }
        if (kind == 0) {
            this.propertiesTable.update();
        }
        return errorFound;
    }

    private int validateElement(int kind, IDOMElement property, TableItem item) {
        int counter = 0;
        if (kind == 0 && this.validateAttribute(property.getAttribute(BeansSchemaConstants.ATTR_NAME), BeansSchemaConstants.ATTR_NAME, property, item, kind)) {
            ++counter;
        }
        if (this.validateAttribute(property.getAttribute(BeansSchemaConstants.ATTR_REF), BeansSchemaConstants.ATTR_REF, property, item, kind)) {
            ++counter;
        }
        return counter;
    }

    public void validateElements() {
        Object data;
        TableItem item;
        TableItem[] items;
        this.fillConstructorDropdownBox();
        this.propertyProblemCounter = 0;
        TableItem[] tableItemArray = items = this.propertiesTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IDOMElement property;
            item = tableItemArray[n2];
            data = item.getData();
            if (data instanceof IDOMElement && (property = (IDOMElement)data).getNodeName().equals(BeansSchemaConstants.ELEM_PROPERTY)) {
                this.propertyProblemCounter += this.validateElement(0, property, item);
            }
            ++n2;
        }
        this.constArgProblemCounter = 0;
        tableItemArray = items = this.constructorArgsTable.getItems();
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            IDOMElement constructorArg;
            item = tableItemArray[n2];
            data = item.getData();
            if (data instanceof IDOMElement && (constructorArg = (IDOMElement)data).getNodeName().equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG)) {
                this.constArgProblemCounter += this.validateElement(1, constructorArg, item);
            }
            ++n2;
        }
        this.ignoreErrorButton.setSelection(BeanWizard.getIgnoreError());
        this.updateMessage();
    }
}

