/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springsource.ide.eclipse.commons.core.Policy;

public class RuntimeTemplateProjectZipCreatorVisitor
implements IResourceVisitor {
    private final ZipOutputStream out;
    private final IProgressMonitor monitor;
    private final Set<String> excludes;

    public RuntimeTemplateProjectZipCreatorVisitor(ZipOutputStream out, IProgressMonitor monitor) {
        this.out = out;
        this.monitor = monitor;
        this.excludes = new HashSet<String>();
        this.excludes.add("build");
        this.excludes.add("target");
        this.excludes.add(".DS_Store");
        this.excludes.add("template.xml");
        this.excludes.add("wizard.json");
    }

    private boolean select(IResource resource) {
        if (resource.isDerived()) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        String[] segments = fullPath.segments();
        if (segments != null) {
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (this.excludes.contains(segment)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void addFile(IFile file) throws CoreException, IOException {
        try (BufferedInputStream in = new BufferedInputStream(file.getContents());){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                Policy.checkCancelled((IProgressMonitor)this.monitor);
                this.out.write(buffer, 0, len);
            }
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IProject) {
            return true;
        }
        if (!this.select(resource)) {
            return false;
        }
        String path = "template/" + resource.getProjectRelativePath().toString();
        try {
            if (resource instanceof IFile) {
                ZipEntry entry = new ZipEntry(path);
                this.out.putNextEntry(entry);
                this.addFile((IFile)resource);
                this.out.closeEntry();
            } else if (resource instanceof IFolder) {
                ZipEntry entry = new ZipEntry(String.valueOf(path) + "/");
                this.out.putNextEntry(entry);
                this.out.closeEntry();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Could not add \"" + path + "\" to archive.", (Throwable)e));
        }
        return true;
    }
}

