/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import java.util.Iterator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.StsTaskEditorActionContributor;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.StsTextViewerConfiguration;

public class EditorToolkit {
    private final FormToolkit toolkit;
    private final IEditorSite editorSite;
    private ActionContributorProxy contributor;

    public EditorToolkit(FormToolkit toolkit, IEditorSite site) {
        this.toolkit = toolkit;
        this.editorSite = site;
    }

    protected void configureContextMenuManager(Control control) {
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorToolkit.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        control.setMenu(manager.createContextMenu(control));
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        IEditorActionBarContributor contributor = this.editorSite.getActionBarContributor();
        if (contributor instanceof StsTaskEditorActionContributor) {
            ((StsTaskEditorActionContributor)contributor).contextMenuAboutToShow(manager, true);
        } else if (contributor instanceof TaskEditorActionContributor) {
            ((TaskEditorActionContributor)contributor).contextMenuAboutToShow(manager, true);
        }
    }

    public Hyperlink createHyperlink(Composite parent, String hyperlinkText, final String url) {
        Hyperlink link = this.toolkit.createHyperlink(parent, hyperlinkText, 0);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)url);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        return link;
    }

    public Label createLabel(Composite composite, String text) {
        Label label = this.toolkit.createLabel(composite, text);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        return label;
    }

    public TextViewer createTextEditor(Composite composite, String text, boolean spellCheck, int style) {
        AnnotationModel annotationModel = new AnnotationModel();
        final SourceViewer textViewer = new SourceViewer(composite, null, null, true, style);
        textViewer.showAnnotations(false);
        textViewer.showAnnotationsOverview(false);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)textViewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        textViewer.getTextWidget().setIndent(2);
        textViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        IThemeManager themeManager = this.editorSite.getWorkbenchWindow().getWorkbench().getThemeManager();
        textViewer.getTextWidget().setFont(themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment"));
        final ActionContributorProxy actionContributor = this.getContributor();
        if (actionContributor.getSelectionChangedListener() != null) {
            textViewer.addSelectionChangedListener(actionContributor.getSelectionChangedListener());
        }
        textViewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                actionContributor.updateSelectableActions(textViewer.getSelection());
            }

            public void focusLost(FocusEvent e) {
                StyledText st = (StyledText)e.widget;
                st.setSelectionRange(st.getCaretOffset(), 0);
                actionContributor.forceActionsEnabled();
            }
        });
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                actionContributor.updateSelectableActions(textViewer.getSelection());
            }
        });
        Document document = new Document(text);
        StsTextViewerConfiguration viewerConfig = new StsTextViewerConfiguration(spellCheck, false);
        textViewer.configure((SourceViewerConfiguration)viewerConfig);
        textViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        EditorUtil.setTextViewer((Widget)textViewer.getControl(), (TextViewer)textViewer);
        this.configureContextMenuManager(textViewer.getControl());
        return textViewer;
    }

    protected ActionContributorProxy getContributor() {
        if (this.contributor == null) {
            IEditorActionBarContributor editorContributor = this.editorSite.getActionBarContributor();
            if (editorContributor instanceof StsTaskEditorActionContributor) {
                final StsTaskEditorActionContributor actionContributor = (StsTaskEditorActionContributor)editorContributor;
                this.contributor = new ActionContributorProxy(this){

                    @Override
                    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
                        actionContributor.contextMenuAboutToShow(manager, addClipboard);
                    }

                    @Override
                    public void forceActionsEnabled() {
                        actionContributor.forceActionsEnabled();
                    }

                    @Override
                    public ISelectionChangedListener getSelectionChangedListener() {
                        return actionContributor;
                    }

                    @Override
                    public void updateSelectableActions(ISelection selection) {
                        actionContributor.updateSelectableActions(selection);
                    }
                };
            } else if (editorContributor instanceof TaskEditorActionContributor) {
                final TaskEditorActionContributor actionContributor = (TaskEditorActionContributor)editorContributor;
                this.contributor = new ActionContributorProxy(this){

                    @Override
                    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
                        actionContributor.contextMenuAboutToShow(manager, addClipboard);
                    }

                    @Override
                    public void forceActionsEnabled() {
                        actionContributor.forceActionsEnabled();
                    }

                    @Override
                    public ISelectionChangedListener getSelectionChangedListener() {
                        return actionContributor;
                    }

                    @Override
                    public void updateSelectableActions(ISelection selection) {
                        actionContributor.updateSelectableActions(selection);
                    }
                };
            } else {
                this.contributor = new ActionContributorProxy(null, null);
            }
        }
        return this.contributor;
    }

    private class ActionContributorProxy {
        private ActionContributorProxy() {
        }

        public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
        }

        public void forceActionsEnabled() {
        }

        public ISelectionChangedListener getSelectionChangedListener() {
            return null;
        }

        public void updateSelectableActions(ISelection selection) {
        }

        /* synthetic */ ActionContributorProxy(ActionContributorProxy actionContributorProxy, ActionContributorProxy actionContributorProxy2) {
            this();
        }
    }
}

