/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.io.File;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.wizards.CloudForgeComposite;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SvnWizardNewRepositoryPage
extends SvnWizardDialogPage {
    private Text folderText;
    private Button connectionButton;
    private boolean success;

    public SvnWizardNewRepositoryPage() {
        super("NewRepositoryDialog", Policy.bind("NewRepositoryDialog.title"));
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    @Override
    public void createControls(Composite outerContainer) {
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(Policy.bind("NewRepositoryDialog.folder"));
        data = new GridData();
        data.horizontalSpan = 2;
        folderLabel.setLayoutData((Object)data);
        this.folderText = new Text(composite, 2048);
        data = new GridData();
        data.widthHint = 450;
        this.folderText.setLayoutData((Object)data);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardNewRepositoryPage.this.setPageComplete(SvnWizardNewRepositoryPage.this.canFinish());
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Policy.bind("NewRepositoryDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SvnWizardNewRepositoryPage.this.getShell());
                dialog.setText(Policy.bind("NewRepositoryDialog.browseTitle"));
                dialog.setMessage(Policy.bind("NewRepositoryDialog.browseMessage"));
                String directory = dialog.open();
                if (directory != null) {
                    SvnWizardNewRepositoryPage.this.folderText.setText(directory);
                }
            }
        });
        Label spacer = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        spacer.setLayoutData((Object)data);
        this.connectionButton = new Button(composite, 32);
        this.connectionButton.setText(Policy.bind("NewRepositoryDialog.connection"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.connectionButton.setLayoutData((Object)data);
        this.connectionButton.setSelection(true);
        CloudForgeComposite cloudForgeComposite = new CloudForgeComposite(composite, 0);
        data = new GridData(1048);
        data.horizontalSpan = 2;
        cloudForgeComposite.setLayoutData(data);
        this.setPageComplete(false);
        this.folderText.setFocus();
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("NewRepositoryDialog.title");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        this.success = true;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ISVNClientAdapter svnClient;
                block7: {
                    String url;
                    SVNProviderPlugin provider;
                    block6: {
                        svnClient = null;
                        provider = SVNProviderPlugin.getPlugin();
                        url = SvnWizardNewRepositoryPage.this.getUrl();
                        if (!provider.getRepositories().isKnownRepository(url, true)) break block6;
                        MessageDialog.openError((Shell)SvnWizardNewRepositoryPage.this.getShell(), (String)Policy.bind("NewRepositoryDialog.title"), (String)Policy.bind("NewRepositoryDialog.alreadyExists"));
                        SvnWizardNewRepositoryPage.this.success = false;
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
                        return;
                    }
                    try {
                        try {
                            svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
                            File path = new File(SvnWizardNewRepositoryPage.this.folderText.getText().trim());
                            if (!path.exists()) {
                                path.mkdirs();
                            }
                            svnClient.createRepository(path, "fsfs");
                            if (!SvnWizardNewRepositoryPage.this.connectionButton.getSelection()) break block7;
                            Properties properties = new Properties();
                            properties.setProperty("url", url);
                            ISVNRepositoryLocation repository = provider.getRepositories().createRepository(properties);
                            provider.getRepositories().addOrUpdateRepository(repository);
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)SvnWizardNewRepositoryPage.this.getShell(), (String)Policy.bind("NewRepositoryDialog.title"), (String)e.getLocalizedMessage());
                            SvnWizardNewRepositoryPage.this.success = false;
                            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
                        }
                    }
                    catch (Throwable throwable) {
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
                        throw throwable;
                    }
                }
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
            }
        });
        return this.success;
    }

    private String getUrl() {
        String url = null;
        url = this.folderText.getText().startsWith("/") ? "file://" + this.folderText.getText().trim().replaceAll("\\\\", "/") : "file:///" + this.folderText.getText().trim().replaceAll("\\\\", "/");
        return url;
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("NewRepositoryDialog.message"));
    }

    private boolean canFinish() {
        File parent;
        if (this.folderText.getText().trim().length() == 0) {
            return false;
        }
        File file = new File(this.folderText.getText().trim());
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.exists() && !file.isDirectory()) {
            return false;
        }
        return file.exists() || (parent = file.getParentFile()) != null && parent.exists();
    }
}

