/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.repository.RepositoryFilters;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;

public class CheckoutWizardSelectionPage
extends WizardPage {
    private static final int LIST_HEIGHT_HINT = 250;
    private static final int LIST_WIDTH_HINT = 450;
    private ISVNRepositoryLocation repositoryLocation;
    private TreeViewer treeViewer;

    public CheckoutWizardSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.treeViewer = new TreeViewer(outerContainer, 2818);
        RepositoryContentProvider contentProvider = new RepositoryContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.addFilter(RepositoryFilters.FOLDERS_ONLY);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setInput((Object)this.repositoryLocation);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 450;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CheckoutWizard wizard = (CheckoutWizard)CheckoutWizardSelectionPage.this.getWizard();
                ArrayList<Object> folderArray = new ArrayList<Object>();
                IStructuredSelection selection = (IStructuredSelection)CheckoutWizardSelectionPage.this.treeViewer.getSelection();
                for (Object object : selection) {
                    if (!(object instanceof ISVNRemoteFolder) && !(object instanceof ISVNRepositoryLocation)) continue;
                    if (object instanceof ISVNRepositoryLocation) {
                        folderArray.add(((ISVNRepositoryLocation)object).getRootFolder());
                        continue;
                    }
                    folderArray.add(object);
                }
                ISVNRemoteFolder[] remoteFolders = new ISVNRemoteFolder[folderArray.size()];
                folderArray.toArray(remoteFolders);
                wizard.setRemoteFolders(remoteFolders);
                CheckoutWizardSelectionPage.this.setPageComplete(!CheckoutWizardSelectionPage.this.treeViewer.getSelection().isEmpty());
            }
        });
        final Action refreshAction = new Action(Policy.bind("RepositoriesView.refreshPopup"), SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/refresh.gif")){

            public void run() {
                CheckoutWizardSelectionPage.this.refreshViewerNode();
            }
        };
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.treeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)refreshAction);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.setMessage(Policy.bind("CheckoutWizardSelectionPage.text"));
        this.setControl((Control)outerContainer);
    }

    public boolean canFlipToNextPage() {
        CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        if (wizard != null) {
            return this.isPageComplete() && wizard.getNextPage((IWizardPage)this, false) != null;
        }
        return super.canFlipToNextPage();
    }

    public void setLocation(ISVNRepositoryLocation repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)repositoryLocation.getLocation());
            this.treeViewer.refresh();
            this.treeViewer.expandToLevel(2);
        }
    }

    protected void refreshViewerNode() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        for (Object object : selection) {
            if (object instanceof ISVNRepositoryLocation) {
                ((ISVNRepositoryLocation)object).refreshRootFolder();
            }
            if (object instanceof ISVNRemoteFolder) {
                ((ISVNRemoteFolder)object).refresh();
            }
            this.treeViewer.refresh(object);
        }
    }

    class RepositoryContentProvider
    extends WorkbenchContentProvider {
        private DeferredTreeContentManager manager;

        RepositoryContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (viewer instanceof AbstractTreeViewer) {
                this.manager = new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer);
            }
            super.inputChanged(viewer, oldInput, newInput);
        }

        public boolean hasChildren(Object element) {
            return element != null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                Object[] root = new Object[]{CheckoutWizardSelectionPage.this.repositoryLocation};
                return root;
            }
            if (this.manager != null) {
                Object[] children = this.manager.getChildren(parentElement);
                return children;
            }
            return super.getChildren(parentElement);
        }
    }
}

