/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNExternal;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizard;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagWizardCopyPage
extends SVNWizardPage {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    protected Button serverButton;
    protected Button revisionButton;
    private Text revisionText;
    private Button logButton;
    protected Button workingCopyButton;
    private Table table;
    private TableViewer viewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private String[] columnHeaders = new String[]{Policy.bind("BranchTagWizardCopyPage.0"), Policy.bind("BranchTagWizardCopyPage.1"), Policy.bind("BranchTagWizardCopyPage.2"), Policy.bind("BranchTagWizardCopyPage.3")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(200, 200, true), new ColumnWeightData(200, 200, true), new ColumnWeightData(50, 50, true), new ColumnWeightData(50, 50, true)};
    private SVNExternal[] svnExternals;
    private long revisionNumber = 0L;

    public BranchTagWizardCopyPage() {
        super("copyPage", Policy.bind("BranchTagWizardCopyPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/svn_wizban.png"), Policy.bind("BranchTagWizardCopyPage.message"));
    }

    public void createControl(Composite parent) {
        this.resource = ((BranchTagWizard)this.getWizard()).getResource();
        this.remoteResource = ((BranchTagWizard)this.getWizard()).getRemoteResource();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerLayout.marginHeight = 0;
        outerLayout.marginWidth = 0;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Group serverComposite = new Group(outerContainer, 0);
        serverComposite.setText(Policy.bind("BranchTagDialog.createCopy"));
        GridLayout serverLayout = new GridLayout();
        serverLayout.numColumns = 3;
        serverComposite.setLayout((Layout)serverLayout);
        GridData data = new GridData(4, 4, true, false);
        serverComposite.setLayoutData((Object)data);
        this.serverButton = new Button((Composite)serverComposite, 16);
        this.serverButton.setText(Policy.bind("BranchTagDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.serverButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)serverComposite, 16);
        this.revisionButton.setText(Policy.bind("BranchTagDialog.revision"));
        this.revisionText = new Text((Composite)serverComposite, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        if (this.revisionNumber == 0L) {
            this.revisionText.setEnabled(false);
        } else {
            this.revisionText.setText("" + this.revisionNumber);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagWizardCopyPage.this.setPageComplete(BranchTagWizardCopyPage.this.canFinish());
            }
        });
        this.logButton = new Button((Composite)serverComposite, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        if (this.revisionNumber == 0L) {
            this.logButton.setEnabled(false);
        }
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagWizardCopyPage.this.showLog();
            }
        });
        this.workingCopyButton = new Button((Composite)serverComposite, 16);
        this.workingCopyButton.setText(Policy.bind("BranchTagDialog.working"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.workingCopyButton.setLayoutData((Object)data);
        if (this.resource == null) {
            this.workingCopyButton.setVisible(false);
        } else if (this.getSvnExternalsProperties()) {
            Group externalsGroup = new Group(outerContainer, 0);
            externalsGroup.setText(Policy.bind("BranchTagWizardCopyPage.5"));
            GridLayout externalsLayout = new GridLayout();
            externalsLayout.numColumns = 1;
            externalsGroup.setLayout((Layout)externalsLayout);
            data = new GridData(1808);
            externalsGroup.setLayoutData((Object)data);
            this.table = new Table((Composite)externalsGroup, 2848);
            this.table.setHeaderVisible(true);
            data = new GridData(1808);
            data.heightHint = 75;
            this.table.setLayoutData((Object)data);
            TableLayout tableLayout = new TableLayout();
            this.table.setLayout((Layout)tableLayout);
            this.viewer = new CheckboxTableViewer(this.table);
            this.viewer.setContentProvider((IContentProvider)new ExternalsContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ExternalsLabelProvider());
            int i = 0;
            while (i < this.columnHeaders.length) {
                tableLayout.addColumnData(this.columnLayouts[i]);
                TableColumn tc = new TableColumn(this.table, 0, i);
                tc.setResizable(this.columnLayouts[i].resizable);
                tc.setText(this.columnHeaders[i]);
                ++i;
            }
            this.viewer.setInput((Object)this);
            ((CheckboxTableViewer)this.viewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = BranchTagWizardCopyPage.this.table.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        ((SVNExternal)item.getData()).setSelected(item.getChecked());
                        ++n2;
                    }
                }
            });
            Composite buttonGroup = new Composite((Composite)externalsGroup, 0);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.numColumns = 2;
            buttonLayout.makeColumnsEqualWidth = true;
            buttonGroup.setLayout((Layout)buttonLayout);
            GridData gd = new GridData(64);
            buttonGroup.setLayoutData((Object)gd);
            this.selectAllButton = new Button(buttonGroup, 8);
            this.selectAllButton.setText(Policy.bind("BranchTagWizardCopyPage.6"));
            gd = new GridData(256);
            this.selectAllButton.setLayoutData((Object)gd);
            this.deselectAllButton = new Button(buttonGroup, 8);
            this.deselectAllButton.setText(Policy.bind("BranchTagWizardCopyPage.7"));
            gd = new GridData(256);
            this.deselectAllButton.setLayoutData((Object)gd);
            SelectionAdapter buttonListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.getSource() == BranchTagWizardCopyPage.this.selectAllButton) {
                        BranchTagWizardCopyPage.this.selectAll();
                    } else {
                        BranchTagWizardCopyPage.this.deselectAll();
                    }
                }
            };
            this.selectAllButton.addSelectionListener((SelectionListener)buttonListener);
            this.deselectAllButton.addSelectionListener((SelectionListener)buttonListener);
        }
        if (this.revisionNumber == 0L) {
            this.serverButton.setSelection(true);
        } else {
            this.revisionButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagWizardCopyPage.this.revisionText.setEnabled(BranchTagWizardCopyPage.this.revisionButton.getSelection());
                BranchTagWizardCopyPage.this.logButton.setEnabled(BranchTagWizardCopyPage.this.revisionButton.getSelection());
                if (BranchTagWizardCopyPage.this.revisionButton.getSelection()) {
                    BranchTagWizardCopyPage.this.revisionText.setFocus();
                }
                BranchTagWizardCopyPage.this.setPageComplete(BranchTagWizardCopyPage.this.canFinish());
            }
        };
        this.serverButton.addSelectionListener((SelectionListener)selectionListener);
        this.revisionButton.addSelectionListener((SelectionListener)selectionListener);
        this.workingCopyButton.addSelectionListener((SelectionListener)selectionListener);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener(focusListener);
        this.setControl((Control)outerContainer);
    }

    public SVNExternal[] getSvnExternals() {
        return this.svnExternals;
    }

    private void selectAll() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(true);
            ((SVNExternal)item.getData()).setSelected(true);
            ++n2;
        }
    }

    private void deselectAll() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(false);
            ((SVNExternal)item.getData()).setSelected(false);
            ++n2;
        }
    }

    private boolean getSvnExternalsProperties() {
        ArrayList<SVNExternal> externalsList;
        block12: {
            externalsList = new ArrayList<SVNExternal>();
            ISVNClientAdapter svnClient = null;
            ISVNRepositoryLocation repository = null;
            try {
                try {
                    IResource[] resources;
                    repository = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository();
                    svnClient = repository.getSVNClient();
                    IResource[] iResourceArray = resources = ((BranchTagWizard)this.getWizard()).getResources();
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISVNProperty[] properties;
                        IResource res = iResourceArray[n2];
                        ISVNProperty[] iSVNPropertyArray = properties = svnClient.getProperties(res.getLocation().toFile(), true);
                        int n3 = properties.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISVNProperty property = iSVNPropertyArray[n4];
                            if (property.getName().equals(Policy.bind("BranchTagWizardCopyPage.8"))) {
                                String[] propertyLines;
                                String[] stringArray = propertyLines = property.getValue().split("\\n");
                                int n5 = propertyLines.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    String propertyLine = stringArray[n6];
                                    SVNExternal svnExternal = new SVNExternal(property.getFile(), propertyLine);
                                    externalsList.add(svnExternal);
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    if (repository != null) {
                        repository.returnSVNClient(svnClient);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (repository != null) {
                    repository.returnSVNClient(svnClient);
                }
                throw throwable;
            }
            if (repository != null) {
                repository.returnSVNClient(svnClient);
            }
        }
        this.svnExternals = new SVNExternal[externalsList.size()];
        externalsList.toArray(this.svnExternals);
        return externalsList.size() > 0;
    }

    private void showLog() {
        ISVNRemoteResource remoteResource = null;
        if (((BranchTagWizard)this.getWizard()).multipleSelections()) {
            ISVNRepositoryLocation repository = null;
            repository = this.resource == null ? this.remoteResource.getRepository() : SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository();
            try {
                remoteResource = repository.getRemoteFile(new SVNUrl(((BranchTagWizard)this.getWizard()).getCommonRoot()));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
        }
        if (this.resource == null) {
            remoteResource = this.remoteResource;
        } else {
            try {
                remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository().getRemoteFile(((BranchTagWizard)this.getWizard()).getUrl());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
                return;
            }
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + ((BranchTagWizard)this.getWizard()).getUrlText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public String getRevision() {
        return this.revisionText.getText().trim();
    }

    private boolean canFinish() {
        return !this.revisionButton.getSelection() || this.revisionText.getText().trim().length() != 0;
    }

    class ExternalsContentProvider
    implements IStructuredContentProvider {
        ExternalsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return BranchTagWizardCopyPage.this.svnExternals;
        }
    }

    static class ExternalsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ExternalsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            SVNExternal external = (SVNExternal)element;
            switch (columnIndex) {
                case 0: {
                    if (external.getPath() == null) break;
                    return external.getPath();
                }
                case 1: {
                    if (external.getUrl() == null) break;
                    return external.getUrl().toString();
                }
                case 2: {
                    if (external.getRevision() == -1L) break;
                    return Long.toString(external.getRevision());
                }
                case 3: {
                    if (external.getFixedAtRevision() == -1L) break;
                    return Long.toString(external.getFixedAtRevision());
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

