/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class RemoveOperation
extends SVNOperation {
    private IResource[] resources;

    public RemoveOperation(IWorkbenchPart part, IResource[] resources) {
        super(part);
        this.resources = resources;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        ISVNClientAdapter client = null;
        ISVNRepositoryLocation repository = null;
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < this.resources.length) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
            if (client == null) {
                repository = svnResource.getRepository();
                client = repository.getSVNClient();
            }
            files.add(svnResource.getFile());
            ++i;
        }
        File[] fileArray = new File[files.size()];
        files.toArray(fileArray);
        try {
            try {
                client.remove(fileArray, true);
                this.refresh();
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            if (repository != null) {
                repository.returnSVNClient(client);
            }
            monitor.done();
        }
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("MarkDeletedAction.label");
    }

    private void refresh() {
        ArrayList<IResource> parents = new ArrayList<IResource>();
        int i = 0;
        while (i < this.resources.length) {
            IResource resource = this.resources[i];
            IResource parent = null;
            while (resource != null) {
                if ((resource = resource.getParent()) == null) continue;
                parent = resource;
            }
            if (parent != null && !parents.contains(parent)) {
                parents.add(parent);
            }
            ++i;
        }
        for (IResource parent : parents) {
            try {
                parent.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
    }
}

