/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;

public class SVNLocalResourceNode
extends BufferedResourceNode {
    private final ISVNLocalResource svnResource;
    private ResourceEditionNode remoteResource = null;
    private ArrayList fChildren = null;

    public SVNLocalResourceNode(ISVNLocalResource svnResource) {
        super(svnResource.getIResource());
        this.svnResource = svnResource;
    }

    protected InputStream createStream() throws CoreException {
        return ((IFile)this.getResource()).getContents();
    }

    public ISVNLocalResource getLocalResource() {
        return this.svnResource;
    }

    public void setRemoteResource(ResourceEditionNode remote) {
        this.remoteResource = remote;
    }

    public String getName() {
        String name = this.svnResource.getFile().getName();
        if (name == null) {
            name = this.svnResource.getName();
        }
        if (name != null) {
            return name;
        }
        return super.getName();
    }

    public void setContent(byte[] contents) {
        if (contents == null) {
            contents = new byte[]{};
        }
        final ByteArrayInputStream is = new ByteArrayInputStream(contents);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IFile file = (IFile)SVNLocalResourceNode.this.getResource();
                    if (!file.exists()) {
                        file.create(is, false, monitor);
                    } else {
                        file.setContents(is, false, true, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            SVNUIPlugin.openError(SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), Policy.bind("TeamFile.saveChanges", this.svnResource.getName()), null, e);
        }
        catch (InterruptedException interruptedException) {}
        this.fireContentChanged();
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
            if (this.remoteResource instanceof ResourceEditionNode) {
                try {
                    if (!this.getLocalResource().isDirty() && this.getLocalResource().getResource().getProjectRelativePath().toString().equals(this.remoteResource.getRemoteResource().getProjectRelativePath()) && this.getLocalResource().getStatus().getLastChangedRevision().equals((Object)this.remoteResource.getRemoteResource().getLastChangedRevision())) {
                        return this.fChildren.toArray();
                    }
                }
                catch (CoreException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
            }
            if (this.svnResource instanceof ISVNLocalFolder) {
                try {
                    ISVNLocalResource[] members = (ISVNLocalResource[])((ISVNLocalFolder)this.svnResource).members(null, 59);
                    int i = 0;
                    while (i < members.length) {
                        IStructureComparator child = this.createChild(members[i]);
                        if (child != null) {
                            this.fChildren.add(child);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return this.fChildren.toArray();
    }

    protected IStructureComparator createChild(ISVNLocalResource child) {
        return new SVNLocalResourceNode(child);
    }
}

