/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.client.IConsoleListener;
import org.tigris.subversion.subclipse.core.resources.BaseResourceStorageFactory;
import org.tigris.subversion.subclipse.core.resources.IBaseResourceStorageFactory;
import org.tigris.subversion.subclipse.core.resources.ISVNFileModificationValidatorPrompt;
import org.tigris.subversion.subclipse.core.util.ISimpleDialogsHelper;
import org.tigris.subversion.subclipse.ui.ISVNRepositorySourceProvider;
import org.tigris.subversion.subclipse.ui.ImageDescriptors;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.Preferences;
import org.tigris.subversion.subclipse.ui.SVNFileModificationValidatorPrompt;
import org.tigris.subversion.subclipse.ui.SVNMarkerListener;
import org.tigris.subversion.subclipse.ui.actions.SVNPluginAction;
import org.tigris.subversion.subclipse.ui.actions.ShowOutOfDateFoldersAction;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.authentication.SVNPromptUserPassword;
import org.tigris.subversion.subclipse.ui.compare.UIBaseResourceStorageFactory;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;
import org.tigris.subversion.subclipse.ui.console.SVNOutputConsole;
import org.tigris.subversion.subclipse.ui.repository.RepositoryManager;
import org.tigris.subversion.subclipse.ui.repository.model.SVNAdapterFactory;
import org.tigris.subversion.subclipse.ui.util.SimpleDialogsHelper;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;

public class SVNUIPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.tigris.subversion.subclipse.ui";
    public static final String DECORATOR_ID = "org.tigris.subversion.subclipse.ui.decorator";
    public static final String PROVIDER_ID = "org.tigris.subversion.subclipse.core.svnnature";
    public static final String MERGE_PROVIDERS = "org.tigris.subversion.subclipse.ui.mergeProviders";
    public static final String COMMIT_DIALOG_TOOLBAR_ACTIONS = "org.tigris.subversion.subclipse.ui.commitDialogToolBarActions";
    public static final String COMMIT_DIALOG_COMPARE_ACTIONS = "org.tigris.subversion.subclipse.ui.commitDialogCompareActions";
    public static final String REPOSITORY_SOURCE_PROVIDERS = "org.tigris.subversion.subclipse.ui.svnRepositorySourceProviders";
    public static final String P_DECORATORS_CHANGED = "org.tigris.subversion.subclipse.ui.P_DECORATORS_CHANGED";
    private static SVNUIPlugin plugin;
    private static boolean loadErrorHandled;
    private RepositoryManager repositoryManager;
    private ImageDescriptors imageDescriptors;
    private Preferences preferences;
    private static WorkspaceAction[] mergeProviders;
    private static SVNPluginAction[] commitDialogToolBarActions;
    private static SVNPluginAction[] commitDialogCompareActions;
    private static ISVNRepositorySourceProvider[] repositorySourceProviders;
    private SVNMarkerListener markerListener;
    private ShowOutOfDateFoldersAction showOutOfDateFoldersAction;
    public static final boolean TEST_MODE;
    public static final int PERFORM_SYNC_EXEC = 1;
    public static final int LOG_TEAM_EXCEPTIONS = 2;
    public static final int LOG_CORE_EXCEPTIONS = 4;
    public static final int LOG_OTHER_EXCEPTIONS = 8;
    public static final int LOG_NONTEAM_EXCEPTIONS = 12;
    private SVNOutputConsole console;
    private URL baseURL;

    static {
        loadErrorHandled = false;
        String application = System.getProperty("eclipse.application", "");
        if (application.length() > 0) {
            TEST_MODE = application.endsWith("testapplication") || application.endsWith("uitest");
        } else {
            String commands = System.getProperty("eclipse.commands", "");
            TEST_MODE = commands.contains("testapplication\n");
        }
    }

    public static void log(CoreException e) {
        SVNUIPlugin.log(e.getStatus().getSeverity(), Policy.bind("simpleInternal"), e);
    }

    public static void log(int severity, String message, Throwable e) {
        SVNUIPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public SVNUIPlugin() {
        plugin = this;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static void runWithProgress(Shell parent, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean createdShell = false;
        try {
            if (parent == null || parent.isDisposed()) {
                Display display = Display.getCurrent();
                if (display == null) {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                parent = display.getActiveShell();
                if (parent == null) {
                    parent = new Shell(display);
                    createdShell = true;
                }
            }
            final Exception[] holder = new Exception[1];
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        holder[0] = e;
                    }
                    catch (InterruptedException e) {
                        holder[0] = e;
                    }
                }
            });
            if (holder[0] != null) {
                if (holder[0] instanceof InvocationTargetException) {
                    throw (InvocationTargetException)holder[0];
                }
                throw (InterruptedException)holder[0];
            }
        }
        finally {
            if (createdShell) {
                parent.dispose();
            }
        }
    }

    public static SVNUIPlugin getPlugin() {
        return plugin;
    }

    public synchronized RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RepositoryManager();
            this.repositoryManager.startup();
        }
        return this.repositoryManager;
    }

    public static void log(IStatus status) {
        SVNUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(String msg) {
        SVNUIPlugin.getPlugin().getLog().log((IStatus)new Status(1, ID, 0, msg, null));
    }

    public static void log(TeamException e) {
        SVNUIPlugin.getPlugin().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), ID, 0, Policy.bind("simpleInternal"), (Throwable)e));
    }

    public static IStatus openError(Shell shell, String title, String message, Throwable exception) {
        return SVNUIPlugin.openError(shell, title, message, exception, 8);
    }

    public static IStatus openError(Shell providedShell, String title, String message, Throwable exception, int flags) {
        String svnInterface;
        boolean loadError;
        if (exception instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)exception).getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            return SVNUIPlugin.openError(providedShell, title, message, target, flags);
        }
        IStatus status = null;
        boolean log = false;
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
            log = (flags & 4) > 0;
        } else if (exception instanceof TeamException) {
            status = ((TeamException)exception).getStatus();
            log = (flags & 2) > 0;
        } else {
            if (exception instanceof InterruptedException) {
                return new SVNStatus(0, Policy.bind("ok"));
            }
            if (exception != null) {
                status = new SVNStatus(4, Policy.bind("internal"), exception);
                boolean bl = log = (flags & 8) > 0;
                if (title == null) {
                    title = Policy.bind("SimpleInternal");
                }
            }
        }
        if (status.getCode() == 75) {
            message = Policy.bind("buildError");
            log = true;
        }
        if (status.isMultiStatus() && status.getChildren().length == 1) {
            status = status.getChildren()[0];
        }
        if (status.isOK()) {
            return status;
        }
        if (log) {
            SVNUIPlugin.log(status);
        }
        boolean bl = loadError = (svnInterface = SVNUIPlugin.getPlugin().getPreferenceStore().getString("pref_svninterface")).equals("javahl") && status != null && status.getMessage() != null && status.getMessage().equals("Unable to load default SVN Client");
        if (!loadError || loadErrorHandled) {
            final String displayTitle = title;
            final String displayMessage = message;
            final IStatus displayStatus = status;
            IOpenableInShell openable = new IOpenableInShell(){

                @Override
                public void open(Shell shell) {
                    if (displayStatus.getSeverity() == 1 && !displayStatus.isMultiStatus()) {
                        MessageDialog.openInformation((Shell)shell, (String)Policy.bind("information"), (String)displayStatus.getMessage());
                    } else {
                        ErrorDialog.openError((Shell)shell, (String)displayTitle, (String)displayMessage, (IStatus)displayStatus);
                    }
                }
            };
            SVNUIPlugin.openDialog(providedShell, openable, flags);
        }
        if (loadError) {
            loadErrorHandled = true;
        }
        return status;
    }

    public static void openDialog(Shell providedShell, final IOpenableInShell openable, int flags) {
        IWorkbenchWindow window;
        if (providedShell == null && (window = SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow()) != null) {
            providedShell = window.getShell();
            flags |= 1;
        }
        final Shell shell = providedShell;
        Runnable outerRunnable = new Runnable(){

            @Override
            public void run() {
                Shell displayShell;
                if (shell == null) {
                    Display display = Display.getCurrent();
                    displayShell = new Shell(display);
                } else {
                    displayShell = shell;
                }
                openable.open(displayShell);
                if (shell == null) {
                    displayShell.dispose();
                }
            }
        };
        if (shell == null || (flags & 1) > 0) {
            Display display;
            if (shell == null) {
                display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
            } else {
                display = shell.getDisplay();
            }
            display.syncExec(outerRunnable);
        } else {
            outerRunnable.run();
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        super.start(ctxt);
        mergeProviders = SVNUIPlugin.getMergeProviders();
        BaseResourceStorageFactory.setCurrent((IBaseResourceStorageFactory)new UIBaseResourceStorageFactory());
        SVNAdapterFactory factory = new SVNAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, ISVNRemoteFile.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, ISVNRemoteFolder.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, ISVNRepositoryLocation.class);
        this.baseURL = ctxt.getBundle().getEntry("/");
        this.preferences = new Preferences(this.getPreferenceStore());
        this.preferences.initializeFromSettings();
        this.markerListener = new SVNMarkerListener();
        SVNProviderPlugin.addResourceStateChangeListener((IResourceStateChangeListener)this.markerListener);
        try {
            this.console = new SVNOutputConsole();
        }
        catch (RuntimeException e) {
            SVNUIPlugin.log(4, "Errors occurred starting the SVN console", e);
        }
        SVNProviderPlugin.getPlugin().setSvnPromptUserPassword((ISVNPromptUserPassword)new SVNPromptUserPassword());
        SVNProviderPlugin.getPlugin().setSimpleDialogsHelper((ISimpleDialogsHelper)new SimpleDialogsHelper());
        SVNProviderPlugin.getPlugin().setSvnFileModificationValidatorPrompt((ISVNFileModificationValidatorPrompt)new SVNFileModificationValidatorPrompt());
        this.showOutOfDateFoldersAction = new ShowOutOfDateFoldersAction();
    }

    public void stop(BundleContext ctxt) throws Exception {
        super.stop(ctxt);
        try {
            if (this.repositoryManager != null) {
                this.repositoryManager.shutdown();
            }
        }
        catch (TeamException e) {
            throw new CoreException(e.getStatus());
        }
        this.console.shutdown();
    }

    public void clearPasswordStoresFromConfiguration(boolean restart) throws Exception {
        Exception exception = null;
        File configFile = this.getConfigFile();
        if (configFile.exists()) {
            boolean written;
            File temp;
            block41: {
                temp = null;
                written = false;
                String newLine = System.getProperty("line.separator");
                BufferedReader input = null;
                BufferedWriter output = null;
                try {
                    try {
                        temp = File.createTempFile("config", null, configFile.getParentFile());
                        input = new BufferedReader(new FileReader(configFile));
                        output = new BufferedWriter(new FileWriter(temp));
                        String line = null;
                        boolean authSectionFound = false;
                        boolean passwordStoresFound = false;
                        boolean inAuthSection = false;
                        while ((line = input.readLine()) != null) {
                            if (line.startsWith("[auth]")) {
                                authSectionFound = true;
                                inAuthSection = true;
                            } else if (line.startsWith("[")) {
                                if (inAuthSection && !passwordStoresFound) {
                                    output.write("password-stores =" + newLine);
                                }
                                inAuthSection = false;
                            }
                            if (line.startsWith("password-stores =")) {
                                passwordStoresFound = true;
                                if (!line.trim().endsWith("password-stores =")) {
                                    line = "password-stores =";
                                }
                            }
                            if (line.startsWith("password-stores=")) {
                                passwordStoresFound = true;
                                if (!line.trim().endsWith("password-stores=")) {
                                    line = "password-stores=";
                                }
                            }
                            output.write(String.valueOf(line) + newLine);
                        }
                        if (!authSectionFound) {
                            output.write("[auth]" + newLine + "password-stores =");
                        } else if (inAuthSection && !passwordStoresFound) {
                            output.write("password-stores =" + newLine);
                        }
                        written = true;
                    }
                    catch (Exception e) {
                        exception = e;
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block41;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (exception != null) {
                throw exception;
            }
            if (written) {
                configFile.renameTo(new File(configFile.getParentFile(), "config_backup"));
                temp.renameTo(configFile);
                if (restart) {
                    PlatformUI.getWorkbench().restart();
                }
            } else if (temp != null && temp.exists()) {
                temp.deleteOnExit();
            }
        }
    }

    public File getConfigFile() {
        File configDir;
        String configDirPath = this.getPreferenceStore().getString("pref_svnconfigdir");
        if (configDirPath == null || configDirPath.trim().length() == 0) {
            File homeDirectory = new File(System.getProperty("user.home"));
            configDir = new File(homeDirectory, ".subversion");
        } else {
            configDir = new File(configDirPath);
        }
        File configFile = new File(configDir, "config");
        return configFile;
    }

    public String getPasswordStores() {
        String passwordStores;
        block17: {
            passwordStores = null;
            File configFile = this.getConfigFile();
            if (configFile.exists()) {
                BufferedReader input = null;
                try {
                    try {
                        input = new BufferedReader(new FileReader(configFile));
                        String line = null;
                        while ((line = input.readLine()) != null) {
                            if (!line.startsWith("password-stores =") && !line.startsWith("password-stores=")) continue;
                            if (!line.trim().endsWith("=")) {
                                int index = line.indexOf("=");
                                passwordStores = line.substring(index + 1);
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return passwordStores;
    }

    public boolean passwordStoresConfiguredOnLinux() {
        boolean valueIsGnomeKeyring;
        boolean passwordStoresFound;
        block29: {
            File configFile;
            block27: {
                if (System.getProperty("os.name").toLowerCase().indexOf("linux") == -1) {
                    return false;
                }
                String svnInterface = this.getPreferenceStore().getString("pref_svninterface");
                if (svnInterface != null && !svnInterface.equals("javahl")) {
                    return false;
                }
                passwordStoresFound = false;
                valueIsGnomeKeyring = false;
                configFile = this.getConfigFile();
                if (!configFile.exists()) {
                    ISVNClientAdapter client = null;
                    try {
                        try {
                            client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                            client.cleanup(new File("/This/is/just/a/dummy/file"));
                        }
                        catch (Exception exception) {
                            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                        throw throwable;
                    }
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                }
            }
            if (!configFile.exists()) {
                return false;
            }
            BufferedReader input = null;
            try {
                try {
                    input = new BufferedReader(new FileReader(configFile));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        if (line.startsWith("password-stores =")) {
                            passwordStoresFound = true;
                            if (!line.trim().endsWith("password-stores =")) {
                                valueIsGnomeKeyring = line.indexOf("gnome-keyring") != -1;
                            }
                        } else {
                            if (!line.startsWith("password-stores=")) continue;
                            passwordStoresFound = true;
                            if (!line.trim().endsWith("password-stores=")) {
                                valueIsGnomeKeyring = line.indexOf("gnome-keyring") != -1;
                            }
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return valueIsGnomeKeyring || !passwordStoresFound;
    }

    public static SVNPluginAction[] getCommitDialogToolBarActions() {
        if (commitDialogToolBarActions == null) {
            ArrayList<SVNPluginAction> actionsList = new ArrayList<SVNPluginAction>();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(COMMIT_DIALOG_TOOLBAR_ACTIONS);
            int i = 0;
            while (i < elements.length) {
                SVNPluginAction action = new SVNPluginAction(elements[i]);
                if (action.getDelegate() != null) {
                    actionsList.add(action);
                }
                ++i;
            }
            commitDialogToolBarActions = new SVNPluginAction[actionsList.size()];
            actionsList.toArray(commitDialogToolBarActions);
        }
        return commitDialogToolBarActions;
    }

    public static SVNPluginAction[] getCommitDialogCompareActions() {
        if (commitDialogCompareActions == null) {
            ArrayList<SVNPluginAction> actionsList = new ArrayList<SVNPluginAction>();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(COMMIT_DIALOG_COMPARE_ACTIONS);
            int i = 0;
            while (i < elements.length) {
                SVNPluginAction action = new SVNPluginAction(elements[i]);
                if (action.getDelegate() != null) {
                    actionsList.add(action);
                }
                ++i;
            }
            commitDialogCompareActions = new SVNPluginAction[actionsList.size()];
            actionsList.toArray(commitDialogCompareActions);
        }
        return commitDialogCompareActions;
    }

    public static WorkspaceAction[] getMergeProviders() throws Exception {
        if (mergeProviders == null) {
            ArrayList<WorkspaceAction> mergeProviderList = new ArrayList<WorkspaceAction>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(MERGE_PROVIDERS);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                WorkspaceAction mergeProvider = (WorkspaceAction)((Object)configurationElement.createExecutableExtension("class"));
                mergeProvider.setName(configurationElement.getAttribute("name"));
                mergeProviderList.add(mergeProvider);
                ++i;
            }
            mergeProviders = new WorkspaceAction[mergeProviderList.size()];
            mergeProviderList.toArray(mergeProviders);
        }
        return mergeProviders;
    }

    public static ISVNRepositorySourceProvider[] getRepositorySourceProviders() throws Exception {
        if (repositorySourceProviders == null) {
            ArrayList<ISVNRepositorySourceProvider> repositorySourceProviderList = new ArrayList<ISVNRepositorySourceProvider>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(REPOSITORY_SOURCE_PROVIDERS);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                ISVNRepositorySourceProvider repositorySourceProvider = (ISVNRepositorySourceProvider)configurationElement.createExecutableExtension("class");
                repositorySourceProvider.setId(configurationElement.getAttribute("id"));
                repositorySourceProviderList.add(repositorySourceProvider);
                ++i;
            }
            repositorySourceProviders = new ISVNRepositorySourceProvider[repositorySourceProviderList.size()];
            repositorySourceProviderList.toArray(repositorySourceProviders);
            Arrays.sort(repositorySourceProviders, new Comparator<ISVNRepositorySourceProvider>(){

                @Override
                public int compare(ISVNRepositorySourceProvider o1, ISVNRepositorySourceProvider o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return repositorySourceProviders;
    }

    public static WorkspaceAction getDefaultMergeProvider() {
        String mergeProvider = plugin.getPreferenceStore().getString("pref_merge_provider");
        if (mergeProvider != null) {
            int i = 0;
            while (i < mergeProviders.length) {
                if (mergeProviders[i].getName().equals(mergeProvider)) {
                    return mergeProviders[i];
                }
                ++i;
            }
        }
        return mergeProviders[0];
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public ImageDescriptor getImageDescriptor(String id) {
        if (this.imageDescriptors == null) {
            this.imageDescriptors = new ImageDescriptors();
            this.imageDescriptors.initializeImages(this.baseURL, this.getPreferenceStore().getInt("pref_menu_icon_set"));
        }
        return this.imageDescriptors.getImageDescriptor(id);
    }

    public void disableConsoleListener() {
        SVNProviderPlugin.getPlugin().setConsoleListener(null);
    }

    public void enableConsoleListener() {
        SVNProviderPlugin.getPlugin().setConsoleListener((IConsoleListener)this.console);
    }

    public static String getCharset(String name, InputStream stream) throws IOException {
        IContentDescription description = SVNUIPlugin.getContentDescription(name, stream);
        return description == null ? null : description.getCharset();
    }

    public static IContentDescription getContentDescription(String name, InputStream stream) throws IOException {
        IContentDescription iContentDescription;
        block7: {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            try {
                iContentDescription = contentTypeManager.getDescriptionFor(stream, name, IContentDescription.ALL);
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return iContentDescription;
    }

    public SVNOutputConsole getConsole() {
        return this.console;
    }

    public ShowOutOfDateFoldersAction getShowOutOfDateFoldersAction() {
        return this.showOutOfDateFoldersAction;
    }

    public org.osgi.service.prefs.Preferences getInstancePreferences() {
        return new InstanceScope().getNode(this.getBundle().getSymbolicName());
    }

    public MergeFileAssociation[] getMergeFileAssociations() throws BackingStoreException {
        ArrayList<MergeFileAssociation> associations = new ArrayList<MergeFileAssociation>();
        String[] childrenNames = MergeFileAssociation.getParentPreferences().childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            org.osgi.service.prefs.Preferences node = MergeFileAssociation.getParentPreferences().node(childrenNames[i]);
            MergeFileAssociation association = new MergeFileAssociation();
            association.setFileType(childrenNames[i]);
            association.setMergeProgram(node.get("mergeProgram", ""));
            association.setParameters(node.get("parameters", ""));
            association.setType(node.getInt("type", 0));
            associations.add(association);
            ++i;
        }
        Object[] associationArray = new MergeFileAssociation[associations.size()];
        associations.toArray(associationArray);
        Arrays.sort(associationArray);
        return associationArray;
    }

    public MergeFileAssociation getMergeFileAssociation(String fileName) throws BackingStoreException {
        MergeFileAssociation[] mergeFileAssociations = this.getMergeFileAssociations();
        int i = 0;
        while (i < mergeFileAssociations.length) {
            if (mergeFileAssociations[i].getFileType().equals(fileName)) {
                return mergeFileAssociations[i];
            }
            ++i;
        }
        i = 0;
        while (i < mergeFileAssociations.length) {
            if (mergeFileAssociations[i].matches(fileName)) {
                return mergeFileAssociations[i];
            }
            ++i;
        }
        MergeFileAssociation mergeFileAssociation = new MergeFileAssociation();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore.getBoolean("pref_merge_use_external")) {
            mergeFileAssociation.setType(1);
        } else {
            mergeFileAssociation.setType(0);
        }
        return mergeFileAssociation;
    }

    public static Image getImage(String key) {
        return SVNUIPlugin.getPlugin().getImageRegistry().get(key);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("clcl16/properties.png", this.getImageDescriptor("clcl16/properties.png"));
        reg.put("pending16/fileadd_pending.gif", this.getImageDescriptor("pending16/fileadd_pending.gif"));
        reg.put("elcl16/syncpane_co.gif", this.getImageDescriptor("elcl16/syncpane_co.gif"));
        reg.put("pending16/filedelete_pending.gif", this.getImageDescriptor("pending16/filedelete_pending.gif"));
        reg.put("pending16/filemodified_pending.gif", this.getImageDescriptor("pending16/filemodified_pending.gif"));
        reg.put("pending16/folderadd_pending.gif", this.getImageDescriptor("pending16/folderadd_pending.gif"));
        reg.put("pending16/folderdelete_pending.gif", this.getImageDescriptor("pending16/folderdelete_pending.gif"));
        reg.put("pending16/foldermodified_pending.gif", this.getImageDescriptor("pending16/foldermodified_pending.gif"));
        reg.put("pending16/folder_pending.gif", this.getImageDescriptor("pending16/folder_pending.gif"));
        reg.put("elcl16/compressedLayout.gif", this.getImageDescriptor("elcl16/compressedLayout.gif"));
        reg.put("elcl16/flatLayout.gif", this.getImageDescriptor("elcl16/flatLayout.gif"));
        reg.put("elcl16/treeLayout.gif", this.getImageDescriptor("elcl16/treeLayout.gif"));
        reg.put("elcl16/update_all.gif", this.getImageDescriptor("elcl16/update_all.gif"));
        reg.put("elcl16/commit_all.gif", this.getImageDescriptor("elcl16/commit_all.gif"));
        reg.put("ovr16/prop_conflicted_ov.gif", this.getImageDescriptor("ovr16/prop_conflicted_ov.gif"));
    }

    private boolean deleteFolder(File folder) {
        if (folder.isDirectory()) {
            String[] children = folder.list();
            int i = 0;
            while (i < children.length) {
                if (!this.deleteFolder(new File(folder, children[i]))) {
                    return false;
                }
                ++i;
            }
        }
        return folder.delete();
    }

    public static interface IOpenableInShell {
        public void open(Shell var1);
    }
}

