/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanClassReferences;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabels;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataUtils;
import org.springframework.ide.eclipse.beans.ui.model.metadata.IBeanMetadataLabelProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceLabelProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceLabelProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.ui.viewers.DecoratingWorkbenchTreePathLabelProvider;

public class BeansModelLabelProvider
extends DecoratingWorkbenchTreePathLabelProvider {
    public static final DefaultNamespaceLabelProvider DEFAULT_NAMESPACE_LABEL_PROVIDER = new DefaultNamespaceLabelProvider();

    public BeansModelLabelProvider() {
        super(false);
    }

    public BeansModelLabelProvider(boolean isDecorating) {
        super(isDecorating);
    }

    protected Image getImage(Object element, Object parentElement) {
        IBeanMetadataLabelProvider labelProvider;
        Image image = null;
        if (element instanceof IBeanMetadata && (labelProvider = BeanMetadataUtils.getLabelProvider((IBeanMetadata)element)) != null) {
            image = labelProvider.getImage(element);
        }
        if (element instanceof BeanMetadataNode) {
            return ((BeanMetadataNode)element).getImage();
        }
        if (element instanceof ISourceModelElement) {
            IModelElement context;
            INamespaceLabelProvider provider = NamespaceUtils.getLabelProvider((ISourceModelElement)element);
            IModelElement iModelElement = context = parentElement instanceof IModelElement ? (IModelElement)parentElement : null;
            image = provider != null ? provider.getImage((ISourceModelElement)element, context, this.isDecorating()) : DEFAULT_NAMESPACE_LABEL_PROVIDER.getImage((ISourceModelElement)element, context, this.isDecorating());
        } else if (element instanceof IModelElement) {
            image = parentElement instanceof IModelElement ? BeansModelImages.getImage((IModelElement)element, (IModelElement)parentElement, this.isDecorating()) : BeansModelImages.getImage((IModelElement)element);
        } else {
            if (element instanceof ZipEntryStorage) {
                return super.getImage((Object)((ZipEntryStorage)element).getFile(), parentElement);
            }
            if (element instanceof BeanClassReferences) {
                image = BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.arrow_obj.gif");
            } else if (element instanceof BeanMetadataReference && BeanMetadataUtils.getLabelProvider((BeanMetadataReference)element) != null) {
                image = BeanMetadataUtils.getLabelProvider((BeanMetadataReference)element).getImage(element);
            }
        }
        if (image != null) {
            if (this.isDecorating()) {
                image = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator().decorateImage(image, element);
            }
            return image;
        }
        return super.getImage(element, parentElement);
    }

    protected String getText(Object element, Object parentElement) {
        IBeanMetadataLabelProvider labelProvider;
        if (element instanceof IBeanMetadata && (labelProvider = BeanMetadataUtils.getLabelProvider((IBeanMetadata)element)) != null) {
            return labelProvider.getText(element);
        }
        if (element instanceof BeanMetadataNode) {
            return ((BeanMetadataNode)element).getLabel();
        }
        if (element instanceof ISourceModelElement) {
            IModelElement context;
            INamespaceLabelProvider provider = NamespaceUtils.getLabelProvider((ISourceModelElement)element);
            IModelElement iModelElement = context = parentElement instanceof IModelElement ? (IModelElement)parentElement : null;
            if (provider != null) {
                return provider.getText((ISourceModelElement)element, context, this.isDecorating());
            }
            return DEFAULT_NAMESPACE_LABEL_PROVIDER.getText((ISourceModelElement)element, context, this.isDecorating());
        }
        if (element instanceof IModelElement) {
            return BeansModelLabels.getElementLabel((IModelElement)element, 0);
        }
        if (element instanceof ZipEntryStorage) {
            ZipEntryStorage storage = (ZipEntryStorage)element;
            StringBuilder builder = new StringBuilder();
            builder.append(storage.getFullPath().lastSegment());
            builder.append(" - ");
            builder.append(storage.getFile().getProjectRelativePath().toString());
            builder.append("!");
            builder.append(storage.getFullPath().removeLastSegments(1).toString());
            return builder.toString();
        }
        if (element instanceof BeanClassReferences) {
            return BeansUIPlugin.getResourceString("BeanClassReferences.label");
        }
        if (element instanceof BeanMetadataReference && (labelProvider = BeanMetadataUtils.getLabelProvider((BeanMetadataReference)element)) != null) {
            return labelProvider.getText(element);
        }
        return super.getText(element, parentElement);
    }
}

