/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.ChangeCommitPropertiesCommand;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.NodeFigure;
import org.tigris.subversion.subclipse.graph.editors.NodeTooltipFigure;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.SetCommitPropertiesDialog;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SetCommitPropertiesAction
extends Action {
    private NodeFigure nodeFigure;
    private Node node;
    private RevisionGraphEditor editor;

    public SetCommitPropertiesAction(NodeFigure nodeFigure, RevisionGraphEditor editor) {
        this.nodeFigure = nodeFigure;
        this.editor = editor;
        this.node = nodeFigure.getNode();
        this.setText("Set commit properties...");
    }

    public void run() {
        try {
            IResource resource = ((RevisionGraphEditorInput)this.editor.getEditorInput()).getResource();
            ISVNRemoteResource remoteResource = ((RevisionGraphEditorInput)this.editor.getEditorInput()).getRemoteResource();
            ISVNInfo info = ((RevisionGraphEditorInput)this.editor.getEditorInput()).getInfo();
            ProjectProperties projectProperties = resource != null ? ProjectProperties.getProjectProperties((IResource)resource) : ProjectProperties.getProjectProperties((ISVNRemoteResource)remoteResource);
            SVNRevision.Number revision = new SVNRevision.Number(this.node.getRevision());
            SetCommitPropertiesDialog dialog = new SetCommitPropertiesDialog(Display.getDefault().getActiveShell(), (SVNRevision)revision, resource, projectProperties);
            dialog.setOldAuthor(this.node.getAuthor());
            dialog.setOldComment(this.node.getMessage());
            if (dialog.open() == 0) {
                final String author = this.node.getAuthor().equals(dialog.getAuthor()) ? null : dialog.getAuthor();
                final String commitComment = this.node.getMessage().equals(dialog.getComment()) ? null : dialog.getComment();
                ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(info.getRepository().toString());
                final ChangeCommitPropertiesCommand command = new ChangeCommitPropertiesCommand(repository, revision, commitComment, author);
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            try {
                                command.run(monitor);
                            }
                            catch (SVNException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            if (command.isAuthorChanged()) {
                                SetCommitPropertiesAction.this.node.setAuthor(author);
                            }
                            if (command.isLogMessageChanged()) {
                                SetCommitPropertiesAction.this.node.setMessage(commitComment);
                            }
                            if (command.isAuthorChanged() || command.isLogMessageChanged()) {
                                SetCommitPropertiesAction.this.nodeFigure.setToolTip((IFigure)new NodeTooltipFigure(SetCommitPropertiesAction.this.node));
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            SVNUIPlugin.openError((Shell)Display.getDefault().getActiveShell(), null, null, (Throwable)e, (int)2);
        }
    }
}

