/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.cache.Cache;
import org.tigris.subversion.subclipse.graph.cache.Graph;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.CallbackUpdater;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.graph.editors.WorkMonitorListener;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class GraphBackgroundTask
extends SVNOperation {
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    private GraphicalViewer viewer;
    private RevisionGraphEditor editor;
    private SVNRevision refreshRevision;
    private Node refreshNode;
    private SVNRevision[] refreshRevisions;
    private Node[] refreshNodes;
    private boolean includeMergedRevisions = false;
    private boolean getNewRevisions = true;
    private Graph graph;
    private static final int TOTAL_STEPS = Integer.MAX_VALUE;
    private static final int SHORT_TASK_STEPS = 42949672;
    private static final int VERY_LONG_TASK = 0x3FFFFFFF;
    private static final int TASK_STEPS = 472446404;

    protected GraphBackgroundTask(IWorkbenchPart part, GraphicalViewer viewer, RevisionGraphEditor editor) {
        super(part);
        this.viewer = viewer;
        this.editor = editor;
    }

    public GraphBackgroundTask(IWorkbenchPart part, GraphicalViewer viewer, RevisionGraphEditor editor, IResource resource) {
        this(part, viewer, editor);
        this.resource = resource;
    }

    public GraphBackgroundTask(IWorkbenchPart part, GraphicalViewer viewer, RevisionGraphEditor editor, ISVNRemoteResource remoteResource) {
        this(part, viewer, editor);
        this.remoteResource = remoteResource;
    }

    public void setGetNewRevisions(boolean getNewRevisions) {
        this.getNewRevisions = getNewRevisions;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        block25: {
            block26: {
                block23: {
                    block24: {
                        error = false;
                        cache = null;
                        monitor.beginTask("Calculating graph information", 0x7FFFFFFF);
                        monitor.worked(42949672);
                        client = null;
                        client = SVNProviderPlugin.getPlugin().getSVNClient();
                        if (this.resource == null) {
                            info = client.getInfo(this.remoteResource.getUrl());
                        } else {
                            info = this.resource.getRawLocation() == null ? client.getInfoFromWorkingCopy(this.resource.getLocation().toFile()) : client.getInfoFromWorkingCopy(this.resource.getRawLocation().toFile());
                            if (info.getUuid() == null) {
                                info = client.getInfo(info.getUrl());
                            }
                        }
                        if (this.editor != null) {
                            ((RevisionGraphEditorInput)this.editor.getEditorInput()).setInfo(info);
                        }
                        revision = info.getRevision().getNumber();
                        path = info.getUrl().toString().substring(info.getRepository().toString().length());
                        monitor.setTaskName("Initializating cache");
                        cache = this.getCache(info.getUuid());
                        monitor.worked(42949672);
                        latestRevisionStored = cache.getLatestRevision();
                        latest /* !! */  = null;
                        endRevision = null;
                        monitor.setTaskName("Connecting to the repository");
                        latestRevisionInRepository = client.getInfo(info.getRepository()).getLastChangedRevision().getNumber();
                        monitor.worked(42949672);
                        if (this.refreshRevision == null && this.refreshRevisions == null && latestRevisionInRepository <= latestRevisionStored) ** GOTO lbl83
                        latest /* !! */  = this.refreshRevision == null ? (latestRevisionStored >= latestRevisionInRepository ? new SVNRevision.Number(latestRevisionInRepository) : new SVNRevision.Number(latestRevisionStored + 1L)) : this.refreshRevision;
                        endRevision = this.refreshRevision == null ? SVNRevision.HEAD : this.refreshRevision;
                        monitor.setTaskName("Retrieving revision history");
                        unitWork = this.refreshRevision == null && this.refreshRevisions == null ? 0x3FFFFFFF / (int)(latestRevisionInRepository - latestRevisionStored) : (this.refreshRevisions != null ? 0x3FFFFFFF / this.refreshRevisions.length : 0x3FFFFFFF);
                        if (this.refreshRevisions == null) ** GOTO lbl53
                        if (!monitor.isCanceled()) break block23;
                        if (cache == null) break block24;
                        cache.close();
                    }
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                    return;
                }
                monitor.setTaskName("Refreshing cache");
                refreshedNodes = new ArrayList<Node>();
                i = 0;
                while (i < this.refreshNodes.length) {
                    if (this.refreshNodes[i].getAction() != 'D') {
                        refreshedNodes.add(this.refreshNodes[i]);
                    }
                    ++i;
                }
                cache.refresh(refreshedNodes, info, monitor, unitWork);
                ** GOTO lbl71
lbl53:
                // 1 sources

                if (this.refreshRevision == null) ** GOTO lbl71
                if (!monitor.isCanceled()) break block25;
                if (cache == null) break block26;
                cache.close();
            }
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
            return;
        }
        try {
            try {
                block27: {
                    monitor.setTaskName("Refreshing cache");
                    revision = this.refreshNode.getRevision();
                    path = this.refreshNode.getPath();
                    refreshedNodes = new ArrayList<E>();
                    refreshedNodes.add(this.refreshNode);
                    cache.refresh(refreshedNodes, info, monitor, unitWork);
lbl71:
                    // 3 sources

                    if (this.getNewRevisions) {
                        callbackUpdater = new CallbackUpdater(cache, monitor, unitWork, client);
                        cache.startUpdate();
                        client.getLogMessages(info.getRepository(), latest /* !! */ , latest /* !! */ , endRevision, false, true, 0L, this.includeMergedRevisions, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, (ISVNLogMessageCallback)callbackUpdater);
                        cache.finishUpdate();
                    }
                    break block27;
                    {
                        catch (Exception e) {
                            Activator.handleError(e);
                            error = true;
                            Activator.showErrorDialog("Calculate Revision Graph Information", e, false);
                        }
                    }
                    break block27;
lbl83:
                    // 1 sources

                    monitor.worked(0x3FFFFFFF);
                }
                if (this.editor != null) {
                    if (error || monitor.isCanceled()) {
                        if (this.refreshRevision == null && this.refreshRevisions == null) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchWindow window = GraphBackgroundTask.this.editor.getEditorSite().getWorkbenchWindow();
                                    IWorkbenchPage page = window.getActivePage();
                                    page.activate((IWorkbenchPart)GraphBackgroundTask.this.editor);
                                    page.closeEditor((IEditorPart)GraphBackgroundTask.this.editor, false);
                                }
                            });
                        }
                    } else {
                        this.updateView(monitor, cache, path, revision);
                    }
                }
                monitor.done();
            }
            catch (Exception e) {
                Activator.handleError(e);
                Activator.showErrorDialog("Calculate Revision Graph Information", e, false);
                if (cache != null) {
                    cache.close();
                }
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                return;
            }
        }
        catch (Throwable var18_17) {
            throw var18_17;
        }
        finally {
            if (cache != null) {
                cache.close();
            }
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
        }
    }

    private void updateView(IProgressMonitor monitor, Cache cache, String path, long revision) {
        monitor.setTaskName("Finding root node");
        int unitWork = 472446404 / (int)revision;
        if (unitWork < 1) {
            unitWork = 1;
        }
        Node root = cache.findRootNode(path, revision, new WorkMonitorListener(monitor, unitWork));
        monitor.setTaskName("Calculating graph");
        unitWork = revision == root.getRevision() ? 472446404 : 472446404 / (int)(revision - root.getRevision());
        if (unitWork < 1) {
            unitWork = 1;
        }
        this.graph = cache.createGraph(root.getPath(), root.getRevision(), new WorkMonitorListener(monitor, unitWork));
        this.graph.setSelectedPath(path);
        this.graph.setSelectedRevision(revision);
        monitor.setTaskName("Drawing graph");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphBackgroundTask.this.viewer.setContents((Object)GraphBackgroundTask.this.graph);
            }
        });
    }

    private Cache getCache(String uuid) {
        File f = Cache.getCacheDirectory(this.resource);
        if (this.refreshRevision == null) {
            return new Cache(f, uuid);
        }
        return new Cache(f, uuid, Long.parseLong(this.refreshRevision.toString()));
    }

    protected String getTaskName() {
        return "Calculating graph information";
    }

    public void setRefreshRevision(SVNRevision refreshRevision, Node refreshNode) {
        this.refreshRevision = refreshRevision;
        this.refreshNode = refreshNode;
        this.includeMergedRevisions = refreshRevision != null;
    }

    public void setRefreshRevisions(SVNRevision[] refreshRevisions, Node[] refreshNodes) {
        this.refreshRevisions = refreshRevisions;
        this.refreshNodes = refreshNodes;
        this.includeMergedRevisions = refreshRevisions != null;
    }

    public void setIncludeMergedRevisions(boolean includeMergedRevisions) {
        this.includeMergedRevisions = includeMergedRevisions;
    }
}

