/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotationMemberVisitor
extends AnnotationVisitor {
    private final Annotation annotation;
    private final ClassLoader classloader;
    private boolean advancedValueProcessing;

    public AnnotationMemberVisitor(Annotation annotation, ClassLoader classloader, boolean advancedValueProcessing) {
        super(393216);
        this.annotation = annotation;
        this.classloader = classloader;
        this.advancedValueProcessing = advancedValueProcessing;
    }

    public void visitEnd() {
        if (this.advancedValueProcessing) {
            try {
                Class<?> annotationClass = this.classloader.loadClass(this.annotation.getAnnotationClass());
                this.registerDefaultValues(annotationClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private void registerDefaultValues(Class<?> annotationClass) {
        Method[] annotationAttributes;
        Method[] methodArray = annotationAttributes = annotationClass.getMethods();
        int n = annotationAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            Method annotationAttribute = methodArray[n2];
            String attributeName = annotationAttribute.getName();
            AnnotationAttributes[] defaultValue = annotationAttribute.getDefaultValue();
            if (defaultValue != null && defaultValue.getClass().isEnum()) {
                try {
                    Class<?> annotationClassInIdeSpace = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.annotation.getAnnotationClass());
                    Method annotationAttributeInIdeSpace = annotationClassInIdeSpace.getMethod(annotationAttribute.getName(), annotationAttribute.getParameterTypes());
                    defaultValue = annotationAttributeInIdeSpace.getDefaultValue();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (defaultValue != null && !this.annotation.hasMember(attributeName)) {
                if (defaultValue instanceof java.lang.annotation.Annotation) {
                    defaultValue = AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((java.lang.annotation.Annotation)((java.lang.annotation.Annotation)defaultValue), (boolean)false, (boolean)true));
                } else if (defaultValue instanceof java.lang.annotation.Annotation[]) {
                    java.lang.annotation.Annotation[] realAnnotations = (java.lang.annotation.Annotation[])defaultValue;
                    AnnotationAttributes[] mappedAnnotations = new AnnotationAttributes[realAnnotations.length];
                    int i = 0;
                    while (i < realAnnotations.length) {
                        mappedAnnotations[i] = AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((java.lang.annotation.Annotation)realAnnotations[i], (boolean)false, (boolean)true));
                        ++i;
                    }
                    defaultValue = mappedAnnotations;
                }
                this.annotation.addMember(new AnnotationMemberValuePair(attributeName, defaultValue.toString(), defaultValue));
            }
            ++n2;
        }
    }

    public void visit(String name, Object value) {
        if ("value".equals(name)) {
            this.annotation.addMember(new AnnotationMemberValuePair(null, value.toString()));
        } else {
            this.annotation.addMember(new AnnotationMemberValuePair(name, value.toString()));
        }
    }

    public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
        return AnnotationMetadataReadingVisitor.EMPTY_ANNOTATION_VISITOR;
    }

    public AnnotationVisitor visitArray(final String name) {
        final LinkedHashSet values = new LinkedHashSet();
        return new EmptyAnnotationVisitor(){

            public void visit(String arg0, Object arg1) {
                if (arg1 instanceof Type && AnnotationMemberVisitor.this.advancedValueProcessing) {
                    try {
                        Class<?> clazz = AnnotationMemberVisitor.this.classloader.loadClass(((Type)arg1).getClassName());
                        values.add(clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    values.add(arg1);
                }
            }

            public void visitEnd() {
                String value2;
                StringBuilder buf = new StringBuilder();
                Class<?> typeOfArray = null;
                for (String value2 : values) {
                    typeOfArray = value2.getClass();
                    buf.append(value2.toString());
                    buf.append(", ");
                }
                value2 = buf.toString();
                if (value2.length() > 0) {
                    value2 = value2.substring(0, value2.length() - 2);
                }
                if (typeOfArray != null && name.equals("value") && !AnnotationMemberVisitor.this.advancedValueProcessing) {
                    AnnotationMemberVisitor.this.annotation.addMember(new AnnotationMemberValuePair(null, value2, values.toArray(new Object[values.size()])));
                } else if (typeOfArray != null && !AnnotationMemberVisitor.this.annotation.hasMember(name)) {
                    AnnotationMemberVisitor.this.annotation.addMember(new AnnotationMemberValuePair(name, value2, values.toArray(new Object[values.size()])));
                }
            }

            public void visitEnum(String enumName, String type, String enumValue) {
                String className = Type.getType((String)type).getClassName();
                String value = String.valueOf(ClassUtils.getShortName((String)className)) + "." + enumValue;
                values.add(value);
            }
        };
    }

    public void visitEnum(String name, String type, String enumValue) {
        String className = Type.getType((String)type).getClassName();
        Object valueAsObject = null;
        try {
            Class<?> enumType = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            Field enumConstant = ReflectionUtils.findField(enumType, (String)enumValue);
            if (enumConstant != null) {
                valueAsObject = enumConstant.get(null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        this.annotation.addMember(new AnnotationMemberValuePair(name, String.valueOf(ClassUtils.getShortName((String)className)) + "." + enumValue, valueAsObject));
    }
}

