/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class QualifierCompletionProposal
extends AnnotationCompletionProposal {
    private final BodyDeclaration decl;
    private final ASTNode annotationNode;

    public QualifierCompletionProposal(ASTNode annotationNode, BodyDeclaration decl, JavaContentAssistInvocationContext javaContext) {
        super("Qualifier(\"\") - " + Qualifier.class.getCanonicalName(), javaContext.getCompilationUnit(), QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.annotationNode = annotationNode;
        this.decl = decl;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.decl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String qualifierTypeName = Qualifier.class.getCanonicalName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), qualifierTypeName)) {
            CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.decl);
            ImportRewrite importRewrite = this.createImportRewrite(astRoot);
            importRewrite.addImport(qualifierTypeName);
        }
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        SimpleName typeName = ast.newSimpleName("Qualifier");
        StringLiteral beanValue = ast.newStringLiteral();
        annotation.setTypeName((Name)typeName);
        annotation.setValue((Expression)beanValue);
        this.setTrackPosition(new StringLiteralTrackedPosition(rewrite.track((ASTNode)beanValue)));
        rewrite.replace(this.annotationNode, (ASTNode)annotation, null);
        return rewrite;
    }
}

