/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.AnnotationComputerRegistry;
import org.springframework.ide.eclipse.quickfix.jdt.computers.AnnotationProposalComputer;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class AnnotationArgumentProposalComputer
extends JavaCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        JavaContentAssistInvocationContext javaContext;
        if (context instanceof JavaContentAssistInvocationContext && SpringCoreUtils.isSpringProject((IResource)(javaContext = (JavaContentAssistInvocationContext)context).getProject().getProject())) {
            ICompilationUnit cu = javaContext.getCompilationUnit();
            try {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                int invocationOffset = context.getInvocationOffset();
                IJavaElement element = cu.getElementAt(invocationOffset);
                cu.makeConsistent(monitor);
                if (element instanceof SourceRefElement && ((SourceRefElement)element).getElementInfo() instanceof AnnotatableInfo) {
                    IAnnotation[] annotations;
                    SourceRefElement sourceRefElement = (SourceRefElement)element;
                    IAnnotation[] iAnnotationArray = annotations = sourceRefElement.getAnnotations();
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation annotation = iAnnotationArray[n2];
                        String annotationName = annotation.getElementName();
                        if (javaContext.getViewer() instanceof SourceViewer && annotation instanceof SourceRefElement && this.isWithinRange((SourceRefElement)annotation, invocationOffset)) {
                            IMemberValuePair[] memberValuePairs;
                            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                            int n3 = memberValuePairs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                                String attributeName = memberValuePair.getMemberName();
                                proposals.addAll(this.computeCompletionProposals(annotationName, attributeName, memberValuePair.getValue(), annotation, element, javaContext));
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (proposals.size() > 0) {
                    return proposals;
                }
                JavaCompletionProposalComputer[] javaCompletionProposalComputerArray = AnnotationComputerRegistry.computers;
                int n = AnnotationComputerRegistry.computers.length;
                int n5 = 0;
                while (n5 < n) {
                    JavaCompletionProposalComputer computer = javaCompletionProposalComputerArray[n5];
                    List completionProposals = computer.computeCompletionProposals(context, monitor);
                    if (completionProposals != null) {
                        proposals.addAll(completionProposals);
                    }
                    ++n5;
                }
                return proposals;
            }
            catch (JavaModelException javaModelException) {}
        }
        return Collections.emptyList();
    }

    private boolean isWithinRange(SourceRefElement element, int invocationOffset) throws JavaModelException {
        int startPosition = element.getSourceRange().getOffset();
        int length = element.getSourceRange().getLength();
        return startPosition < invocationOffset && startPosition + length >= invocationOffset;
    }

    private List<ICompletionProposal> computeCompletionProposals(String annotationName, String attributeName, Object value, IAnnotation annotation, IJavaElement element, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (attributeName == null) {
            attributeName = "value";
        }
        if (value instanceof String) {
            proposals.addAll(this.computeCompletionProposalsHelper(element, AnnotationComputerRegistry.getProposalComputer(annotationName, attributeName), (String)value, javaContext, annotation));
        } else if (value instanceof Object[]) {
            Object[] values;
            Object[] objectArray = values = (Object[])value;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                if (v instanceof String) {
                    proposals.addAll(this.computeCompletionProposalsHelper(element, AnnotationComputerRegistry.getProposalComputerForArrayAttribute(annotationName, attributeName), (String)v, javaContext, annotation));
                }
                ++n2;
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> computeCompletionProposalsHelper(IJavaElement element, Set<AnnotationProposalComputer> computers, String value, JavaContentAssistInvocationContext javaContext, IAnnotation annotation) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (AnnotationProposalComputer computer : computers) {
            if (element instanceof SourceField) {
                proposals.addAll(computer.computeCompletionProposals((SourceField)element, value, annotation, javaContext));
            }
            if (element instanceof SourceMethod) {
                proposals.addAll(computer.computeCompletionProposals((SourceMethod)element, value, annotation, javaContext));
            }
            if (!(element instanceof SourceType)) continue;
            proposals.addAll(computer.computeCompletionProposals((SourceType)element, value, annotation, javaContext));
        }
        return proposals;
    }
}

