/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.Annotation;
import org.springframework.ide.eclipse.quickfix.jdt.util.UriTemplateVariable;

public class MissingPathVariableWarning
extends CategorizedProblem {
    public static final String MARKER_TYPE = "com.springsource.sts.jdt.quickfix.marker";
    public static final int PROBLEM_ID = 0x4000000;
    private int lineNumber;
    private final String fileName;
    private final UriTemplateVariable variable;

    public MissingPathVariableWarning(Annotation annotation, UriTemplateVariable variable, IFile file, int lineNumber) {
        this.fileName = file.getName();
        this.variable = variable;
        this.lineNumber = lineNumber;
    }

    public String[] getArguments() {
        return new String[0];
    }

    public int getCategoryID() {
        return 90;
    }

    public int getID() {
        return 0x4000000;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMarkerType() {
        return MARKER_TYPE;
    }

    public String getMessage() {
        return "URI template variable \"" + this.variable.getVariableName() + "\" is not defined";
    }

    public char[] getOriginatingFileName() {
        return this.fileName.toCharArray();
    }

    public int getSourceEnd() {
        return this.variable.getOffset() + this.variable.getVariableName().length() - 1;
    }

    public int getSourceLineNumber() {
        return this.lineNumber;
    }

    public int getSourceStart() {
        return this.variable.getOffset();
    }

    public boolean isError() {
        return false;
    }

    public boolean isWarning() {
        return true;
    }

    public void setSourceEnd(int sourceEnd) {
    }

    public void setSourceLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setSourceStart(int sourceStart) {
    }
}

