/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopTargetMethodNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

public class AdviceAopTargetBeanNode
implements IReferenceNode,
IRevealableReferenceNode {
    private List<IAopReference> references;

    public AdviceAopTargetBeanNode(List<IAopReference> reference) {
        this.references = reference;
    }

    @Override
    public IReferenceNode[] getChildren() {
        ArrayList<AdviceAopTargetMethodNode> nodes = new ArrayList<AdviceAopTargetMethodNode>();
        for (IAopReference r : this.references) {
            nodes.add(new AdviceAopTargetMethodNode(r));
        }
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public Image getImage() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.references.get(0).getTargetBeanId());
        if (bean != null) {
            return BeansUIPlugin.getLabelProvider().getImage((Object)bean);
        }
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.error_obj.gif");
    }

    @Override
    public String getText() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.references.get(0).getTargetBeanId());
        if (bean != null) {
            return String.valueOf(BeansUIPlugin.getLabelProvider().getText((Object)bean)) + " - " + ModelUtils.getFilePath(bean.getElementResource());
        }
        return "<bean cannot be found>";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void openAndReveal() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.references.get(0).getTargetBeanId());
        if (bean != null) {
            BeansUIUtils.openInEditor((IResourceModelElement)bean);
        }
    }

    public IAopReference getReference() {
        return this.references.get(0);
    }

    @Override
    public int getLineNumber() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.references.get(0).getTargetBeanId());
        if (bean != null) {
            return bean.getElementStartLine();
        }
        return -1;
    }

    public IBean getTargetBean() {
        return AopReferenceModelUtils.getBeanFromElementId((String)this.references.get(0).getTargetBeanId());
    }

    @Override
    public IResource getResource() {
        return this.references.get(0).getResource();
    }

    @Override
    public Object getReferenceParticipant() {
        return AopReferenceModelUtils.getBeanFromElementId((String)this.references.get(0).getTargetBeanId());
    }
}

