/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopTargetBeanNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;

public class AdviceAopReferenceNode
implements IReferenceNode {
    private List<IAopReference> references;

    public AdviceAopReferenceNode(List<IAopReference> reference) {
        this.references = reference;
    }

    @Override
    public IReferenceNode[] getChildren() {
        ArrayList<AdviceAopTargetBeanNode> nodes = new ArrayList<AdviceAopTargetBeanNode>();
        HashMap refs = new HashMap();
        for (IAopReference iAopReference : this.references) {
            if (refs.containsKey(iAopReference.getTargetBeanId())) {
                ((List)refs.get(iAopReference.getTargetBeanId())).add(iAopReference);
                continue;
            }
            ArrayList<IAopReference> ref = new ArrayList<IAopReference>();
            ref.add(iAopReference);
            refs.put(iAopReference.getTargetBeanId(), ref);
        }
        for (Map.Entry entry : refs.entrySet()) {
            nodes.add(new AdviceAopTargetBeanNode((List)entry.getValue()));
        }
        Collections.sort(nodes, new Comparator<IReferenceNode>(){

            @Override
            public int compare(IReferenceNode e1, IReferenceNode e2) {
                if (e1 instanceof IRevealableReferenceNode && e2 instanceof IRevealableReferenceNode) {
                    IRevealableReferenceNode ref1 = (IRevealableReferenceNode)((Object)e1);
                    IRevealableReferenceNode ref2 = (IRevealableReferenceNode)((Object)e2);
                    return ref1.getResource().getFullPath().toString().compareTo(ref2.getResource().getFullPath().toString());
                }
                return 0;
            }
        });
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public Image getImage() {
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.arrow_obj.gif");
    }

    @Override
    public String getText() {
        return "advises";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Object getReferenceParticipant() {
        return null;
    }
}

