/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.externaltype;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalType;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeSource;
import org.springsource.ide.eclipse.commons.completions.externaltype.indexing.ExternalTypeIndexer;

public class ExternalTypeCompletionProposal
extends LazyJavaTypeCompletionProposal {
    private ExternalTypeIndexer index;
    private ExternalType type;
    private IJavaProject project;
    private Image icon = null;

    public ExternalTypeCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context, ExternalType et, ExternalTypeIndexer index) {
        super(proposal, context);
        this.index = index;
        this.type = et;
        this.project = context.getProject();
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            super.apply(document, trigger, offset);
            IType existingType = this.project.findType(this.type.getFullyQualifiedName());
            if (existingType == null) {
                this.index.getSource(this.type).addToClassPath(this.project, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            CompletionsActivator.log(e);
        }
    }

    public Object getAdditionalProposalInfo(IProgressMonitor mon) {
        String info;
        ExternalTypeSource source = this.index.getSource(this.type);
        if (source != null && (info = source.getDescription()) != null && info.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getCSSStyles());
            buffer.append(info);
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            info = buffer.toString();
            return info;
        }
        return null;
    }

    protected Image computeImage() {
        try {
            if (this.icon == null) {
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.springsource.ide.eclipse.commons.completions/resources/greyed-class.png"));
                this.icon = descriptor.createImage();
            }
        }
        catch (Exception e) {
            CompletionsActivator.log(e);
        }
        if (this.icon == null) {
            return super.computeImage();
        }
        return this.icon;
    }
}

