/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.model;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;
import org.springframework.ide.eclipse.beans.ui.live.utils.JdtUtils;

public class TypeLookupImpl
implements TypeLookup {
    private final String appName;
    private final IProject project;

    public TypeLookupImpl(String appName, IProject project) {
        this.appName = appName;
        this.project = project;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    protected String cleanClassName(String className) {
        String cleanClassName = className;
        if (className != null) {
            int ix = className.indexOf(36);
            if (ix > 0) {
                cleanClassName = className.substring(0, ix);
            } else {
                ix = className.indexOf(35);
                if (ix > 0) {
                    cleanClassName = className.substring(0, ix);
                }
            }
        }
        return cleanClassName;
    }

    @Override
    public IType findType(String fqName) {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.relatedProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IType type = JdtUtils.getJavaType(project, this.cleanClassName(fqName));
            if (type != null) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IProject[] relatedProjects() {
        return new IProject[]{this.project};
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeLookupImpl) {
            TypeLookupImpl other = (TypeLookupImpl)obj;
            return Objects.equals(this.appName, other.appName) && Objects.equals(this.project, other.project);
        }
        return super.equals(obj);
    }
}

