/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansContext;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansResource;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;

public class LiveBeansModel
implements Comparable<LiveBeansModel> {
    private final List<LiveBean> beans = new ArrayList<LiveBean>();
    private final List<LiveBeansContext> contexts = new ArrayList<LiveBeansContext>();
    private final List<LiveBeansResource> resources = new ArrayList<LiveBeansResource>();
    private final TypeLookup typeLookup;

    public LiveBeansModel(TypeLookup typeLookup) {
        this.typeLookup = typeLookup;
    }

    public void addBeans(Collection<LiveBean> beansToAdd) {
        this.beans.addAll(beansToAdd);
    }

    public void addContexts(Collection<? extends LiveBeansContext> contextsToAdd) {
        this.contexts.addAll(contextsToAdd);
    }

    public void addResources(Collection<? extends LiveBeansResource> resourcesToAdd) {
        this.resources.addAll(resourcesToAdd);
    }

    @Override
    public int compareTo(LiveBeansModel o) {
        return this.getApplicationName().compareTo(o.getApplicationName());
    }

    public String getApplicationName() {
        if (this.typeLookup != null) {
            return this.typeLookup.getApplicationName();
        }
        return "";
    }

    public List<LiveBean> getBeans() {
        return this.beans;
    }

    public List<LiveBeansContext> getBeansByContext() {
        return this.contexts;
    }

    public List<LiveBeansResource> getBeansByResource() {
        return this.resources;
    }

    public TypeLookup getWorkspaceContext() {
        return this.typeLookup;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiveBeansModel) {
            LiveBeansModel other = (LiveBeansModel)obj;
            return this.contexts.equals(other.contexts) && Objects.equals(this.typeLookup, other.typeLookup);
        }
        return super.equals(obj);
    }
}

