/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansContext;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansResource;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;

public class LiveBeansJsonParser {
    private final TypeLookup typeLookup;
    private final String jsonInput;
    private Map<String, LiveBean> beansMap;
    private Map<String, LiveBeansContext> contextMap;
    private Map<String, LiveBeansResource> resourceMap;

    public LiveBeansJsonParser(TypeLookup typeLookup, String jsonInput) {
        this.jsonInput = jsonInput;
        this.typeLookup = typeLookup;
    }

    private void groupByResource() {
        for (LiveBean bean : this.beansMap.values()) {
            LiveBeansResource group;
            String resource = bean.getResource();
            if (this.resourceMap.containsKey(resource)) {
                group = this.resourceMap.get(resource);
                group.addElement(bean);
                continue;
            }
            group = new LiveBeansResource(resource);
            group.addElement(bean);
            this.resourceMap.put(resource, group);
        }
    }

    protected JSONArray extractContextsJson(String json) throws JSONException {
        return new JSONArray(json);
    }

    public LiveBeansModel parse() throws JSONException {
        this.beansMap = new LinkedHashMap<String, LiveBean>();
        this.contextMap = new LinkedHashMap<String, LiveBeansContext>();
        this.resourceMap = new LinkedHashMap<String, LiveBeansResource>();
        JSONArray contextsArray = this.extractContextsJson(this.jsonInput);
        this.parseContexts(contextsArray);
        this.populateContextDependencies(contextsArray);
        this.groupByResource();
        LiveBeansModel model = new LiveBeansModel(this.typeLookup);
        model.addBeans(this.beansMap.values());
        model.addContexts(this.contextMap.values());
        model.addResources(this.resourceMap.values());
        return model;
    }

    private void parseBeans(LiveBeansContext context, JSONArray beansArray) throws JSONException {
        int i = 0;
        while (i < beansArray.length()) {
            JSONObject beanJson = beansArray.getJSONObject(i);
            if (beanJson != null && beanJson.has("bean")) {
                LiveBean bean = this.parseBean(beanJson, context);
                bean.addAttribute("context", context.getLabel());
                context.addElement(bean);
                this.beansMap.put(bean.getId(), bean);
            }
            ++i;
        }
    }

    protected LiveBean parseBean(JSONObject beanJson, LiveBeansContext context) throws JSONException {
        LiveBean bean = new LiveBean(this.typeLookup, beanJson.getString("bean"));
        if (beanJson.has("scope")) {
            bean.addAttribute("scope", beanJson.getString("scope"));
        }
        if (beanJson.has("type")) {
            bean.addAttribute("type", beanJson.getString("type"));
        }
        if (beanJson.has("resource")) {
            bean.addAttribute("resource", beanJson.getString("resource"));
        }
        if (this.typeLookup != null && this.typeLookup.getApplicationName() != null) {
            bean.addAttribute("application name", this.typeLookup.getApplicationName());
        }
        return bean;
    }

    protected JSONArray extractBeans(JSONObject contextJson) {
        return contextJson.optJSONArray("beans");
    }

    protected String getContextId(JSONObject contextJson) throws JSONException {
        return contextJson.getString("context");
    }

    protected LiveBeansContext parseContext(JSONObject contextJson) throws JSONException {
        LiveBeansContext context = new LiveBeansContext(this.getContextId(contextJson));
        JSONArray beansArray = this.extractBeans(contextJson);
        if (beansArray != null) {
            this.parseBeans(context, beansArray);
        }
        return context;
    }

    private void parseContexts(JSONArray contextsArray) throws JSONException {
        int i = 0;
        while (i < contextsArray.length()) {
            JSONObject contextJson = contextsArray.optJSONObject(i);
            if (contextJson != null) {
                LiveBeansContext context = this.parseContext(contextJson);
                this.contextMap.put(context.getLabel(), context);
            }
            ++i;
        }
    }

    private void populateBeanDependencies(JSONArray beansArray) throws JSONException {
        int i = 0;
        while (i < beansArray.length()) {
            JSONObject beanJson = beansArray.optJSONObject(i);
            if (beanJson != null && beanJson.has("bean")) {
                LiveBean bean = this.beansMap.get(beanJson.getString("bean"));
                JSONArray dependencies = beanJson.optJSONArray("dependencies");
                if (dependencies != null) {
                    int j = 0;
                    while (j < dependencies.length()) {
                        String dependency = dependencies.getString(j);
                        LiveBean dependencyBean = this.beansMap.get(dependency);
                        if (dependencyBean != null) {
                            bean.addDependency(dependencyBean);
                        } else {
                            LiveBean dependentBean = new LiveBean(this.typeLookup, dependency, true);
                            if (this.typeLookup != null && this.typeLookup.getApplicationName() != null) {
                                dependentBean.addAttribute("application name", this.typeLookup.getApplicationName());
                            }
                            bean.addDependency(dependentBean);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void populateContextDependencies(JSONArray contextsArray) throws JSONException {
        int i = 0;
        while (i < contextsArray.length()) {
            JSONObject contextJson = contextsArray.optJSONObject(i);
            if (contextJson != null) {
                JSONArray beansArray;
                String parent;
                LiveBeansContext parentContext;
                LiveBeansContext context = this.contextMap.get(this.getContextId(contextJson));
                if (!contextJson.isNull("parent") && (parentContext = this.contextMap.get(parent = contextJson.getString("parent"))) != null) {
                    context.setParent(parentContext);
                }
                if ((beansArray = contextJson.optJSONArray("beans")) != null) {
                    this.populateBeanDependencies(beansArray);
                }
            }
            ++i;
        }
    }
}

