/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.actions;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.springframework.ide.eclipse.beans.ui.live.actions.AbstractOpenResourceAction;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;

public class OpenBeanClassAction
extends AbstractOpenResourceAction {
    public OpenBeanClassAction() {
        super("Open Bean Class");
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        List elements = selection.toList();
        for (Object obj : elements) {
            if (!(obj instanceof LiveBean)) continue;
            LiveBean bean = (LiveBean)obj;
            TypeLookup appName = bean.getTypeLookup();
            String beanClass = bean.getBeanType();
            if (appName == null) continue;
            if (beanClass != null && beanClass.trim().length() > 0) {
                if (beanClass.startsWith("com.sun.proxy")) {
                    String resourcePath;
                    String resource = bean.getResource();
                    if (resource == null || resource.trim().length() <= 0 || resource.equalsIgnoreCase(null) || !(resourcePath = this.extractResourcePath(resource)).endsWith(".class")) continue;
                    this.openInEditor(appName, this.extractClassName(resourcePath));
                    continue;
                }
                this.openInEditor(appName, beanClass);
                continue;
            }
            this.openInEditor(appName, bean.getId());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            List elements = selection.toList();
            for (Object obj : elements) {
                if (!(obj instanceof LiveBean)) continue;
                LiveBean bean = (LiveBean)obj;
                String beanClass = bean.getBeanType();
                if (beanClass != null && beanClass.trim().length() > 0) {
                    return true;
                }
                return this.hasTypeInProject(bean.getTypeLookup(), bean.getId());
            }
        }
        return false;
    }
}

