/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.async;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessConstructorRequestor;
import org.springsource.ide.eclipse.commons.frameworks.core.async.JavaConstructorHint;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;
import reactor.core.publisher.Flux;
import reactor.core.publisher.ReplayProcessor;
import reactor.util.concurrent.QueueSupplier;

public class FluxConstructorSearch {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");
    private BasicSearchEngine engine = new BasicSearchEngine();
    private IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
    private String pattern = null;
    private int patternRule = 2;
    private int bufferSize = QueueSupplier.SMALL_BUFFER_SIZE;
    private boolean useSystemJob = false;
    private int jobPriority = 10;

    private static void debug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public FluxConstructorSearch engine(BasicSearchEngine engine) {
        this.engine = engine;
        return this;
    }

    public FluxConstructorSearch scope(IJavaSearchScope scope) {
        this.scope = scope;
        return this;
    }

    public FluxConstructorSearch bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public FluxConstructorSearch patternRule(int patternRule) {
        this.patternRule = patternRule;
        return this;
    }

    public FluxConstructorSearch pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Flux<JavaConstructorHint> search() {
        this.validate();
        if (this.scope == null) {
            return Flux.empty();
        }
        final FluxSearchRequestor requestor = new FluxSearchRequestor();
        Job job = new Job("Search for " + this.pattern){

            protected IStatus run(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                FluxConstructorSearch.debug("Starting search for '" + FluxConstructorSearch.this.pattern + "'");
                try {
                    FluxConstructorSearch.this.engine.searchAllConstructorDeclarations(null, FluxConstructorSearch.this.pattern.toCharArray(), FluxConstructorSearch.this.patternRule, FluxConstructorSearch.this.scope, new IRestrictedAccessConstructorRequestor(){

                        public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction access) {
                            requestor.acceptSearchMatch(JavaConstructorHint.asHint(modifiers, simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, typeModifiers, packageName, extraFlags, path, access));
                        }
                    }, 1, monitor);
                    requestor.done();
                }
                catch (Exception e) {
                    FluxConstructorSearch.debug("Canceled search for: " + FluxConstructorSearch.this.pattern);
                    FluxConstructorSearch.debug("          exception: " + ExceptionUtil.getMessage((Throwable)e));
                    long duration = System.currentTimeMillis() - start;
                    FluxConstructorSearch.debug("          duration: " + duration + " ms");
                    requestor.cancel();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(this.useSystemJob);
        job.setPriority(this.jobPriority);
        job.schedule();
        return requestor.asFlux();
    }

    private void validate() {
        Assert.isNotNull((Object)this.engine, (String)"engine");
        Assert.isNotNull((Object)this.pattern, (String)"pattern");
        Assert.isLegal((this.bufferSize > 0 ? 1 : 0) != 0);
    }

    class FluxSearchRequestor {
        private boolean isCanceled = false;
        private ReplayProcessor<JavaConstructorHint> emitter;
        private Flux<JavaConstructorHint> flux;

        FluxSearchRequestor() {
            this.emitter = ReplayProcessor.create((int)FluxConstructorSearch.this.bufferSize).connect();
            this.flux = this.emitter.doOnCancel(() -> {
                boolean bl = this.isCanceled = true;
            });
        }

        public Flux<JavaConstructorHint> asFlux() {
            return this.flux;
        }

        public void acceptSearchMatch(JavaConstructorHint match) {
            if (this.isCanceled) {
                FluxConstructorSearch.debug("!!!! canceling search !!!!");
                throw new OperationCanceledException();
            }
            this.emitter.onNext((Object)match);
        }

        public void cancel() {
            this.isCanceled = true;
        }

        public void done() {
            this.emitter.onComplete();
        }
    }
}

