/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.async;

import java.time.Duration;
import java.util.Collection;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.cache.Cache;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.cache.LimitedTimeCache;
import reactor.core.publisher.Flux;

public abstract class CachingValueProvider<T> {
    private static final Duration DEFAULT_TIMEOUT;
    public static Duration TIMEOUT;
    private int MAX_RESULTS = 500;
    private Cache<String, CacheEntry> cache = this.createCache();

    static {
        TIMEOUT = DEFAULT_TIMEOUT = Duration.ofMillis(1000L);
    }

    public final Flux<T> getValues(IType type, IJavaSearchScope scope) {
        String key = this.key(type);
        CacheEntry cached = this.cache.get(key);
        if (cached == null) {
            cached = new CacheEntry(key, this.getValuesIncremental(type, scope));
            this.cache.put(key, cached);
        }
        return cached.values;
    }

    public final Collection<T> getValuesNow(IType type, IJavaSearchScope scope) {
        return (Collection)this.getValues(type, scope).take(TIMEOUT).collectList().block();
    }

    private Flux<T> getValuesIncremental(IType expectedType, IJavaSearchScope scope) {
        CacheEntry cached = this.cache.get(this.key(expectedType));
        if (cached != null) {
            System.out.println("cached " + expectedType + ": " + cached);
            if (cached.isComplete) {
                return cached.values;
            }
        }
        return this.getValuesAsycn(expectedType, scope);
    }

    protected abstract Flux<T> getValuesAsycn(IType var1, IJavaSearchScope var2);

    private String key(IType expectedType) {
        return expectedType == null ? null : expectedType.getFullyQualifiedName();
    }

    protected <K, V> Cache<K, V> createCache() {
        return new LimitedTimeCache(Duration.ofMinutes(1L));
    }

    public static void restoreDefaults() {
        TIMEOUT = DEFAULT_TIMEOUT;
    }

    private class CacheEntry {
        boolean isComplete = false;
        int count = 0;
        Flux<T> values;

        public CacheEntry(String query, Flux<T> producer) {
            this.values = producer.take((long)CachingValueProvider.this.MAX_RESULTS).cache(CachingValueProvider.this.MAX_RESULTS);
            this.values.subscribe();
        }

        public String toString() {
            return "CacheEntry [isComplete=" + this.isComplete + ", count=" + this.count + "]";
        }
    }
}

