/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;

public class Filters {
    private static final Filter ACCEPT_ALL = new Filter(){

        public boolean accept(Object t) {
            return true;
        }

        @Override
        public boolean isTrivial() {
            return true;
        }
    };

    public static <T> Filter<T> acceptAll() {
        return ACCEPT_ALL;
    }

    public static <T> Filter<T> compose(final Filter<T> f1, final Filter<T> f2) {
        if (f1 == ACCEPT_ALL) {
            return f2;
        }
        if (f2 == ACCEPT_ALL) {
            return f1;
        }
        return new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return f1.accept(t) && f2.accept(t);
            }
        };
    }

    public static <T> LiveExpression<Filter<T>> compose(final LiveExpression<Filter<T>> f1, final LiveExpression<Filter<T>> f2) {
        Filter<T> initial = Filters.acceptAll();
        return new LiveExpression<Filter<T>>(initial){
            {
                super($anonymous0);
                this.dependsOn(liveExpression);
                this.dependsOn(liveExpression2);
            }

            @Override
            protected Filter<T> compute() {
                return Filters.compose((Filter)f1.getValue(), (Filter)f2.getValue());
            }
        };
    }

    public static <T> Filter<T> delegatingTo(final LiveExpression<Filter<T>> delegate) {
        return new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return Filters.ofNullable((Filter)delegate.getValue()).accept(t);
            }

            @Override
            public boolean isTrivial() {
                return Filters.ofNullable((Filter)delegate.getValue()).isTrivial();
            }

            @Override
            public Iterable<IRegion> getHighlights(String text) {
                return Filters.ofNullable((Filter)delegate.getValue()).getHighlights(text);
            }
        };
    }

    public static <T> Filter<T> ofNullable(Filter<T> maybeFilter) {
        return maybeFilter != null ? maybeFilter : Filters.acceptAll();
    }

    public static Filter<String> caseInsensitiveSubstring(String _lookfor) {
        String lookfor;
        if (_lookfor != null && !"".equals(lookfor = _lookfor.trim().toLowerCase())) {
            return new Filter<String>(){

                @Override
                public boolean accept(String text) {
                    return text.toLowerCase().contains(lookfor);
                }

                public List<IRegion> getHighlights(String text) {
                    int start = text.toLowerCase().indexOf(lookfor);
                    if (start >= 0) {
                        return ImmutableList.of((Object)new Region(start, lookfor.length()));
                    }
                    return ImmutableList.of();
                }

                public String toString() {
                    return "CaseInsensitiveSubstringFilter(" + lookfor + ")";
                }
            };
        }
        return Filters.acceptAll();
    }
}

