/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class ExceptionUtil {
    public static final IStatus OK_STATUS = ExceptionUtil.status(0, "");

    public static CoreException coreException(int severity, String msg) {
        return ExceptionUtil.coreException(ExceptionUtil.status(severity, msg));
    }

    public static CoreException coreException(IStatus status) {
        if (status == null) {
            return ExceptionUtil.coreException("Null status?");
        }
        Throwable e = status.getException();
        if (e == null) {
            return new CoreException(status);
        }
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return new CoreException(status);
    }

    public static CoreException coreException(String msg) {
        return ExceptionUtil.coreException(4, msg);
    }

    public static Throwable coreException(String msg, Throwable error) {
        return new CoreException(ExceptionUtil.status(error, msg));
    }

    public static CoreException coreException(Throwable e) {
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return ExceptionUtil.coreException(ExceptionUtil.status(e));
    }

    public static Throwable getDeepestCause(Throwable e) {
        Throwable cause = e;
        Throwable parent = e.getCause();
        while (parent != null && parent != e) {
            cause = parent;
            parent = cause.getCause();
        }
        return cause;
    }

    public static String getMessage(Throwable e) {
        Throwable cause = ExceptionUtil.getDeepestCause(e);
        String msg = String.valueOf(cause.getClass().getSimpleName()) + ": " + cause.getMessage();
        return msg;
    }

    public static IllegalStateException notImplemented(String string) {
        return new IllegalStateException("Not implemented: " + string);
    }

    public static IStatus status(int severity, String msg) {
        return new Status(severity, "Activator", msg);
    }

    public static IStatus status(Throwable e, String message) {
        if (message == null) {
            return ExceptionUtil.status(e);
        }
        return new Status(4, "Activator", message, e);
    }

    public static boolean isCancelation(Throwable e) {
        boolean isCancel;
        Throwable cause = e.getCause();
        boolean bl = isCancel = e instanceof OperationCanceledException || e instanceof InterruptedException || e instanceof CancellationException || e instanceof CoreException && ((CoreException)e).getStatus().getSeverity() == 8;
        return isCancel || cause != null && cause != e && ExceptionUtil.isCancelation(cause);
    }

    public static IStatus status(Throwable e) {
        if (ExceptionUtil.isCancelation(e)) {
            return Status.CANCEL_STATUS;
        }
        return ExceptionUtil.status(4, e);
    }

    public static IStatus status(int severity, Throwable e) {
        Throwable ee;
        IStatus status;
        if (e instanceof CoreException && (status = ((CoreException)e).getStatus()) != null && status.getSeverity() == severity && (ee = status.getException()) != null) {
            return status;
        }
        return new Status(severity, "Activator", ExceptionUtil.getMessage(e), e);
    }

    public static IStatus status(String msg) {
        return ExceptionUtil.status(4, msg);
    }

    public static Exception exception(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        return ExceptionUtil.coreException(e);
    }

    public static RuntimeException unchecked(Exception e) {
        return new RuntimeException(e);
    }

    public static String stacktrace() {
        return ExceptionUtil.stacktrace(new Exception("Stacktrace"));
    }

    public static String stacktrace(Throwable exception) {
        ByteArrayOutputStream dump = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(dump);){
            exception.printStackTrace(out);
        }
        return dump.toString();
    }

    public static String getSimpleError(Throwable e) {
        return e.getClass().getSimpleName();
    }
}

