/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TreeElementWrappingContentProvider
implements ITreeContentProvider {
    private Map<Object, TreeNode> rootNodes = new HashMap<Object, TreeNode>();
    private static final TreeNode[] NO_NODES = new TreeNode[0];
    private final ITreeContentProvider base;

    public TreeElementWrappingContentProvider(ITreeContentProvider base) {
        this.base = base;
    }

    public synchronized Object[] getElements(Object inputElement) {
        Object[] objects = this.base.getElements(inputElement);
        if (objects == null || objects.length == 0) {
            this.rootNodes.clear();
            return NO_NODES;
        }
        Object[] nodes = new TreeNode[objects.length];
        int i = 0;
        while (i < nodes.length) {
            Object object = objects[i];
            nodes[i] = this.rootNodes.get(object);
            if (nodes[i] == null) {
                nodes[i] = new TreeNode(object, null);
                this.rootNodes.put(object, (TreeNode)nodes[i]);
            }
            ++i;
        }
        this.rootNodes.keySet().retainAll((Collection<?>)ImmutableSet.copyOf((Object[])objects));
        return nodes;
    }

    private TreeNode[] wrap(Object[] elements, TreeNode parent) {
        if (elements != null && elements.length > 0) {
            TreeNode[] wrapped = new TreeNode[elements.length];
            int i = 0;
            while (i < elements.length) {
                wrapped[i] = new TreeNode(elements[i], parent);
                ++i;
            }
            return wrapped;
        }
        return NO_NODES;
    }

    public Object[] getChildren(Object _parent) {
        TreeNode parent = (TreeNode)_parent;
        return parent.getChildren();
    }

    public Object getParent(Object element) {
        return ((TreeNode)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((TreeNode)element).hasChildren();
    }

    public class TreeNode {
        private final Object value;
        private final TreeNode parent;
        private TreeNode[] children;

        private TreeNode(Object value, TreeNode parent) {
            this.parent = parent;
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }

        public TreeNode[] getChildren() {
            if (this.children == null) {
                this.children = TreeElementWrappingContentProvider.this.wrap(TreeElementWrappingContentProvider.this.base.getChildren(this.value), this);
            }
            return this.children;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public Object getWrappedValue() {
            return this.value;
        }

        public boolean hasChildren() {
            if (this.children == null) {
                return TreeElementWrappingContentProvider.this.base.hasChildren(this.value);
            }
            return this.children.length > 0;
        }
    }
}

