/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;

public class Stylers
implements Disposable {
    public static final StyledString.Styler NULL = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }

        public String toString() {
            return "Styler.NULL";
        }
    };
    private Font baseFont;
    private Font boldFont = null;
    private Font italicFont = null;

    public Stylers(Font baseFont) {
        this.baseFont = baseFont;
    }

    public StyledString.Styler hyperlink() {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                Stylers.this.darkBlue().applyStyles(textStyle);
                textStyle.underline = true;
            }
        };
    }

    public StyledString.Styler tag() {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = Stylers.this.getSystemColor(14);
                textStyle.underline = true;
                textStyle.font = Stylers.this.getBoldFont();
            }
        };
    }

    public StyledString.Styler tagBrackets() {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = Stylers.this.getSystemColor(14);
            }
        };
    }

    private Color getSystemColor(int colorCode) {
        return Display.getDefault().getSystemColor(colorCode);
    }

    public StyledString.Styler bold() {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = Stylers.this.getBoldFont();
            }
        };
    }

    private synchronized Font getBoldFont() {
        if (this.boldFont == null && this.baseFont != null) {
            FontData[] data = this.baseFont.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(1);
                ++i;
            }
            this.boldFont = new Font(this.baseFont.getDevice(), data);
        }
        return this.boldFont;
    }

    public synchronized Font getItalicFont() {
        if (this.italicFont == null && this.baseFont != null) {
            FontData[] data = this.baseFont.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(2);
                ++i;
            }
            this.italicFont = new Font(this.baseFont.getDevice(), data);
        }
        return this.italicFont;
    }

    @Override
    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
            this.italicFont = null;
        }
    }

    public StyledString.Styler darkGrey() {
        return this.color(16);
    }

    public StyledString.Styler darkGreen() {
        return this.color(6);
    }

    public StyledString.Styler darkBlue() {
        return this.color(10);
    }

    public StyledString.Styler grey() {
        return this.color(15);
    }

    public StyledString.Styler red() {
        return this.color(3);
    }

    private StyledString.Styler color(int colorCode) {
        final Color color = this.getSystemColor(colorCode);
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = color;
            }
        };
    }

    public StyledString.Styler italic() {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = Stylers.this.getItalicFont();
            }
        };
    }

    public StyledString.Styler italicColoured(int colorCode) {
        final Color color = this.getSystemColor(colorCode);
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = Stylers.this.getItalicFont();
                textStyle.foreground = color;
            }
        };
    }

    public StyledString.Styler boldColoured(int foregroundColour) {
        final Color foreGround = this.getSystemColor(foregroundColour);
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = Stylers.this.getBoldFont();
                textStyle.foreground = foreGround;
            }
        };
    }
}

