/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.ReflowableSection;

public class ExpandableSection
extends ReflowableSection
implements Disposable {
    private IPageSection child;
    private String title;
    private LiveVariable<Boolean> expansionState = new LiveVariable<Boolean>(true);

    public ExpandableSection(IPageWithSections owner, String title, IPageSection expandableContent) {
        super(owner);
        this.title = title;
        this.child = expandableContent;
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return OK_VALIDATOR;
    }

    @Override
    public void createContents(Composite page) {
        final ExpandableComposite comp = new ExpandableComposite(page, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        comp.setText(this.title);
        comp.setLayout((Layout)new FillLayout());
        comp.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                ExpandableSection.this.expansionState.setValue(comp.isExpanded());
                ExpandableSection.this.reflow(ExpandableSection.this.owner, (Composite)comp);
            }
        });
        this.expansionState.addListener(new ValueListener<Boolean>(){

            @Override
            public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                if (value != null && comp != null && !comp.isDisposed()) {
                    boolean newState = value;
                    boolean currentState = comp.isExpanded();
                    if (currentState != newState) {
                        comp.setExpanded(newState);
                        ExpandableSection.this.reflow(ExpandableSection.this.owner, (Composite)comp);
                    }
                }
            }
        });
        this.visibleState.addListener(new ValueListener<Boolean>(){

            @Override
            public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                if (value != null && comp != null && !comp.isDisposed()) {
                    boolean newState = value;
                    comp.setVisible(newState);
                    GridData data = (GridData)comp.getLayoutData();
                    data.exclude = !newState;
                    ExpandableSection.this.reflow(ExpandableSection.this.owner, (Composite)comp);
                }
            }
        });
        Composite client = new Composite((Composite)comp, 0);
        client.setLayout((Layout)new GridLayout());
        this.child.createContents(client);
        comp.setClient((Control)client);
    }

    public LiveVariable<Boolean> getExpansionState() {
        return this.expansionState;
    }

    @Override
    public void dispose() {
        if (this.child != null) {
            if (this.child instanceof Disposable) {
                ((Disposable)((Object)this.child)).dispose();
            }
            this.child = null;
        }
    }

    public String toString() {
        return "ExpandableSection(" + this.title + ")";
    }
}

