/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.springsource.ide.eclipse.commons.livexp.core.ObservableSet;

public class LiveSets {
    public static final ObservableSet EMPTY_SET = ObservableSet.constant(ImmutableSet.of());

    public static <T> ObservableSet<T> emptySet(Class<T> t) {
        return EMPTY_SET;
    }

    public static <R, A extends R, B extends R> ObservableSet<R> union(ObservableSet<A> e1, ObservableSet<B> e2) {
        if (e1 == EMPTY_SET) {
            return e2;
        }
        if (e2 == EMPTY_SET) {
            return e1;
        }
        return new LiveUnion(e1, e2);
    }

    public static <R, A extends R, B extends R> ObservableSet<R> intersection(ObservableSet<A> a, ObservableSet<B> b) {
        if (a == EMPTY_SET || b == EMPTY_SET) {
            return EMPTY_SET;
        }
        return new LiveIntersection(a, b);
    }

    private static final class LiveIntersection<T, A extends T, B extends T>
    extends ObservableSet<T> {
        private ObservableSet<A> a;
        private ObservableSet<B> b;

        public LiveIntersection(ObservableSet<A> a, ObservableSet<B> b) {
            this.a = a;
            this.b = b;
            this.dependsOn(a);
            this.dependsOn(b);
        }

        @Override
        protected ImmutableSet<T> compute() {
            return ImmutableSet.copyOf((Collection)Sets.intersection((Set)((Set)this.a.getValue()), (Set)((Set)this.b.getValue())));
        }
    }

    private static class LiveUnion<T, A extends T, B extends T>
    extends ObservableSet<T> {
        private ObservableSet<A> e1;
        private ObservableSet<B> e2;

        public LiveUnion(ObservableSet<A> e1, ObservableSet<B> e2) {
            this.e1 = e1;
            this.e2 = e2;
            this.dependsOn(e1);
            this.dependsOn(e2);
        }

        @Override
        protected ImmutableSet<T> compute() {
            return ImmutableSet.copyOf((Collection)Sets.union((Set)((Set)this.e1.getValue()), (Set)((Set)this.e2.getValue())));
        }
    }
}

