/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springsource.ide.eclipse.commons.livexp.core.AsyncLiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ObservableSet;

public class LiveSetVariable<T>
extends ObservableSet<T> {
    private boolean dirty = false;
    private Set<T> backingCollection;

    public LiveSetVariable() {
        this(AsyncLiveExpression.AsyncMode.SYNC);
    }

    public LiveSetVariable(AsyncLiveExpression.AsyncMode async) {
        this(new HashSet(), async);
    }

    public LiveSetVariable(Set<T> backingCollection) {
        this(backingCollection, AsyncLiveExpression.AsyncMode.SYNC);
    }

    public LiveSetVariable(Set<T> backingCollection, AsyncLiveExpression.AsyncMode async) {
        super(ImmutableSet.copyOf(backingCollection), AsyncLiveExpression.AsyncMode.SYNC, async);
        this.backingCollection = backingCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncRefresh() {
        LiveSetVariable liveSetVariable = this;
        synchronized (liveSetVariable) {
            if (!this.dirty) {
                return;
            }
            this.value = this.compute();
        }
        this.changed();
    }

    @Override
    protected synchronized ImmutableSet<T> compute() {
        return ImmutableSet.copyOf(this.backingCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T name) {
        LiveSetVariable liveSetVariable = this;
        synchronized (liveSetVariable) {
            if (this.backingCollection.contains(name)) {
                return;
            }
            this.backingCollection.add(name);
            this.dirty = true;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T name) {
        LiveSetVariable liveSetVariable = this;
        synchronized (liveSetVariable) {
            if (!this.backingCollection.contains(name)) {
                return;
            }
            this.backingCollection.remove(name);
            this.dirty = true;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(T[] elements) {
        LiveSetVariable liveSetVariable = this;
        synchronized (liveSetVariable) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T e = TArray[n2];
                this.dirty = this.backingCollection.add(e) || this.dirty;
                ++n2;
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<T> elements) {
        LiveSetVariable liveSetVariable = this;
        synchronized (liveSetVariable) {
            for (T e : elements) {
                boolean bl = this.dirty = this.backingCollection.add(e) || this.dirty;
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(Collection<T> newElements) {
        LiveSetVariable liveSetVariable = this;
        synchronized (liveSetVariable) {
            Iterator<T> iter = this.backingCollection.iterator();
            while (iter.hasNext()) {
                T oldElement = iter.next();
                if (newElements.contains(oldElement)) continue;
                iter.remove();
                this.dirty = true;
            }
            for (T newElement : newElements) {
                boolean bl = this.dirty = this.backingCollection.add(newElement) || this.dirty;
            }
        }
        this.refresh();
    }
}

