/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;

public abstract class AsyncLiveExpression<T>
extends LiveExpression<T> {
    private Job refreshJob;
    private Job eventsJob;
    private long refreshDelay = 0L;

    public AsyncLiveExpression(T initialValue) {
        this(initialValue, AsyncMode.ASYNC, AsyncMode.SYNC);
    }

    public AsyncLiveExpression(T initialValue, AsyncMode refreshMode, AsyncMode eventsMode) {
        this(initialValue, refreshMode == AsyncMode.ASYNC ? "AsyncLiveExpression refresh" : null, eventsMode == AsyncMode.ASYNC ? "AsyncLiveExpression notify" : null);
    }

    public AsyncLiveExpression(T initialValue, String refreshJobName) {
        this(initialValue, refreshJobName, null);
    }

    public AsyncLiveExpression(T initialValue, String refreshJobName, String eventsJobName) {
        super(initialValue);
        if (refreshJobName != null) {
            this.refreshJob = new Job(refreshJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    AsyncLiveExpression.this.syncRefresh();
                    return Status.OK_STATUS;
                }
            };
        }
        if (eventsJobName != null) {
            this.eventsJob = new Job(eventsJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    AsyncLiveExpression.this.syncChanged();
                    return Status.OK_STATUS;
                }
            };
        }
    }

    @Override
    public final void refresh() {
        if (this.refreshJob != null) {
            this.refreshJob.schedule(this.refreshDelay);
        } else {
            this.syncRefresh();
        }
    }

    protected void syncRefresh() {
        super.refresh();
    }

    @Override
    protected final void changed() {
        if (this.eventsJob != null) {
            this.eventsJob.schedule();
        } else {
            this.syncChanged();
        }
    }

    protected void syncChanged() {
        super.changed();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public static enum AsyncMode {
        SYNC,
        ASYNC;

    }
}

