/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.jdt.internal;

import java.io.File;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.analysis.IPreAnalysisContext;
import org.sonarlint.eclipse.jdt.internal.JavaProjectConfiguration;

public class JdtUtils {
    public void configure(IPreAnalysisContext context, IProgressMonitor monitor) {
        IProject project = (IProject)context.getProject().getResource();
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            this.configureJavaProject(javaProject, context);
        }
    }

    static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isValidJavaFile(IFile file) {
        boolean hasJavaNature = JdtUtils.hasJavaNature(file.getProject());
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        IJavaElement javaElt = JavaCore.create((IFile)file);
        return javaElt == null || hasJavaNature && JdtUtils.isStructureKnown(javaElt) && javaProject.isOnClasspath(javaElt);
    }

    private static boolean isStructureKnown(IJavaElement javaElt) {
        try {
            return javaElt.isStructureKnown();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public void configureJavaProject(IJavaProject javaProject, IPreAnalysisContext context) {
        String javaSource = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String javaTarget = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        context.setAnalysisProperty("sonar.java.source", javaSource);
        context.setAnalysisProperty("sonar.java.target", javaTarget);
        try {
            JavaProjectConfiguration configuration = new JavaProjectConfiguration();
            configuration.dependentProjects().add(javaProject);
            JdtUtils.addClassPathToSonarProject(javaProject, configuration, true);
            JdtUtils.configurationToProperties(context, configuration);
        }
        catch (JavaModelException e) {
            SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private static void addClassPathToSonarProject(IJavaProject javaProject, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        IClasspathEntry[] classPath;
        IClasspathEntry[] iClasspathEntryArray = classPath = javaProject.getResolvedClasspath(true);
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 3: {
                    JdtUtils.processSourceEntry(entry, context, topProject);
                    break;
                }
                case 1: {
                    JdtUtils.processLibraryEntry(entry, javaProject, context, topProject);
                    break;
                }
                case 2: {
                    JdtUtils.processProjectEntry(entry, javaProject, context);
                    break;
                }
                default: {
                    SonarLintLogger.get().info("Unhandled ClassPathEntry : " + entry);
                }
            }
            ++n2;
        }
        JdtUtils.processOutputDir(javaProject.getOutputLocation(), context, topProject);
    }

    @CheckForNull
    protected static String getAbsolutePathAsString(IPath path) {
        IPath absolutePath = JdtUtils.getAbsolutePath(path);
        return absolutePath != null ? absolutePath.toString() : null;
    }

    @CheckForNull
    private static IPath getAbsolutePath(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res != null) {
            if (res.getLocation() != null) {
                return JdtUtils.pathIfExist(res.getLocation());
            }
            SonarLintLogger.get().error("Unable to resolve absolute path for " + res.getLocationURI());
            return null;
        }
        return JdtUtils.pathIfExist(path);
    }

    private static IPath pathIfExist(IPath path) {
        File file = path.toFile();
        if (file.exists()) {
            return path;
        }
        return null;
    }

    private static void processOutputDir(IPath outputDir, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        String outDir = JdtUtils.getAbsolutePathAsString(outputDir);
        if (outDir != null) {
            if (topProject) {
                context.binaries().add(outDir);
            } else {
                context.libraries().add(outDir);
            }
        } else {
            SonarLintLogger.get().info("Binary directory '" + outputDir + "' was not added because it was not found. Maybe you should enable auto build of your project.");
        }
    }

    private static void processSourceEntry(IClasspathEntry entry, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        if (JdtUtils.isSourceExcluded(entry)) {
            return;
        }
        if (entry.getOutputLocation() != null) {
            JdtUtils.processOutputDir(entry.getOutputLocation(), context, topProject);
        }
    }

    private static void processLibraryEntry(IClasspathEntry entry, IJavaProject javaProject, JavaProjectConfiguration context, boolean topProject) throws JavaModelException {
        String libPath;
        if ((topProject || entry.isExported()) && (libPath = JdtUtils.resolveLibrary(javaProject, entry)) != null) {
            context.libraries().add(libPath);
        }
    }

    private static void processProjectEntry(IClasspathEntry entry, IJavaProject javaProject, JavaProjectConfiguration context) throws JavaModelException {
        IJavaModel javaModel = javaProject.getJavaModel();
        IJavaProject referredProject = javaModel.getJavaProject(entry.getPath().segment(0));
        if (!context.dependentProjects().contains(referredProject)) {
            context.dependentProjects().add(referredProject);
            JdtUtils.addClassPathToSonarProject(referredProject, context, false);
        }
    }

    private static String resolveLibrary(IJavaProject javaProject, IClasspathEntry entry) {
        IResource member = JdtUtils.findPath(javaProject.getProject(), entry.getPath());
        String libPath = member != null ? member.getLocation().toOSString() : entry.getPath().makeAbsolute().toOSString();
        if (!new File(libPath).exists()) {
            return null;
        }
        return libPath.endsWith(File.separator) ? libPath.substring(0, libPath.length() - 1) : libPath;
    }

    private static IResource findPath(IProject project, IPath path) {
        IResource member = project.findMember(path);
        if (member == null) {
            IWorkspaceRoot workSpaceRoot = project.getWorkspace().getRoot();
            member = workSpaceRoot.findMember(path);
        }
        return member;
    }

    private static boolean isSourceExcluded(IClasspathEntry entry) {
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        if (exclusionPatterns != null) {
            IPath[] iPathArray = exclusionPatterns;
            int n = exclusionPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                IPath exclusionPattern = iPathArray[n2];
                if ("**".equals(exclusionPattern.toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void configurationToProperties(IPreAnalysisContext analysisContext, JavaProjectConfiguration context) {
        analysisContext.setAnalysisProperty("sonar.libraries", context.libraries());
        analysisContext.setAnalysisProperty("sonar.java.libraries", context.libraries());
        analysisContext.setAnalysisProperty("sonar.java.test.libraries", context.libraries());
        analysisContext.setAnalysisProperty("sonar.binaries", context.binaries());
        analysisContext.setAnalysisProperty("sonar.java.binaries", context.binaries());
        analysisContext.setAnalysisProperty("sonar.java.test.binaries", context.binaries());
    }
}

