/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.jdt.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.core.analysis.IAnalysisConfigurator;
import org.sonarlint.eclipse.core.analysis.IPreAnalysisContext;
import org.sonarlint.eclipse.core.resource.ISonarLintFileAdapterParticipant;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.jdt.internal.JdtUtils;

public class JavaProjectConfiguratorExtension
implements IAnalysisConfigurator,
ISonarLintFileAdapterParticipant {
    private final JdtUtils javaProjectConfigurator;
    private boolean jdtPresent = JavaProjectConfiguratorExtension.isJdtPresent();

    public JavaProjectConfiguratorExtension() {
        this.javaProjectConfigurator = this.jdtPresent ? new JdtUtils() : null;
    }

    private static boolean isJdtPresent() {
        try {
            Class.forName("org.eclipse.jdt.core.JavaCore");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean canConfigure(ISonarLintProject project) {
        return this.jdtPresent && project.getResource() instanceof IProject && JdtUtils.hasJavaNature((IProject)project.getResource());
    }

    public void configure(IPreAnalysisContext context, IProgressMonitor monitor) {
        this.javaProjectConfigurator.configure(context, monitor);
    }

    public boolean exclude(IFile file) {
        if (this.jdtPresent) {
            return !JdtUtils.isValidJavaFile(file);
        }
        return false;
    }
}

