/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.cdt.internal;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarlint.eclipse.cdt.internal.ConfiguredFile;

public class BuildWrapperJsonFactory {
    private static final String COMPILER = "clang";

    public String create(Collection<ConfiguredFile> files, String baseDirPath) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"version\":0,\"captures\":[");
        boolean first = true;
        for (ConfiguredFile file : files) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            BuildWrapperJsonFactory.writeFile(builder, baseDirPath, file.path(), file.includes(), file.symbols());
        }
        builder.append("]}");
        return builder.toString();
    }

    private static void writeFile(StringBuilder builder, String baseDirPath, String filePath, String[] includes, Map<String, String> symbols) {
        String probeStdout = BuildWrapperJsonFactory.probeStdout(symbols);
        String probeStderr = BuildWrapperJsonFactory.probeStderr(includes);
        BuildWrapperJsonFactory.writeCompilerProbe(builder, filePath, probeStdout, probeStderr);
        builder.append(",");
        BuildWrapperJsonFactory.writeCompilerProbe(builder, filePath, probeStdout, probeStderr);
        builder.append(",");
        builder.append("{").append("\"compiler\":\"clang\",").append("\"cwd\":" + BuildWrapperJsonFactory.quote(baseDirPath) + ",").append("\"executable\":" + BuildWrapperJsonFactory.quote(filePath) + ",").append("\"cmd\":[").append("\"clang\"").append("," + BuildWrapperJsonFactory.quote(filePath)).append("]}");
    }

    private static String probeStderr(String[] includes) {
        StringBuilder builder = new StringBuilder("#include <...> search starts here:\n");
        String[] stringArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            builder.append(" ").append(include).append("\n");
            ++n2;
        }
        builder.append("End of search list.\n");
        return builder.toString();
    }

    private static String probeStdout(Map<String, String> symbols) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> symbol : symbols.entrySet()) {
            builder.append("#define " + symbol.getKey() + " " + symbol.getValue()).append("\n");
        }
        return builder.toString();
    }

    private static void writeCompilerProbe(StringBuilder builder, String compilerKey, String stdout, String stderr) {
        builder.append("{").append("\"compiler\":\"").append(COMPILER).append("\",").append("\"executable\":").append(BuildWrapperJsonFactory.quote(compilerKey)).append(",").append("\"stdout\":").append(BuildWrapperJsonFactory.quote(stdout)).append(",").append("\"stderr\":").append(BuildWrapperJsonFactory.quote(stderr)).append("}");
    }

    private static String quote(@Nullable String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }
}

