/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.configurator.Activator;
import org.springsource.ide.eclipse.commons.internal.configurator.ConfiguratorImporter;
import org.springsource.ide.eclipse.commons.ui.ICoreRunnable;
import org.springsource.ide.eclipse.commons.ui.UiStatusHandler;
import org.springsource.ide.eclipse.commons.ui.UiUtil;

public class ConfiguratorPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button browseButton;
    private Button configureButton;
    private TableViewer extensionViewer;
    private ConfiguratorImporter importer;
    private Button installButton;
    private boolean installEnabled;
    private Label searchLocationsLabel;
    private Button useDefaultUserLocationButton;
    private Text userLocationText;
    List<ConfigurableExtension> elements;

    public void init(IWorkbench workbench) {
        this.updateElements();
    }

    public boolean isInstallEnabled() {
        return this.installEnabled;
    }

    public boolean performOk() {
        if (this.useDefaultUserLocationButton.getSelection()) {
            Activator.getDefault().getPreferenceStore().setToDefault("org.springsource.ide.eclipse.commons.configurator.installPath");
        } else {
            Activator.getDefault().getPreferenceStore().setValue("org.springsource.ide.eclipse.commons.configurator.installPath", this.userLocationText.getText());
        }
        return super.performOk();
    }

    public void setInstallEnabled(boolean installEnabled) {
        this.installEnabled = installEnabled;
        this.updateSelection(this.extensionViewer.getSelection());
        if (!installEnabled) {
            this.setMessage("Install Location is not set to a writeable directory. Installations are disabled.", 2);
        } else {
            this.setMessage(null);
        }
    }

    private void doRefresh() {
        this.updateElements();
        this.extensionViewer.setInput((Object)this.elements.toArray());
    }

    private ConfigurableExtension getSelectedExtension(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        ConfigurableExtension extension = (ConfigurableExtension)structuredSelection.getFirstElement();
        return extension;
    }

    private void handleResult(ConfigurableExtension extension, IStatus[] status) {
        if (status[0] != null) {
            if (!status[0].isOK()) {
                StatusManager.getManager().handle(status[0], 3);
            } else {
                MessageDialog.openInformation((Shell)UiUtil.getShell(), (String)"Auto Configuration", (String)status[0].getMessage());
            }
            extension.postConfiguration(status[0]);
        }
    }

    private void initWidgets() {
        this.resetUserLocation();
        this.useDefaultUserLocationButton.setSelection(this.userLocationText.getText().equals(this.getPreferenceStore().getDefaultString("org.springsource.ide.eclipse.commons.configurator.installPath")));
        this.userLocationText.setEnabled(!this.useDefaultUserLocationButton.getSelection());
        this.browseButton.setEnabled(!this.useDefaultUserLocationButton.getSelection());
        if (this.searchLocationsLabel != null) {
            this.searchLocationsLabel.setText(StringUtils.collectionToDelimitedString(this.importer.getSearchLocations(), (String)", "));
        }
    }

    private void resetUserLocation() {
        File location = this.importer.getInstallLocation();
        if (location != null) {
            this.userLocationText.setText(location.getAbsolutePath());
        } else {
            this.userLocationText.setText("");
            this.setInstallEnabled(false);
        }
    }

    private void updateElements() {
        this.elements = new ArrayList<ConfigurableExtension>();
        this.importer = new ConfiguratorImporter();
        this.importer.setFirstMatchOnly(false);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ConfiguratorPreferencesPage.this.elements.addAll(ConfiguratorPreferencesPage.this.importer.detectExtensions(monitor));
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "An error occurred loading configurable items", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = new Label(composite, 64);
        label.setText("Configurable Extensions:");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)label);
        this.extensionViewer = new TableViewer(composite, 68100);
        this.extensionViewer.getTable().setHeaderVisible(true);
        this.extensionViewer.getTable().setLinesVisible(true);
        this.extensionViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = ((ConfigurableExtension)e1).getLabel();
                String name2 = ((ConfigurableExtension)e2).getLabel();
                return this.getComparator().compare(name1, name2);
            }
        });
        this.extensionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            Object[] elements;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.elements = (Object[])newInput;
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.extensionViewer.getControl());
        TableViewerColumn statusColumn = new TableViewerColumn(this.extensionViewer, 16384);
        statusColumn.getColumn().setText("");
        statusColumn.getColumn().setToolTipText("Configured");
        statusColumn.getColumn().setWidth(20);
        statusColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (((ConfigurableExtension)element).isConfigured()) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.COMPLETE);
                }
                return null;
            }

            public String getText(Object element) {
                return "";
            }
        });
        TableViewerColumn extensionColumn = new TableViewerColumn(this.extensionViewer, 16384);
        extensionColumn.getColumn().setText("Extension");
        extensionColumn.getColumn().setWidth(250);
        extensionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ConfigurableExtension)element).getLabel();
            }
        });
        TableViewerColumn locationColumn = new TableViewerColumn(this.extensionViewer, 16384);
        locationColumn.getColumn().setText("Location");
        locationColumn.getColumn().setWidth(150);
        locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ConfigurableExtension)element).getLocation();
            }
        });
        this.extensionViewer.setInput((Object)this.elements.toArray());
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonComposite);
        RowLayout layout = new RowLayout(512);
        layout.fill = true;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        buttonComposite.setLayout((Layout)layout);
        this.configureButton = new Button(buttonComposite, 0);
        this.configureButton.setText(" &Configure ");
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfigurableExtension extension = ConfiguratorPreferencesPage.this.getSelectedExtension(ConfiguratorPreferencesPage.this.extensionViewer.getSelection());
                if (extension != null) {
                    ConfiguratorPreferencesPage.this.doConfigure(extension);
                }
            }
        });
        this.installButton = new Button(buttonComposite, 0);
        this.installButton.setText(" &Install ");
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ConfiguratorPreferencesPage.this.extensionViewer.getSelection();
                ConfigurableExtension extension = (ConfigurableExtension)selection.getFirstElement();
                if (extension != null) {
                    ConfiguratorPreferencesPage.this.doInstall(extension);
                }
            }
        });
        Button refreshButton = new Button(buttonComposite, 0);
        refreshButton.setText(" &Refresh ");
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfiguratorPreferencesPage.this.doRefresh();
            }
        });
        this.extensionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfiguratorPreferencesPage.this.updateSelection(event.getSelection());
            }
        });
        this.updateSelection(this.extensionViewer.getSelection());
        Group locationGroup = new Group(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)locationGroup);
        locationGroup.setText("Runtime Locations");
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)locationGroup);
        File systemLocation = this.importer.getSystemLocation();
        if (systemLocation != null) {
            label = new Label((Composite)locationGroup, 64);
            label.setText("Search path for runtimes:");
            GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).span(3, 1).applyTo((Control)label);
            this.searchLocationsLabel = new Label((Composite)locationGroup, 0);
            GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).span(3, 1).applyTo((Control)this.searchLocationsLabel);
        }
        this.useDefaultUserLocationButton = new Button((Composite)locationGroup, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.useDefaultUserLocationButton);
        this.useDefaultUserLocationButton.setText("Use Default");
        this.useDefaultUserLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfiguratorPreferencesPage.this.userLocationText.setEnabled(!ConfiguratorPreferencesPage.this.useDefaultUserLocationButton.getSelection());
                ConfiguratorPreferencesPage.this.browseButton.setEnabled(!ConfiguratorPreferencesPage.this.useDefaultUserLocationButton.getSelection());
                if (ConfiguratorPreferencesPage.this.useDefaultUserLocationButton.getSelection()) {
                    ConfiguratorPreferencesPage.this.resetUserLocation();
                }
            }
        });
        label = new Label((Composite)locationGroup, 64);
        label.setText("Install Location:");
        this.userLocationText = new Text((Composite)locationGroup, 2048);
        this.userLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    File file = new File(ConfiguratorPreferencesPage.this.userLocationText.getText());
                    if (!file.canWrite()) {
                        ConfiguratorPreferencesPage.this.setErrorMessage(NLS.bind((String)"''{0}'' is not writeable. Please select a different directory.", (Object)ConfiguratorPreferencesPage.this.userLocationText.getText()));
                        ConfiguratorPreferencesPage.this.setInstallEnabled(false);
                    } else {
                        ConfiguratorPreferencesPage.this.setErrorMessage(null);
                        ConfiguratorPreferencesPage.this.setInstallEnabled(true);
                    }
                }
                catch (Exception e) {
                    ConfiguratorPreferencesPage.this.setErrorMessage(NLS.bind((String)"''{0}'' is not a valid path.", (Object)ConfiguratorPreferencesPage.this.userLocationText.getText()));
                    ConfiguratorPreferencesPage.this.setInstallEnabled(false);
                }
            }
        });
        this.browseButton = new Button((Composite)locationGroup, 0);
        this.browseButton.setText("Directory...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ConfiguratorPreferencesPage.this.getShell());
                dialog.setMessage("Select the root directory for installing extensions.");
                String path = ConfiguratorPreferencesPage.this.userLocationText.getText();
                path = path.replaceAll("\\\\", "/");
                dialog.setFilterPath(path);
                path = dialog.open();
                if (path == null || path.equals("")) {
                    return;
                }
                path = path.replaceAll("\\\\", "/");
                ConfiguratorPreferencesPage.this.userLocationText.setText(path);
            }
        });
        this.initWidgets();
        return composite;
    }

    protected void doConfigure(final ConfigurableExtension extension) {
        try {
            final IStatus[] status = new IStatus[1];
            UiUtil.busyCursorWhile((ICoreRunnable)new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    status[0] = extension.configure(monitor);
                }
            });
            this.handleResult(extension, status);
            this.doRefresh();
        }
        catch (OperationCanceledException status) {
        }
        catch (CoreException e) {
            UiStatusHandler.logAndDisplay((IStatus)e.getStatus());
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void doInstall(final ConfigurableExtension extension) {
        final File installDirectory = new File(this.userLocationText.getText());
        if (!installDirectory.canWrite()) {
            UiStatusHandler.logAndDisplay((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Installation failed. The directory ''{0}'' is not writeable.", (Object)this.userLocationText.getText())));
            return;
        }
        try {
            final IStatus[] status = new IStatus[1];
            UiUtil.busyCursorWhile((ICoreRunnable)new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    status[0] = extension.install(installDirectory, monitor);
                    if (status[0].getSeverity() != 4) {
                        IStatus configurationStatus = extension.configure(monitor);
                        if (status[0].getSeverity() != 0) {
                            MultiStatus result = new MultiStatus("org.springsource.ide.eclipse.commons.configurator", 0, NLS.bind((String)"The installation of {0} generated warning. See error log for details.", (Object)extension.getLabel()), null);
                            result.add(status[0]);
                            result.add(configurationStatus);
                            status[0] = result;
                        } else {
                            status[0] = configurationStatus;
                        }
                    }
                }
            });
            this.handleResult(extension, status);
            this.doRefresh();
        }
        catch (OperationCanceledException status) {
        }
        catch (CoreException e) {
            UiStatusHandler.logAndDisplay((IStatus)e.getStatus());
        }
    }

    protected void performApply() {
        super.performApply();
        this.doRefresh();
        this.initWidgets();
    }

    protected void performDefaults() {
        super.performDefaults();
        Activator.getDefault().getPreferenceStore().setToDefault("org.springsource.ide.eclipse.commons.configurator.installPath");
        this.doRefresh();
        this.initWidgets();
    }

    protected void updateSelection(ISelection selection) {
        this.configureButton.setEnabled(!selection.isEmpty());
        ConfigurableExtension extension = this.getSelectedExtension(selection);
        this.installButton.setEnabled(extension != null && extension.isInstallable() && this.isInstallEnabled());
    }
}

