/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.osgi.framework.Version;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.configurator.IConfigurationContext;
import org.springsource.ide.eclipse.commons.configurator.WorkspaceConfiguratorParticipant;
import org.springsource.ide.eclipse.commons.core.FileUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.configurator.Activator;
import org.springsource.ide.eclipse.commons.internal.configurator.Configurator;
import org.springsource.ide.eclipse.commons.internal.configurator.IConfigurator;
import org.springsource.ide.eclipse.commons.internal.configurator.InstallableItem;
import org.springsource.ide.eclipse.commons.internal.configurator.ParticipantDescriptor;
import org.springsource.ide.eclipse.commons.ui.IIdeUiStartup;

public class ConfiguratorImporter
implements IIdeUiStartup,
IConfigurationContext,
IConfigurator {
    private static final CountDownLatch lazyStartupJobLatch = new CountDownLatch(1);
    private static final String SAMPLES_PATH = "samples";
    private boolean firstMatchOnly;
    private boolean recurse;
    private List<File> searchLocations;
    private boolean scanInstallPath;

    public static CountDownLatch getLazyStartupJobLatch() {
        return lazyStartupJobLatch;
    }

    public static boolean matches(String name, String path, VersionRange versionRange) {
        if (path == null || !name.startsWith(path)) {
            return false;
        }
        Version version = ConfiguratorImporter.getVersion(name);
        if (version != null && versionRange != null) {
            return versionRange.isIncluded(version);
        }
        return true;
    }

    private static File getFileFromLocation(Location userLocation) {
        if (userLocation != null) {
            return new File(userLocation.getURL().getFile());
        }
        return null;
    }

    private static Version getVersion(String name) {
        int i = name.lastIndexOf("-");
        if (i != -1) {
            try {
                return new Version(name.substring(i + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Version.emptyVersion;
    }

    public ConfiguratorImporter() {
        this.setRecurse(false);
        this.setFirstMatchOnly(true);
        this.setScanInstallPath(true);
    }

    public boolean isScanInstallPath() {
        return this.scanInstallPath;
    }

    public void setScanInstallPath(boolean scanInstallPath) {
        this.scanInstallPath = scanInstallPath;
    }

    public List<ConfigurableExtension> detectExtensions(final IProgressMonitor monitor) {
        final ArrayList<ConfigurableExtension> result = new ArrayList<ConfigurableExtension>();
        Set<WorkspaceConfiguratorParticipant> participants = ParticipantExtensionPointReader.getParticipants();
        for (final WorkspaceConfiguratorParticipant participant : participants) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    List<ConfigurableExtension> extensions = participant.detectExtensions(ConfiguratorImporter.this, monitor);
                    result.addAll(extensions);
                }
            });
        }
        Set<InstallableItem> installableItems = ParticipantExtensionPointReader.getInstallableItems();
        block1: for (final InstallableItem item : installableItems) {
            boolean found = false;
            for (ConfigurableExtension extension : result) {
                if (!extension.getId().equals(item.getId())) continue;
                extension.setInstallableItem(item);
                found = true;
            }
            if (found) continue;
            for (final WorkspaceConfiguratorParticipant participant : participants) {
                if (!participant.getId().equals(item.getConfiguratorId())) continue;
                final AtomicBoolean added = new AtomicBoolean(false);
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        ConfigurableExtension extension = participant.createExtension(item, monitor);
                        if (extension != null) {
                            result.add(extension);
                            added.set(true);
                        }
                    }
                });
                if (added.get()) continue block1;
            }
        }
        return result;
    }

    public File getDefaultInstallLocation() {
        List<File> locations = this.getSearchLocations();
        for (File location : locations) {
            if (!location.exists() || !location.canWrite()) continue;
            return location;
        }
        return null;
    }

    @Override
    public Set<String> getInstalledBundles() {
        final HashSet<String> installedBundles = new HashSet<String>();
        Set<WorkspaceConfiguratorParticipant> participants = ParticipantExtensionPointReader.getParticipants();
        for (final WorkspaceConfiguratorParticipant configurator : participants) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    List<ConfigurableExtension> extensions = configurator.detectExtensions(ConfiguratorImporter.this, (IProgressMonitor)new NullProgressMonitor());
                    for (ConfigurableExtension extension : extensions) {
                        if (extension.getBundleId() == null) continue;
                        installedBundles.add(String.valueOf(extension.getBundleId()) + ".feature.group");
                    }
                }
            });
        }
        return installedBundles;
    }

    public File getInstallLocation() {
        String path = Activator.getDefault().getPreferenceStore().getString("org.springsource.ide.eclipse.commons.configurator.installPath");
        return path != null ? new File(path) : null;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public List<File> getSearchLocations() {
        if (this.searchLocations == null) {
            String home;
            ArrayList<File> locations = new ArrayList<File>();
            File file = this.getSystemLocation();
            if (file != null) {
                locations.add(file);
            }
            if ((file = ConfiguratorImporter.getFileFromLocation(Platform.getUserLocation())) != null) {
                locations.add(file);
            }
            if ((home = System.getProperty("user.home")) != null) {
                locations.add(new File(home));
            }
            this.searchLocations = locations;
        }
        return this.searchLocations;
    }

    public File getSystemLocation() {
        File file = ConfiguratorImporter.getFileFromLocation(Platform.getInstallLocation());
        if (file != null && file.getParentFile() != null) {
            File auxFile;
            Pattern pattern;
            Matcher m;
            File systemLocation = file.getParentFile();
            if ("macosx".equals(Platform.getOS()) && (m = (pattern = Pattern.compile("(.+)/.*\\.app/Contents")).matcher(systemLocation.getAbsolutePath())).find() && (auxFile = new File(m.group(1))).exists()) {
                systemLocation = auxFile;
            }
            return systemLocation;
        }
        return null;
    }

    public boolean isFirstMatchOnly() {
        return this.firstMatchOnly;
    }

    @Override
    @Deprecated
    public boolean isInstalled(String bundleId) {
        return this.getInstalledBundles().contains(bundleId);
    }

    public void lazyStartup() {
        List<String> commandLineArgs = Arrays.asList(Platform.getCommandLineArgs());
        if (commandLineArgs.contains("-no-autoconfiguration")) {
            return;
        }
        if (Platform.getOS().equals("macosx")) {
            File upperCaseFile = new File(".", "STS.ini");
            File lowerCaseFile = new File(".", "sts.ini");
            if (upperCaseFile.exists() && !lowerCaseFile.exists()) {
                try {
                    FileUtil.copyFile((File)upperCaseFile, (File)lowerCaseFile, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Could not copy STS.ini to sts.ini", (Throwable)e));
                }
            }
        }
        final boolean configured = Activator.getDefault().getPreferenceStore().getBoolean("org.springsource.ide.eclipse.commons.configurator.processed");
        final boolean pendingRequests = StringUtils.hasLength((String)Activator.getDefault().getPreferenceStore().getString("org.springsource.ide.eclipse.commons.configurator.configuretargets"));
        if (configured && !pendingRequests) {
            return;
        }
        Job importJob = new Job("Workspace Configuration"){

            public IStatus run(IProgressMonitor monitor) {
                if (pendingRequests) {
                    Configurator action = new Configurator();
                    action.executePendingRequests();
                }
                if (configured) {
                    return Status.OK_STATUS;
                }
                Activator.getDefault().getPreferenceStore().setValue("org.springsource.ide.eclipse.commons.configurator.processed", true);
                boolean isShowOnActivity = ServerUIPlugin.getPreferences().getShowOnActivity();
                ServerUIPlugin.getPreferences().setShowOnActivity(false);
                List<File> samplesPath = ConfiguratorImporter.this.scan(ConfiguratorImporter.SAMPLES_PATH, null);
                if (samplesPath.size() > 0) {
                    File[] fileArray = samplesPath.get(0).listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File sample = fileArray[n2];
                        ConfiguratorImporter.this.createProject(monitor, sample);
                        ++n2;
                    }
                }
                List<ConfigurableExtension> extensions = ConfiguratorImporter.this.detectExtensions(monitor);
                for (ConfigurableExtension extension : extensions) {
                    if (!extension.isAutoConfigurable()) continue;
                    extension.configure(monitor);
                }
                ServerUIPlugin.getPreferences().setShowOnActivity(isShowOnActivity);
                lazyStartupJobLatch.countDown();
                return Status.OK_STATUS;
            }
        };
        importJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        importJob.schedule();
    }

    @Override
    public List<File> scan(String path, VersionRange versionRange) {
        ArrayList<File> matches = new ArrayList<File>();
        List<File> locations = this.getSearchLocations();
        if (this.isScanInstallPath() && !locations.contains(this.getInstallLocation())) {
            locations.add(0, this.getInstallLocation());
        }
        block0: for (File location : locations) {
            while (location != null) {
                File[] files = location.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isDirectory() && ConfiguratorImporter.matches(file.getName(), path, versionRange)) {
                            matches.add(file);
                        }
                        ++n2;
                    }
                }
                if (!matches.isEmpty() && this.firstMatchOnly) break block0;
                if (!this.recurse) continue block0;
                location = location.getParentFile();
            }
        }
        if (!matches.isEmpty()) {
            Collections.sort(matches, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    Version v1 = ConfiguratorImporter.getVersion(o1.getName());
                    Version v2 = ConfiguratorImporter.getVersion(o2.getName());
                    if (v1 == null) {
                        return v2 != null ? 1 : 0;
                    }
                    if (v2 == null) {
                        return -1;
                    }
                    return -v1.compareTo(v2);
                }
            });
            return matches;
        }
        return Collections.emptyList();
    }

    public void setFirstMatchOnly(boolean firstMatchOnly) {
        this.firstMatchOnly = firstMatchOnly;
    }

    public void setInstallLocation(File location) {
        Activator.getDefault().getPreferenceStore().setValue("org.springsource.ide.eclipse.commons.configurator.installPath", location.getAbsolutePath());
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setSearchLocations(List<File> searchLocations) {
        this.searchLocations = new ArrayList<File>(searchLocations);
    }

    private void createProject(IProgressMonitor monitor, File sample) {
        if (sample.isDirectory()) {
            try {
                IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription(new Path(sample.getAbsolutePath()).append(".project"));
                if (desc != null) {
                    String projectName = desc.getName();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(projectName);
                    project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "An error occurred creating project", (Throwable)e));
            }
        }
    }

    public static class ParticipantExtensionPointReader {
        private static final String ELEMENT_INSTALLABLEITEM = "installableItem";
        private static final String ELEMENT_PARTICIPANT = "participant";
        private static final String EXTENSION_ID_PARTICIPANT = "com.springsource.sts.ide.configurator.participant";

        public static Set<InstallableItem> getInstallableItems() {
            IExtension[] extensions;
            HashSet<InstallableItem> items = new HashSet<InstallableItem>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_PARTICIPANT);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_INSTALLABLEITEM)) {
                        InstallableItem ext = new InstallableItem(element);
                        items.add(ext);
                    }
                    ++n4;
                }
                ++n2;
            }
            return items;
        }

        public static Set<WorkspaceConfiguratorParticipant> getParticipants() {
            HashSet<WorkspaceConfiguratorParticipant> configurators = new HashSet<WorkspaceConfiguratorParticipant>();
            Set<ParticipantDescriptor> extensions = ParticipantExtensionPointReader.getPartipantExtensions();
            for (ParticipantDescriptor extension : extensions) {
                WorkspaceConfiguratorParticipant configurator = extension.createConfigurator();
                if (configurator == null) continue;
                configurators.add(configurator);
            }
            return configurators;
        }

        public static Set<ParticipantDescriptor> getPartipantExtensions() {
            IExtension[] extensions;
            HashSet<ParticipantDescriptor> configurators = new HashSet<ParticipantDescriptor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_PARTICIPANT);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_PARTICIPANT)) {
                        ParticipantDescriptor ext = new ParticipantDescriptor(element);
                        configurators.add(ext);
                    }
                    ++n4;
                }
                ++n2;
            }
            return configurators;
        }
    }
}

